/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.xjc.generator.bean.field;

import com.sun.codemodel.internal.JAnnotatable;
import com.sun.codemodel.internal.JClass;
import com.sun.codemodel.internal.JCodeModel;
import com.sun.codemodel.internal.JExpr;
import com.sun.codemodel.internal.JExpression;
import com.sun.codemodel.internal.JFieldVar;
import com.sun.codemodel.internal.JType;
import com.sun.tools.internal.xjc.generator.annotation.spec.XmlAnyElementWriter;
import com.sun.tools.internal.xjc.generator.annotation.spec.XmlAttributeWriter;
import com.sun.tools.internal.xjc.generator.annotation.spec.XmlElementRefWriter;
import com.sun.tools.internal.xjc.generator.annotation.spec.XmlElementRefsWriter;
import com.sun.tools.internal.xjc.generator.annotation.spec.XmlElementWriter;
import com.sun.tools.internal.xjc.generator.annotation.spec.XmlElementsWriter;
import com.sun.tools.internal.xjc.generator.bean.ClassOutlineImpl;
import com.sun.tools.internal.xjc.model.CAttributePropertyInfo;
import com.sun.tools.internal.xjc.model.CElement;
import com.sun.tools.internal.xjc.model.CElementInfo;
import com.sun.tools.internal.xjc.model.CElementPropertyInfo;
import com.sun.tools.internal.xjc.model.CPropertyInfo;
import com.sun.tools.internal.xjc.model.CReferencePropertyInfo;
import com.sun.tools.internal.xjc.model.CTypeInfo;
import com.sun.tools.internal.xjc.model.CTypeRef;
import com.sun.tools.internal.xjc.model.CValuePropertyInfo;
import com.sun.tools.internal.xjc.model.nav.NType;
import com.sun.tools.internal.xjc.outline.Aspect;
import com.sun.tools.internal.xjc.outline.ClassOutline;
import com.sun.tools.internal.xjc.outline.FieldAccessor;
import com.sun.tools.internal.xjc.outline.FieldOutline;
import com.sun.tools.internal.xjc.reader.TypeUtil;
import com.sun.xml.internal.bind.v2.TODO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.xml.bind.annotation.W3CDomHandler;
import javax.xml.bind.annotation.XmlList;
import javax.xml.bind.annotation.XmlMixed;
import javax.xml.bind.annotation.XmlNsForm;
import javax.xml.bind.annotation.XmlValue;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractField
implements FieldOutline {
    protected final ClassOutlineImpl outline;
    protected final CPropertyInfo prop;
    protected final JCodeModel codeModel;
    protected final JType implType;
    protected final JType exposedType;
    private XmlElementsWriter xesw = null;

    protected AbstractField(ClassOutlineImpl classOutlineImpl, CPropertyInfo cPropertyInfo) {
        this.outline = classOutlineImpl;
        this.prop = cPropertyInfo;
        this.codeModel = classOutlineImpl.parent().getCodeModel();
        this.implType = this.getType(Aspect.IMPLEMENTATION);
        this.exposedType = this.getType(Aspect.EXPOSED);
    }

    @Override
    public final ClassOutline parent() {
        return this.outline;
    }

    @Override
    public final CPropertyInfo getPropertyInfo() {
        return this.prop;
    }

    protected void annotate(JAnnotatable jAnnotatable) {
        assert (jAnnotatable != null);
        if (this.prop instanceof CAttributePropertyInfo) {
            this.annotateAttribute(jAnnotatable);
        } else if (this.prop instanceof CElementPropertyInfo) {
            this.annotateElement(jAnnotatable);
        } else if (this.prop instanceof CValuePropertyInfo) {
            jAnnotatable.annotate(XmlValue.class);
        } else if (this.prop instanceof CReferencePropertyInfo) {
            this.annotateReference(jAnnotatable);
        }
        this.outline.parent().generateAdapterIfNecessary(this.prop, jAnnotatable);
    }

    private void annotateReference(JAnnotatable jAnnotatable) {
        Object object;
        CReferencePropertyInfo cReferencePropertyInfo = (CReferencePropertyInfo)this.prop;
        TODO.prototype();
        Set<CElement> set = cReferencePropertyInfo.getElements();
        if (set.size() == 1) {
            XmlElementRefWriter xmlElementRefWriter = jAnnotatable.annotate2(XmlElementRefWriter.class);
            object = (CElement)set.iterator().next();
            xmlElementRefWriter.name(object.getElementName().getLocalPart()).namespace(object.getElementName().getNamespaceURI()).type(((NType)object.getType()).toType(this.outline.parent(), Aspect.IMPLEMENTATION));
        } else if (set.size() > 1) {
            object = jAnnotatable.annotate2(XmlElementRefsWriter.class);
            for (CElement object2 : set) {
                XmlElementRefWriter xmlElementRefWriter = object.value();
                xmlElementRefWriter.name(object2.getElementName().getLocalPart()).namespace(object2.getElementName().getNamespaceURI()).type(((NType)object2.getType()).toType(this.outline.parent(), Aspect.IMPLEMENTATION));
            }
        }
        if (cReferencePropertyInfo.isMixed()) {
            jAnnotatable.annotate(XmlMixed.class);
        }
        if ((object = cReferencePropertyInfo.getDOMHandler()) != null) {
            XmlAnyElementWriter xmlAnyElementWriter = jAnnotatable.annotate2(XmlAnyElementWriter.class);
            xmlAnyElementWriter.lax(cReferencePropertyInfo.getWildcard().allowTypedObject);
            JClass jClass = object.toType(this.outline.parent(), Aspect.IMPLEMENTATION);
            if (!jClass.equals(this.codeModel.ref(W3CDomHandler.class))) {
                xmlAnyElementWriter.value(jClass);
            }
        }
    }

    private void annotateElement(JAnnotatable jAnnotatable) {
        CElementPropertyInfo cElementPropertyInfo = (CElementPropertyInfo)this.prop;
        List<CTypeRef> list = cElementPropertyInfo.getTypes();
        if (cElementPropertyInfo.isValueList()) {
            jAnnotatable.annotate(XmlList.class);
        }
        assert (cElementPropertyInfo.getXmlName() == null);
        if (list.size() == 1) {
            CTypeRef cTypeRef = list.get(0);
            this.writeXmlElementAnnotation(jAnnotatable, cTypeRef, this.resolve(cTypeRef, Aspect.IMPLEMENTATION), false);
        } else {
            for (CTypeRef cTypeRef : list) {
                this.writeXmlElementAnnotation(jAnnotatable, cTypeRef, this.resolve(cTypeRef, Aspect.IMPLEMENTATION), true);
            }
            this.xesw = null;
        }
    }

    private void writeXmlElementAnnotation(JAnnotatable jAnnotatable, CTypeRef cTypeRef, JType jType, boolean bl) {
        String string;
        CElementPropertyInfo cElementPropertyInfo;
        XmlElementWriter xmlElementWriter = null;
        XmlNsForm xmlNsForm = this.parent()._package().getElementFormDefault();
        String string2 = this.parent()._package().getMostUsedNamespaceURI();
        String string3 = this.prop.getName(false);
        String string4 = cTypeRef.getTagName().getLocalPart();
        if (!string4.equals(string3)) {
            if (xmlElementWriter == null) {
                xmlElementWriter = this.getXew(bl, jAnnotatable);
            }
            xmlElementWriter.name(string4);
        }
        String string5 = cTypeRef.getTagName().getNamespaceURI();
        if (xmlNsForm == XmlNsForm.QUALIFIED && !string5.equals(string2) || xmlNsForm == XmlNsForm.UNQUALIFIED && !string5.equals("")) {
            if (xmlElementWriter == null) {
                xmlElementWriter = this.getXew(bl, jAnnotatable);
            }
            xmlElementWriter.namespace(string5);
        }
        if ((cElementPropertyInfo = (CElementPropertyInfo)this.prop).isRequired() && this.exposedType.isReference()) {
            if (xmlElementWriter == null) {
                xmlElementWriter = this.getXew(bl, jAnnotatable);
            }
            xmlElementWriter.required(true);
        }
        if (cElementPropertyInfo.isRequired() && !this.prop.isCollection()) {
            jType = jType.unboxify();
        }
        if (!jType.equals(this.exposedType) || this.parent().parent().getModel().options.runtime14 && this.prop.isCollection()) {
            if (xmlElementWriter == null) {
                xmlElementWriter = this.getXew(bl, jAnnotatable);
            }
            xmlElementWriter.type(jType);
        }
        if ((string = cTypeRef.getDefaultValue()) != null) {
            if (xmlElementWriter == null) {
                xmlElementWriter = this.getXew(bl, jAnnotatable);
            }
            xmlElementWriter.defaultValue(string);
        }
        if (cTypeRef.isNillable()) {
            if (xmlElementWriter == null) {
                xmlElementWriter = this.getXew(bl, jAnnotatable);
            }
            xmlElementWriter.nillable(true);
        }
    }

    private XmlElementWriter getXew(boolean bl, JAnnotatable jAnnotatable) {
        XmlElementWriter xmlElementWriter;
        if (bl) {
            if (this.xesw == null) {
                this.xesw = jAnnotatable.annotate2(XmlElementsWriter.class);
            }
            xmlElementWriter = this.xesw.value();
        } else {
            xmlElementWriter = jAnnotatable.annotate2(XmlElementWriter.class);
        }
        return xmlElementWriter;
    }

    private void annotateAttribute(JAnnotatable jAnnotatable) {
        CAttributePropertyInfo cAttributePropertyInfo = (CAttributePropertyInfo)this.prop;
        QName qName = cAttributePropertyInfo.getXmlName();
        XmlAttributeWriter xmlAttributeWriter = jAnnotatable.annotate2(XmlAttributeWriter.class);
        String string = qName.getLocalPart();
        String string2 = qName.getNamespaceURI();
        if (!string.equals(cAttributePropertyInfo.getName(false))) {
            xmlAttributeWriter.name(string);
        }
        if (!string2.equals("")) {
            xmlAttributeWriter.namespace(string2);
        }
        if (cAttributePropertyInfo.isRequired()) {
            xmlAttributeWriter.required(true);
        }
    }

    protected final JFieldVar generateField(JType jType) {
        return this.outline.implClass.field(2, jType, this.prop.getName(false));
    }

    protected final JExpression castToImplType(JExpression jExpression) {
        if (this.implType == this.exposedType) {
            return jExpression;
        }
        return JExpr.cast(this.implType, jExpression);
    }

    protected JType getType(final Aspect aspect) {
        if (this.prop.getAdapter() != null) {
            return ((NType)this.prop.getAdapter().customType).toType(this.outline.parent(), aspect);
        }
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        final class TypeList
        extends ArrayList<JType> {
            TypeList() {
            }

            void add(CTypeInfo cTypeInfo) {
                this.add(((NType)cTypeInfo.getType()).toType(AbstractField.this.outline.parent(), aspect));
                if (cTypeInfo instanceof CElementInfo) {
                    this.add(((CElementInfo)cTypeInfo).getSubstitutionMembers());
                }
            }

            void add(Collection<? extends CTypeInfo> collection) {
                for (CTypeInfo cTypeInfo : collection) {
                    this.add(cTypeInfo);
                }
            }
        }
        TypeList typeList = new TypeList();
        typeList.add(this.prop.ref());
        JType jType = this.prop.baseType != null ? this.prop.baseType : TypeUtil.getCommonBaseType(this.codeModel, typeList);
        if (this.prop.isUnboxable()) {
            jType = jType.unboxify();
        }
        return jType;
    }

    protected final List<Object> listPossibleTypes(CPropertyInfo cPropertyInfo) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (CTypeInfo cTypeInfo : cPropertyInfo.ref()) {
            JType jType = ((NType)cTypeInfo.getType()).toType(this.outline.parent(), Aspect.EXPOSED);
            if (jType.isPrimitive() || jType.isArray()) {
                arrayList.add(jType.fullName());
                continue;
            }
            arrayList.add(jType);
            arrayList.add("\n");
        }
        return arrayList;
    }

    private JType resolve(CTypeRef cTypeRef, Aspect aspect) {
        return this.outline.parent().resolve(cTypeRef, aspect);
    }

    protected abstract class Accessor
    implements FieldAccessor {
        protected final JExpression $target;

        protected Accessor(JExpression jExpression) {
            this.$target = jExpression;
        }

        public final FieldOutline owner() {
            return AbstractField.this;
        }

        public final CPropertyInfo getPropertyInfo() {
            return AbstractField.this.prop;
        }
    }
}

