/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.xjc.reader.dtd;

import com.sun.tools.internal.xjc.reader.dtd.Block;
import com.sun.tools.internal.xjc.reader.dtd.Term;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ModelGroup
extends Term {
    Kind kind;
    private final List<Term> terms = new ArrayList<Term>();

    ModelGroup() {
    }

    @Override
    void normalize(List<Block> list, boolean bl) {
        switch (this.kind) {
            case SEQUENCE: {
                for (Term term : this.terms) {
                    term.normalize(list, bl);
                }
                return;
            }
            case CHOICE: {
                Block block = new Block(this.isOptional() || bl, this.isRepeated());
                this.addAllElements(block);
                list.add(block);
                return;
            }
        }
    }

    @Override
    void addAllElements(Block block) {
        for (Term term : this.terms) {
            term.addAllElements(block);
        }
    }

    @Override
    boolean isOptional() {
        switch (this.kind) {
            case SEQUENCE: {
                for (Term term : this.terms) {
                    if (term.isOptional()) continue;
                    return false;
                }
                return true;
            }
            case CHOICE: {
                for (Term term : this.terms) {
                    if (!term.isOptional()) continue;
                    return true;
                }
                return false;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    boolean isRepeated() {
        switch (this.kind) {
            case SEQUENCE: {
                return true;
            }
            case CHOICE: {
                for (Term term : this.terms) {
                    if (!term.isRepeated()) continue;
                    return true;
                }
                return false;
            }
        }
        throw new IllegalArgumentException();
    }

    void setKind(short s) {
        Kind kind;
        switch (s) {
            case 1: {
                kind = Kind.SEQUENCE;
                break;
            }
            case 0: {
                kind = Kind.CHOICE;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        assert (this.kind == null || kind == this.kind);
        this.kind = kind;
    }

    void addTerm(Term term) {
        if (term instanceof ModelGroup) {
            ModelGroup modelGroup = (ModelGroup)term;
            if (modelGroup.kind == this.kind) {
                this.terms.addAll(modelGroup.terms);
                return;
            }
        }
        this.terms.add(term);
    }

    Term wrapUp() {
        switch (this.terms.size()) {
            case 0: {
                return EMPTY;
            }
            case 1: {
                assert (this.kind == null);
                return this.terms.get(0);
            }
        }
        assert (this.kind != null);
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Kind {
        CHOICE,
        SEQUENCE;

    }
}

