/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javap;

import com.sun.tools.classfile.AccessFlags;
import com.sun.tools.classfile.Attribute;
import com.sun.tools.classfile.Attributes;
import com.sun.tools.classfile.ClassFile;
import com.sun.tools.classfile.Code_attribute;
import com.sun.tools.classfile.ConstantPool;
import com.sun.tools.classfile.ConstantPoolException;
import com.sun.tools.classfile.ConstantValue_attribute;
import com.sun.tools.classfile.Descriptor;
import com.sun.tools.classfile.DescriptorException;
import com.sun.tools.classfile.Exceptions_attribute;
import com.sun.tools.classfile.Field;
import com.sun.tools.classfile.Method;
import com.sun.tools.classfile.Signature;
import com.sun.tools.classfile.Signature_attribute;
import com.sun.tools.classfile.SourceFile_attribute;
import com.sun.tools.classfile.Type;
import com.sun.tools.javap.AttributeWriter;
import com.sun.tools.javap.BasicWriter;
import com.sun.tools.javap.CodeWriter;
import com.sun.tools.javap.ConstantWriter;
import com.sun.tools.javap.Context;
import com.sun.tools.javap.Options;
import java.net.URI;
import java.text.DateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassWriter
extends BasicWriter {
    private Options options;
    private AttributeWriter attrWriter;
    private CodeWriter codeWriter;
    private ConstantWriter constantWriter;
    private ClassFile classFile;
    private URI uri;
    private long lastModified;
    private String digestName;
    private byte[] digest;
    private int size;
    private ConstantPool constant_pool;
    private Method method;
    private static final String NEWLINE = System.getProperty("line.separator", "\n");

    static ClassWriter instance(Context context) {
        ClassWriter classWriter = context.get(ClassWriter.class);
        if (classWriter == null) {
            classWriter = new ClassWriter(context);
        }
        return classWriter;
    }

    protected ClassWriter(Context context) {
        super(context);
        context.put(ClassWriter.class, this);
        this.options = Options.instance(context);
        this.attrWriter = AttributeWriter.instance(context);
        this.codeWriter = CodeWriter.instance(context);
        this.constantWriter = ConstantWriter.instance(context);
    }

    void setDigest(String string, byte[] byArray) {
        this.digestName = string;
        this.digest = byArray;
    }

    void setFile(URI uRI) {
        this.uri = uRI;
    }

    void setFileSize(int n) {
        this.size = n;
    }

    void setLastModified(long l) {
        this.lastModified = l;
    }

    ClassFile getClassFile() {
        return this.classFile;
    }

    Method getMethod() {
        return this.method;
    }

    public void write(ClassFile classFile) {
        Object object;
        Object object2;
        this.classFile = classFile;
        this.constant_pool = this.classFile.constant_pool;
        if ((this.options.sysInfo || this.options.verbose) && !this.options.compat) {
            if (this.uri != null) {
                if (this.uri.getScheme().equals("file")) {
                    this.println("Classfile " + this.uri.getPath());
                } else {
                    this.println("Classfile " + this.uri);
                }
            }
            if (this.lastModified != -1L) {
                object2 = new Date(this.lastModified);
                object = DateFormat.getDateInstance();
                if (this.size > 0) {
                    this.println("Last modified " + ((DateFormat)object).format((Date)object2) + "; size " + this.size + " bytes");
                } else {
                    this.println("Last modified " + ((DateFormat)object).format((Date)object2));
                }
            } else if (this.size > 0) {
                this.println("Size " + this.size + " bytes");
            }
            if (this.digestName != null && this.digest != null) {
                object2 = new StringBuilder();
                for (Object object3 : (Object)this.digest) {
                    ((StringBuilder)object2).append(String.format("%02x", (byte)object3));
                }
                this.println(this.digestName + " checksum " + object2);
            }
        }
        if ((object2 = classFile.getAttribute("SourceFile")) instanceof SourceFile_attribute) {
            this.println("Compiled from \"" + this.getSourceFile((SourceFile_attribute)object2) + "\"");
        }
        object = this.getJavaName(this.classFile);
        AccessFlags accessFlags = classFile.access_flags;
        this.writeModifiers(accessFlags.getClassModifiers());
        if (this.classFile.isClass()) {
            this.print("class ");
        } else if (this.classFile.isInterface()) {
            this.print("interface ");
        }
        this.print((String)object);
        Signature_attribute signature_attribute = this.getSignature(classFile.attributes);
        if (signature_attribute == null) {
            if (this.classFile.isClass() && this.classFile.super_class != 0) {
                String string = this.getJavaSuperclassName(classFile);
                this.print(" extends ");
                this.print(string);
            }
            for (int i = 0; i < this.classFile.interfaces.length; ++i) {
                this.print(i == 0 ? (this.classFile.isClass() ? " implements " : " extends ") : ",");
                this.print(this.getJavaInterfaceName(this.classFile, i));
            }
        } else {
            try {
                Type type = signature_attribute.getParsedSignature().getType(this.constant_pool);
                if (type instanceof Type.ClassSigType) {
                    this.print(type);
                }
                this.print(" extends ");
                this.print(type);
            }
            catch (ConstantPoolException constantPoolException) {
                this.print(this.report(constantPoolException));
            }
        }
        if (this.options.verbose) {
            this.println();
            this.attrWriter.write((Object)classFile, classFile.attributes, this.constant_pool);
            this.println("  minor version: " + classFile.minor_version);
            this.println("  major version: " + classFile.major_version);
            if (!this.options.compat) {
                this.writeList("  flags: ", accessFlags.getClassFlags(), NEWLINE);
            }
            this.constantWriter.writeConstantPool();
            this.println();
        } else if (!this.options.compat) {
            this.print(" ");
        }
        this.println("{");
        this.writeFields();
        this.writeMethods();
        this.println("}");
        this.println();
    }

    void writeFields() {
        for (Field field : this.classFile.fields) {
            this.writeField(field);
        }
    }

    void writeField(Field field) {
        Iterator<Attribute> iterator;
        if (!this.options.checkAccess(field.access_flags)) {
            return;
        }
        if (!(this.options.showLineAndLocalVariableTables || this.options.showDisassembled || this.options.verbose || this.options.showInternalSignatures || this.options.showAllAttrs)) {
            this.print("    ");
        }
        AccessFlags accessFlags = field.access_flags;
        this.writeModifiers(accessFlags.getFieldModifiers());
        Signature_attribute signature_attribute = this.getSignature(field.attributes);
        if (signature_attribute == null) {
            this.print(this.getFieldType(field.descriptor));
        } else {
            try {
                iterator = signature_attribute.getParsedSignature().getType(this.constant_pool);
                this.print(iterator);
            }
            catch (ConstantPoolException constantPoolException) {
                this.print(this.getFieldType(field.descriptor));
            }
        }
        this.print(" ");
        this.print(this.getFieldName(field));
        if (this.options.showConstants && !this.options.compat && (iterator = field.attributes.get("ConstantValue")) instanceof ConstantValue_attribute) {
            this.print(" = ");
            Attribute attribute = (ConstantValue_attribute)((Object)iterator);
            this.print(this.getConstantValue(field.descriptor, attribute.constantvalue_index));
        }
        this.print(";");
        this.println();
        if (this.options.showInternalSignatures) {
            this.println("  Signature: " + this.getValue(field.descriptor));
        }
        if (this.options.verbose && !this.options.compat) {
            this.writeList("  flags: ", accessFlags.getFieldFlags(), NEWLINE);
        }
        if (this.options.showAllAttrs) {
            for (Attribute attribute : field.attributes) {
                this.attrWriter.write((Object)field, attribute, this.constant_pool);
            }
            this.println();
        }
        if (this.options.showDisassembled || this.options.showLineAndLocalVariableTables) {
            this.println();
        }
    }

    void writeMethods() {
        for (Method method : this.classFile.methods) {
            this.writeMethod(method);
        }
    }

    void writeMethod(Method method) {
        Attribute attribute;
        Object object;
        List<? extends Type> list;
        Type.MethodType methodType;
        Descriptor descriptor;
        if (!this.options.checkAccess(method.access_flags)) {
            return;
        }
        this.method = method;
        if (!(this.options.showLineAndLocalVariableTables || this.options.showDisassembled || this.options.verbose || this.options.showInternalSignatures || this.options.showAllAttrs)) {
            this.print("    ");
        }
        AccessFlags accessFlags = method.access_flags;
        Signature_attribute signature_attribute = this.getSignature(method.attributes);
        if (signature_attribute == null) {
            descriptor = method.descriptor;
            methodType = null;
            list = null;
        } else {
            object = signature_attribute.getParsedSignature();
            descriptor = object;
            try {
                methodType = (Type.MethodType)((Signature)object).getType(this.constant_pool);
                list = methodType.throwsTypes;
                if (list != null && list.size() == 0) {
                    list = null;
                }
            }
            catch (ConstantPoolException constantPoolException) {
                methodType = null;
                list = null;
            }
        }
        this.writeModifiers(accessFlags.getMethodModifiers());
        if (methodType != null) {
            this.writeListIfNotEmpty("<", methodType.typeArgTypes, "> ");
        }
        if (this.getName(method).equals("<init>")) {
            this.print(this.getJavaName(this.classFile));
            this.print(this.getParameterTypes(descriptor, accessFlags));
        } else if (this.getName(method).equals("<clinit>")) {
            this.print("{}");
        } else {
            this.print(this.getReturnType(descriptor));
            this.print(" ");
            this.print(this.getName(method));
            this.print(this.getParameterTypes(descriptor, accessFlags));
        }
        object = method.attributes.get("Exceptions");
        if (object != null) {
            if (object instanceof Exceptions_attribute) {
                attribute = (Exceptions_attribute)object;
                if (this.options.compat) {
                    if (!(this.options.showLineAndLocalVariableTables || this.options.showDisassembled || this.options.verbose || this.options.showInternalSignatures || this.options.showAllAttrs)) {
                        this.print("    ");
                    }
                    this.print("  ");
                }
                this.print(" throws ");
                if (list != null) {
                    this.writeList("", list, "");
                } else {
                    for (int i = 0; i < attribute.number_of_exceptions; ++i) {
                        if (i > 0) {
                            this.print(", ");
                        }
                        this.print(this.getJavaException((Exceptions_attribute)attribute, i));
                    }
                }
            } else {
                this.report("Unexpected or invalid value for Exceptions attribute");
            }
        }
        this.print(";");
        this.println();
        if (this.options.showInternalSignatures) {
            this.println("  Signature: " + this.getValue(method.descriptor));
        }
        if (this.options.verbose && !this.options.compat) {
            this.writeList("  flags: ", accessFlags.getMethodFlags(), NEWLINE);
        }
        attribute = null;
        Attribute attribute2 = method.attributes.get("Code");
        if (attribute2 != null) {
            if (attribute2 instanceof Code_attribute) {
                attribute = (Code_attribute)attribute2;
            } else {
                this.report("Unexpected or invalid value for Code attribute");
            }
        }
        if (this.options.showDisassembled && !this.options.showAllAttrs) {
            if (attribute != null) {
                this.println("  Code:");
                this.codeWriter.writeInstrs((Code_attribute)attribute);
                this.codeWriter.writeExceptionTable((Code_attribute)attribute);
            }
            this.println();
        }
        if (this.options.showLineAndLocalVariableTables) {
            if (attribute != null) {
                this.attrWriter.write((Object)attribute, ((Code_attribute)attribute).attributes.get("LineNumberTable"), this.constant_pool);
            }
            this.println();
            if (attribute != null) {
                this.attrWriter.write((Object)attribute, ((Code_attribute)attribute).attributes.get("LocalVariableTable"), this.constant_pool);
            }
            this.println();
            this.println();
        }
        if (this.options.showAllAttrs) {
            Attribute[] attributeArray;
            for (Attribute attribute3 : attributeArray = method.attributes.attrs) {
                this.attrWriter.write((Object)method, attribute3, this.constant_pool);
            }
            this.println();
        }
    }

    void writeModifiers(Collection<String> collection) {
        for (String string : collection) {
            this.print((Object)string);
            this.print(" ");
        }
    }

    void writeList(String string, Collection<?> collection, String string2) {
        this.print(string);
        String string3 = "";
        for (Object obj : collection) {
            this.print(string3);
            this.print(obj);
            string3 = ", ";
        }
        this.print(string2);
    }

    void writeListIfNotEmpty(String string, List<?> list, String string2) {
        if (list != null && list.size() > 0) {
            this.writeList(string, list, string2);
        }
    }

    Signature_attribute getSignature(Attributes attributes) {
        if (this.options.compat) {
            return null;
        }
        return (Signature_attribute)attributes.get("Signature");
    }

    String adjustVarargs(AccessFlags accessFlags, String string) {
        int n;
        if (accessFlags.is(128) && !this.options.compat && (n = string.lastIndexOf("[]")) > 0) {
            return string.substring(0, n) + "..." + string.substring(n + 2);
        }
        return string;
    }

    String getJavaName(ClassFile classFile) {
        try {
            return ClassWriter.getJavaName(classFile.getName());
        }
        catch (ConstantPoolException constantPoolException) {
            return this.report(constantPoolException);
        }
    }

    String getJavaSuperclassName(ClassFile classFile) {
        try {
            return ClassWriter.getJavaName(classFile.getSuperclassName());
        }
        catch (ConstantPoolException constantPoolException) {
            return this.report(constantPoolException);
        }
    }

    String getJavaInterfaceName(ClassFile classFile, int n) {
        try {
            return ClassWriter.getJavaName(classFile.getInterfaceName(n));
        }
        catch (ConstantPoolException constantPoolException) {
            return this.report(constantPoolException);
        }
    }

    String getFieldType(Descriptor descriptor) {
        try {
            return descriptor.getFieldType(this.constant_pool);
        }
        catch (ConstantPoolException constantPoolException) {
            return this.report(constantPoolException);
        }
        catch (DescriptorException descriptorException) {
            return this.report(descriptorException);
        }
    }

    String getReturnType(Descriptor descriptor) {
        try {
            return descriptor.getReturnType(this.constant_pool);
        }
        catch (ConstantPoolException constantPoolException) {
            return this.report(constantPoolException);
        }
        catch (DescriptorException descriptorException) {
            return this.report(descriptorException);
        }
    }

    String getParameterTypes(Descriptor descriptor, AccessFlags accessFlags) {
        try {
            return this.adjustVarargs(accessFlags, descriptor.getParameterTypes(this.constant_pool));
        }
        catch (ConstantPoolException constantPoolException) {
            return this.report(constantPoolException);
        }
        catch (DescriptorException descriptorException) {
            return this.report(descriptorException);
        }
    }

    String getJavaException(Exceptions_attribute exceptions_attribute, int n) {
        try {
            return ClassWriter.getJavaName(exceptions_attribute.getException(n, this.constant_pool));
        }
        catch (ConstantPoolException constantPoolException) {
            return this.report(constantPoolException);
        }
    }

    String getValue(Descriptor descriptor) {
        try {
            return descriptor.getValue(this.constant_pool);
        }
        catch (ConstantPoolException constantPoolException) {
            return this.report(constantPoolException);
        }
    }

    String getFieldName(Field field) {
        try {
            return field.getName(this.constant_pool);
        }
        catch (ConstantPoolException constantPoolException) {
            return this.report(constantPoolException);
        }
    }

    String getName(Method method) {
        try {
            return method.getName(this.constant_pool);
        }
        catch (ConstantPoolException constantPoolException) {
            return this.report(constantPoolException);
        }
    }

    static String getJavaName(String string) {
        return string.replace('/', '.');
    }

    String getSourceFile(SourceFile_attribute sourceFile_attribute) {
        try {
            return sourceFile_attribute.getSourceFile(this.constant_pool);
        }
        catch (ConstantPoolException constantPoolException) {
            return this.report(constantPoolException);
        }
    }

    String getConstantValue(Descriptor descriptor, int n) {
        try {
            ConstantPool.CPInfo cPInfo = this.constant_pool.get(n);
            switch (cPInfo.getTag()) {
                case 3: {
                    ConstantPool.CONSTANT_Integer_info cONSTANT_Integer_info = (ConstantPool.CONSTANT_Integer_info)cPInfo;
                    String string = descriptor.getValue(this.constant_pool);
                    if (string.equals("C")) {
                        return this.getConstantCharValue((char)cONSTANT_Integer_info.value);
                    }
                    if (string.equals("Z")) {
                        return String.valueOf(cONSTANT_Integer_info.value == 1);
                    }
                    return String.valueOf(cONSTANT_Integer_info.value);
                }
                case 8: {
                    ConstantPool.CONSTANT_String_info cONSTANT_String_info = (ConstantPool.CONSTANT_String_info)cPInfo;
                    return this.getConstantStringValue(cONSTANT_String_info.getString());
                }
            }
            return this.constantWriter.stringValue(cPInfo);
        }
        catch (ConstantPoolException constantPoolException) {
            return "#" + n;
        }
    }

    private String getConstantCharValue(char c) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('\'');
        stringBuilder.append(this.esc(c, '\''));
        stringBuilder.append('\'');
        return stringBuilder.toString();
    }

    private String getConstantStringValue(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\"");
        for (int i = 0; i < string.length(); ++i) {
            stringBuilder.append(this.esc(string.charAt(i), '\"'));
        }
        stringBuilder.append("\"");
        return stringBuilder.toString();
    }

    private String esc(char c, char c2) {
        if (' ' <= c && c <= '~' && c != c2) {
            return String.valueOf(c);
        }
        switch (c) {
            case '\b': {
                return "\\b";
            }
            case '\n': {
                return "\\n";
            }
            case '\t': {
                return "\\t";
            }
            case '\f': {
                return "\\f";
            }
            case '\r': {
                return "\\r";
            }
            case '\\': {
                return "\\\\";
            }
            case '\'': {
                return "\\'";
            }
            case '\"': {
                return "\\\"";
            }
        }
        return String.format("\\u%04x", c);
    }
}

