/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jdi;

import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.Method;
import com.sun.jdi.PrimitiveType;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Type;
import com.sun.jdi.VirtualMachine;
import com.sun.tools.jdi.JDWP;
import com.sun.tools.jdi.JDWPException;
import com.sun.tools.jdi.JNITypeParser;
import com.sun.tools.jdi.PacketStream;
import com.sun.tools.jdi.ReferenceTypeImpl;
import com.sun.tools.jdi.VirtualMachineImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayTypeImpl
extends ReferenceTypeImpl
implements ArrayType {
    protected ArrayTypeImpl(VirtualMachine virtualMachine, long l) {
        super(virtualMachine, l);
    }

    @Override
    public ArrayReference newInstance(int n) {
        try {
            return (ArrayReference)((Object)JDWP.ArrayType.NewInstance.process((VirtualMachineImpl)this.vm, (ArrayTypeImpl)this, (int)n).newArray);
        }
        catch (JDWPException jDWPException) {
            throw jDWPException.toJDIException();
        }
    }

    @Override
    public String componentSignature() {
        return this.signature().substring(1);
    }

    @Override
    public String componentTypeName() {
        JNITypeParser jNITypeParser = new JNITypeParser(this.componentSignature());
        return jNITypeParser.typeName();
    }

    Type type() throws ClassNotLoadedException {
        return this.findType(this.componentSignature());
    }

    void addVisibleMethods(Map map) {
    }

    @Override
    public List<Method> allMethods() {
        return new ArrayList<Method>(0);
    }

    Type findComponentType(String string) throws ClassNotLoadedException {
        byte by = (byte)string.charAt(0);
        if (PacketStream.isObjectTag(by)) {
            JNITypeParser jNITypeParser = new JNITypeParser(this.componentSignature());
            List<ReferenceType> list = this.vm.classesByName(jNITypeParser.typeName());
            for (ReferenceType referenceType : list) {
                ClassLoaderReference classLoaderReference = referenceType.classLoader();
                if (!(classLoaderReference == null ? this.classLoader() == null : classLoaderReference.equals(this.classLoader()))) continue;
                return referenceType;
            }
            throw new ClassNotLoadedException(this.componentTypeName());
        }
        return this.vm.primitiveTypeMirror(by);
    }

    @Override
    public Type componentType() throws ClassNotLoadedException {
        return this.findComponentType(this.componentSignature());
    }

    static boolean isComponentAssignable(Type type, Type type2) {
        if (type2 instanceof PrimitiveType) {
            return type2.equals(type);
        }
        if (type instanceof PrimitiveType) {
            return false;
        }
        ReferenceTypeImpl referenceTypeImpl = (ReferenceTypeImpl)type2;
        ReferenceTypeImpl referenceTypeImpl2 = (ReferenceTypeImpl)type;
        return referenceTypeImpl.isAssignableTo(referenceTypeImpl2);
    }

    @Override
    boolean isAssignableTo(ReferenceType referenceType) {
        if (referenceType instanceof ArrayType) {
            try {
                Type type = ((ArrayType)referenceType).componentType();
                return ArrayTypeImpl.isComponentAssignable(type, this.componentType());
            }
            catch (ClassNotLoadedException classNotLoadedException) {
                return false;
            }
        }
        if (referenceType instanceof InterfaceType) {
            return referenceType.name().equals("java.lang.Cloneable");
        }
        return referenceType.name().equals("java.lang.Object");
    }

    List<ReferenceType> inheritedTypes() {
        return new ArrayList<ReferenceType>(0);
    }

    @Override
    void getModifiers() {
        if (this.modifiers != -1) {
            return;
        }
        try {
            Type type = this.componentType();
            if (type instanceof PrimitiveType) {
                this.modifiers = 17;
            } else {
                ReferenceType referenceType = (ReferenceType)type;
                this.modifiers = referenceType.modifiers();
            }
        }
        catch (ClassNotLoadedException classNotLoadedException) {
            classNotLoadedException.printStackTrace();
        }
    }

    @Override
    public String toString() {
        return "array class " + this.name() + " (" + this.loaderString() + ")";
    }

    @Override
    public boolean isPrepared() {
        return true;
    }

    @Override
    public boolean isVerified() {
        return true;
    }

    @Override
    public boolean isInitialized() {
        return true;
    }

    @Override
    public boolean failedToInitialize() {
        return false;
    }

    @Override
    public boolean isAbstract() {
        return false;
    }

    @Override
    public boolean isFinal() {
        return true;
    }
}

