/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.rngom.digested;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

class DOMPrinter {
    protected XMLStreamWriter out;

    public DOMPrinter(XMLStreamWriter xMLStreamWriter) {
        this.out = xMLStreamWriter;
    }

    public void print(Node node) throws XMLStreamException {
        switch (node.getNodeType()) {
            case 9: {
                this.visitDocument((Document)node);
                break;
            }
            case 11: {
                this.visitDocumentFragment((DocumentFragment)node);
                break;
            }
            case 1: {
                this.visitElement((Element)node);
                break;
            }
            case 3: {
                this.visitText((Text)node);
                break;
            }
            case 4: {
                this.visitCDATASection((CDATASection)node);
                break;
            }
            case 7: {
                this.visitProcessingInstruction((ProcessingInstruction)node);
                break;
            }
            case 5: {
                this.visitReference((EntityReference)node);
                break;
            }
            case 8: {
                this.visitComment((Comment)node);
                break;
            }
            case 10: {
                break;
            }
            default: {
                throw new XMLStreamException("Unexpected DOM Node Type " + node.getNodeType());
            }
        }
    }

    protected void visitChildren(Node node) throws XMLStreamException {
        NodeList nodeList = node.getChildNodes();
        if (nodeList != null) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                this.print(nodeList.item(i));
            }
        }
    }

    protected void visitDocument(Document document) throws XMLStreamException {
        this.out.writeStartDocument();
        this.print(document.getDocumentElement());
        this.out.writeEndDocument();
    }

    protected void visitDocumentFragment(DocumentFragment documentFragment) throws XMLStreamException {
        this.visitChildren(documentFragment);
    }

    protected void visitElement(Element element) throws XMLStreamException {
        this.out.writeStartElement(element.getPrefix(), element.getLocalName(), element.getNamespaceURI());
        NamedNodeMap namedNodeMap = element.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            this.visitAttr((Attr)namedNodeMap.item(i));
        }
        this.visitChildren(element);
        this.out.writeEndElement();
    }

    protected void visitAttr(Attr attr) throws XMLStreamException {
        String string = attr.getLocalName();
        if (string.equals("xmlns")) {
            this.out.writeDefaultNamespace(attr.getNamespaceURI());
        } else {
            String string2 = attr.getPrefix();
            if (string2 != null && string2.equals("xmlns")) {
                this.out.writeNamespace(string2, attr.getNamespaceURI());
            } else {
                this.out.writeAttribute(string2, attr.getNamespaceURI(), string, attr.getNodeValue());
            }
        }
    }

    protected void visitComment(Comment comment) throws XMLStreamException {
        this.out.writeComment(comment.getData());
    }

    protected void visitText(Text text) throws XMLStreamException {
        this.out.writeCharacters(text.getNodeValue());
    }

    protected void visitCDATASection(CDATASection cDATASection) throws XMLStreamException {
        this.out.writeCData(cDATASection.getNodeValue());
    }

    protected void visitProcessingInstruction(ProcessingInstruction processingInstruction) throws XMLStreamException {
        this.out.writeProcessingInstruction(processingInstruction.getNodeName(), processingInstruction.getData());
    }

    protected void visitReference(EntityReference entityReference) throws XMLStreamException {
        this.visitChildren(entityReference);
    }
}

