/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.xsom.impl.parser;

import com.sun.xml.internal.xsom.impl.SchemaImpl;
import com.sun.xml.internal.xsom.parser.SchemaDocument;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SchemaDocumentImpl
implements SchemaDocument {
    private final SchemaImpl schema;
    private final String schemaDocumentURI;
    final Set<SchemaDocumentImpl> references = new HashSet<SchemaDocumentImpl>();
    final Set<SchemaDocumentImpl> referers = new HashSet<SchemaDocumentImpl>();

    protected SchemaDocumentImpl(SchemaImpl schemaImpl, String string) {
        this.schema = schemaImpl;
        this.schemaDocumentURI = string;
    }

    @Override
    public String getSystemId() {
        return this.schemaDocumentURI;
    }

    @Override
    public String getTargetNamespace() {
        return this.schema.getTargetNamespace();
    }

    @Override
    public SchemaImpl getSchema() {
        return this.schema;
    }

    @Override
    public Set<SchemaDocument> getReferencedDocuments() {
        return Collections.unmodifiableSet(this.references);
    }

    @Override
    public Set<SchemaDocument> getIncludedDocuments() {
        return this.getImportedDocuments(this.getTargetNamespace());
    }

    @Override
    public Set<SchemaDocument> getImportedDocuments(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        HashSet<SchemaDocumentImpl> hashSet = new HashSet<SchemaDocumentImpl>();
        for (SchemaDocumentImpl schemaDocumentImpl : this.references) {
            if (!schemaDocumentImpl.getTargetNamespace().equals(string)) continue;
            hashSet.add(schemaDocumentImpl);
        }
        return Collections.unmodifiableSet(hashSet);
    }

    @Override
    public boolean includes(SchemaDocument schemaDocument) {
        if (!this.references.contains(schemaDocument)) {
            return false;
        }
        return schemaDocument.getSchema() == this.schema;
    }

    @Override
    public boolean imports(SchemaDocument schemaDocument) {
        if (!this.references.contains(schemaDocument)) {
            return false;
        }
        return schemaDocument.getSchema() != this.schema;
    }

    @Override
    public Set<SchemaDocument> getReferers() {
        return Collections.unmodifiableSet(this.referers);
    }

    public boolean equals(Object object) {
        SchemaDocumentImpl schemaDocumentImpl = (SchemaDocumentImpl)object;
        if (this.schemaDocumentURI == null || schemaDocumentImpl.schemaDocumentURI == null) {
            return this == schemaDocumentImpl;
        }
        if (!this.schemaDocumentURI.equals(schemaDocumentImpl.schemaDocumentURI)) {
            return false;
        }
        return this.schema == schemaDocumentImpl.schema;
    }

    public int hashCode() {
        if (this.schemaDocumentURI == null) {
            return super.hashCode();
        }
        return this.schemaDocumentURI.hashCode() ^ this.schema.hashCode();
    }
}

