/*
 * Decompiled with CFR 0.152.
 */
package sun.jvmstat.perfdata.monitor.protocol.local;

import java.util.ArrayList;
import java.util.List;
import java.util.TimerTask;
import sun.jvmstat.monitor.MonitorException;
import sun.jvmstat.monitor.VmIdentifier;
import sun.jvmstat.monitor.event.MonitorStatusChangeEvent;
import sun.jvmstat.monitor.event.VmEvent;
import sun.jvmstat.monitor.event.VmListener;
import sun.jvmstat.perfdata.monitor.AbstractMonitoredVm;
import sun.jvmstat.perfdata.monitor.CountedTimerTask;
import sun.jvmstat.perfdata.monitor.CountedTimerTaskUtils;
import sun.jvmstat.perfdata.monitor.MonitorStatus;
import sun.jvmstat.perfdata.monitor.protocol.local.LocalEventTimer;
import sun.jvmstat.perfdata.monitor.protocol.local.PerfDataBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalMonitoredVm
extends AbstractMonitoredVm {
    private ArrayList<VmListener> listeners;
    private NotifierTask task;

    public LocalMonitoredVm(VmIdentifier vmIdentifier, int n) throws MonitorException {
        super(vmIdentifier, n);
        this.pdb = new PerfDataBuffer(vmIdentifier);
        this.listeners = new ArrayList();
    }

    @Override
    public void detach() {
        if (this.interval > 0 && this.task != null) {
            this.task.cancel();
            this.task = null;
        }
        super.detach();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addVmListener(VmListener vmListener) {
        ArrayList<VmListener> arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.add(vmListener);
            if (this.task == null) {
                this.task = new NotifierTask();
                LocalEventTimer localEventTimer = LocalEventTimer.getInstance();
                localEventTimer.schedule((TimerTask)this.task, this.interval, (long)this.interval);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeVmListener(VmListener vmListener) {
        ArrayList<VmListener> arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.remove(vmListener);
            if (this.listeners.isEmpty() && this.task != null) {
                this.task.cancel();
                this.task = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setInterval(int n) {
        ArrayList<VmListener> arrayList = this.listeners;
        synchronized (arrayList) {
            if (n == this.interval) {
                return;
            }
            int n2 = this.interval;
            super.setInterval(n);
            if (this.task != null) {
                this.task.cancel();
                NotifierTask notifierTask = this.task;
                this.task = new NotifierTask();
                LocalEventTimer localEventTimer = LocalEventTimer.getInstance();
                CountedTimerTaskUtils.reschedule(localEventTimer, notifierTask, this.task, n2, n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireMonitorStatusChangedEvents(List list, List list2) {
        MonitorStatusChangeEvent monitorStatusChangeEvent = null;
        ArrayList arrayList = null;
        ArrayList<VmListener> arrayList2 = this.listeners;
        synchronized (arrayList2) {
            arrayList = (ArrayList)this.listeners.clone();
        }
        for (VmListener vmListener : arrayList) {
            if (monitorStatusChangeEvent == null) {
                monitorStatusChangeEvent = new MonitorStatusChangeEvent(this, list, list2);
            }
            vmListener.monitorStatusChanged(monitorStatusChangeEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireMonitorsUpdatedEvents() {
        VmEvent vmEvent = null;
        ArrayList arrayList = null;
        ArrayList<VmListener> arrayList2 = this.listeners;
        synchronized (arrayList2) {
            arrayList = (ArrayList)LocalMonitoredVm.cast(this.listeners.clone());
        }
        for (VmListener vmListener : arrayList) {
            if (vmEvent == null) {
                vmEvent = new VmEvent(this);
            }
            vmListener.monitorsUpdated(vmEvent);
        }
    }

    static <T> T cast(Object object) {
        return (T)object;
    }

    private class NotifierTask
    extends CountedTimerTask {
        private NotifierTask() {
        }

        public void run() {
            super.run();
            try {
                MonitorStatus monitorStatus = LocalMonitoredVm.this.getMonitorStatus();
                List list = monitorStatus.getInserted();
                List list2 = monitorStatus.getRemoved();
                if (!list.isEmpty() || !list2.isEmpty()) {
                    LocalMonitoredVm.this.fireMonitorStatusChangedEvents(list, list2);
                }
                LocalMonitoredVm.this.fireMonitorsUpdatedEvents();
            }
            catch (MonitorException monitorException) {
                System.err.println("Exception updating monitors for " + LocalMonitoredVm.this.getVmIdentifier());
                monitorException.printStackTrace();
            }
        }
    }
}

