/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.mbeanserver;

import com.sun.jmx.mbeanserver.MBeanAnalyzer;
import com.sun.jmx.mbeanserver.MXBeanIntrospector;
import com.sun.jmx.mbeanserver.MXBeanLookup;
import com.sun.jmx.mbeanserver.Util;
import com.sun.jmx.remote.util.EnvHelp;
import java.beans.ConstructorProperties;
import java.io.InvalidObjectException;
import java.lang.annotation.ElementType;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.WeakHashMap;
import javax.management.JMX;
import javax.management.ObjectName;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataInvocationHandler;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeDataView;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.MXBeanMapping;
import javax.management.openmbean.MXBeanMappingClass;
import javax.management.openmbean.MXBeanMappingFactory;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMXBeanMappingFactory
extends MXBeanMappingFactory {
    private static final Map<MXBeanMappingFactory, Mappings> factoryMappings = new WeakHashMap<MXBeanMappingFactory, Mappings>();
    private static final Map<Type, MXBeanMapping> permanentMappings = Util.newMap();
    private static final String[] keyArray;
    private static final String[] keyValueArray;
    private static final Map<Type, Type> inProgress;

    static boolean isIdentity(MXBeanMapping mXBeanMapping) {
        return mXBeanMapping instanceof NonNullMXBeanMapping && ((NonNullMXBeanMapping)mXBeanMapping).isIdentity();
    }

    private static synchronized MXBeanMapping getMapping(Type type, MXBeanMappingFactory mXBeanMappingFactory) {
        WeakReference weakReference;
        Mappings mappings = factoryMappings.get(mXBeanMappingFactory);
        if (mappings == null) {
            mappings = new Mappings();
            factoryMappings.put(mXBeanMappingFactory, mappings);
        }
        return (weakReference = (WeakReference)mappings.get(type)) == null ? null : (MXBeanMapping)weakReference.get();
    }

    private static synchronized void putMapping(Type type, MXBeanMapping mXBeanMapping, MXBeanMappingFactory mXBeanMappingFactory) {
        Mappings mappings = factoryMappings.get(mXBeanMappingFactory);
        if (mappings == null) {
            mappings = new Mappings();
            factoryMappings.put(mXBeanMappingFactory, mappings);
        }
        WeakReference<MXBeanMapping> weakReference = new WeakReference<MXBeanMapping>(mXBeanMapping);
        mappings.put(type, weakReference);
    }

    @Override
    public synchronized MXBeanMapping mappingForType(Type type, MXBeanMappingFactory mXBeanMappingFactory) throws OpenDataException {
        if (inProgress.containsKey(type)) {
            throw new OpenDataException("Recursive data structure, including " + MXBeanIntrospector.typeName(type));
        }
        MXBeanMapping mXBeanMapping = DefaultMXBeanMappingFactory.getMapping(type, null);
        if (mXBeanMapping != null) {
            return mXBeanMapping;
        }
        inProgress.put(type, type);
        try {
            try {
                mXBeanMapping = this.makeMapping(type, mXBeanMappingFactory);
            }
            catch (OpenDataException openDataException) {
                throw DefaultMXBeanMappingFactory.openDataException("Cannot convert type: " + MXBeanIntrospector.typeName(type), openDataException);
            }
            Object var6_4 = null;
            inProgress.remove(type);
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            inProgress.remove(type);
            throw throwable;
        }
        DefaultMXBeanMappingFactory.putMapping(type, mXBeanMapping, mXBeanMappingFactory);
        return mXBeanMapping;
    }

    private MXBeanMapping makeMapping(Type type, MXBeanMappingFactory mXBeanMappingFactory) throws OpenDataException {
        MXBeanMapping mXBeanMapping = permanentMappings.get(type);
        if (mXBeanMapping != null) {
            return mXBeanMapping;
        }
        Class<?> clazz = DefaultMXBeanMappingFactory.erasure(type);
        MXBeanMappingClass mXBeanMappingClass = clazz.getAnnotation(MXBeanMappingClass.class);
        if (mXBeanMappingClass != null) {
            return DefaultMXBeanMappingFactory.makeAnnotationMapping(mXBeanMappingClass, type, mXBeanMappingFactory);
        }
        if (type instanceof GenericArrayType) {
            Type type2 = ((GenericArrayType)type).getGenericComponentType();
            return this.makeArrayOrCollectionMapping(type, type2, mXBeanMappingFactory);
        }
        if (type instanceof Class) {
            Class clazz2 = (Class)type;
            if (clazz2.isEnum()) {
                return DefaultMXBeanMappingFactory.makeEnumMapping(clazz2, ElementType.class);
            }
            if (clazz2.isArray()) {
                Class<?> clazz3 = clazz2.getComponentType();
                return this.makeArrayOrCollectionMapping(clazz2, clazz3, mXBeanMappingFactory);
            }
            if (JMX.isMXBeanInterface(clazz2)) {
                return DefaultMXBeanMappingFactory.makeMXBeanRefMapping(clazz2);
            }
            return this.makeCompositeMapping(clazz2, mXBeanMappingFactory);
        }
        if (type instanceof ParameterizedType) {
            return this.makeParameterizedTypeMapping((ParameterizedType)type, mXBeanMappingFactory);
        }
        throw new OpenDataException("Cannot map type: " + type);
    }

    private static MXBeanMapping makeAnnotationMapping(MXBeanMappingClass mXBeanMappingClass, Type type, MXBeanMappingFactory mXBeanMappingFactory) throws OpenDataException {
        Constructor<? extends MXBeanMapping> constructor;
        Class<? extends MXBeanMapping> clazz = mXBeanMappingClass.value();
        try {
            constructor = clazz.getConstructor(Type.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            String string = "Annotation @" + MXBeanMappingClass.class.getName() + " must name a class with a public constructor that has a " + "single " + Type.class.getName() + " argument";
            OpenDataException openDataException = new OpenDataException(string);
            openDataException.initCause(noSuchMethodException);
            throw openDataException;
        }
        try {
            return constructor.newInstance(type);
        }
        catch (Exception exception) {
            String string = "Could not construct a " + clazz.getName() + " for @" + MXBeanMappingClass.class.getName();
            OpenDataException openDataException = new OpenDataException(string);
            openDataException.initCause(exception);
            throw openDataException;
        }
    }

    private static Class<?> erasure(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return DefaultMXBeanMappingFactory.erasure(((ParameterizedType)type).getRawType());
        }
        return Object.class;
    }

    private static <T extends Enum<T>> MXBeanMapping makeEnumMapping(Class<?> clazz, Class<T> clazz2) {
        return new EnumMapping((Class)Util.cast(clazz));
    }

    private MXBeanMapping makeArrayOrCollectionMapping(Type type, Type type2, MXBeanMappingFactory mXBeanMappingFactory) throws OpenDataException {
        Class<?> clazz;
        MXBeanMapping mXBeanMapping = mXBeanMappingFactory.mappingForType(type2, mXBeanMappingFactory);
        OpenType<?> openType = mXBeanMapping.getOpenType();
        ArrayType<?[]> arrayType = ArrayType.getArrayType(openType);
        Class<?> clazz2 = mXBeanMapping.getOpenClass();
        String string = clazz2.isArray() ? "[" + clazz2.getName() : "[L" + clazz2.getName() + ";";
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw DefaultMXBeanMappingFactory.openDataException("Cannot obtain array class", classNotFoundException);
        }
        if (type instanceof ParameterizedType) {
            return new CollectionMapping(type, arrayType, clazz, mXBeanMapping);
        }
        if (DefaultMXBeanMappingFactory.isIdentity(mXBeanMapping)) {
            return new IdentityMapping(type, arrayType);
        }
        return new ArrayMapping(type, arrayType, clazz, mXBeanMapping);
    }

    private MXBeanMapping makeTabularMapping(Type type, boolean bl, Type type2, Type type3, MXBeanMappingFactory mXBeanMappingFactory) throws OpenDataException {
        String string = MXBeanIntrospector.typeName(type);
        MXBeanMapping mXBeanMapping = mXBeanMappingFactory.mappingForType(type2, mXBeanMappingFactory);
        MXBeanMapping mXBeanMapping2 = mXBeanMappingFactory.mappingForType(type3, mXBeanMappingFactory);
        OpenType<?> openType = mXBeanMapping.getOpenType();
        OpenType<?> openType2 = mXBeanMapping2.getOpenType();
        CompositeType compositeType = new CompositeType(string, string, keyValueArray, keyValueArray, new OpenType[]{openType, openType2});
        TabularType tabularType = new TabularType(string, string, compositeType, keyArray);
        return new TabularMapping(type, bl, tabularType, mXBeanMapping, mXBeanMapping2);
    }

    private MXBeanMapping makeParameterizedTypeMapping(ParameterizedType parameterizedType, MXBeanMappingFactory mXBeanMappingFactory) throws OpenDataException {
        Type type = parameterizedType.getRawType();
        if (type instanceof Class) {
            boolean bl;
            Class clazz = (Class)type;
            if (clazz == List.class || clazz == Set.class || clazz == SortedSet.class) {
                Type[] typeArray = parameterizedType.getActualTypeArguments();
                assert (typeArray.length == 1);
                if (clazz == SortedSet.class) {
                    DefaultMXBeanMappingFactory.mustBeComparable(clazz, typeArray[0]);
                }
                return this.makeArrayOrCollectionMapping(parameterizedType, typeArray[0], mXBeanMappingFactory);
            }
            boolean bl2 = bl = clazz == SortedMap.class;
            if (clazz == Map.class || bl) {
                Type[] typeArray = parameterizedType.getActualTypeArguments();
                assert (typeArray.length == 2);
                if (bl) {
                    DefaultMXBeanMappingFactory.mustBeComparable(clazz, typeArray[0]);
                }
                return this.makeTabularMapping(parameterizedType, bl, typeArray[0], typeArray[1], mXBeanMappingFactory);
            }
        }
        throw new OpenDataException("Cannot convert type: " + parameterizedType);
    }

    private static MXBeanMapping makeMXBeanRefMapping(Type type) throws OpenDataException {
        return new MXBeanRefMapping(type);
    }

    private MXBeanMapping makeCompositeMapping(Class<?> clazz, MXBeanMappingFactory mXBeanMappingFactory) throws OpenDataException {
        Object object;
        String[] stringArray;
        boolean bl = clazz.getName().equals("com.sun.management.GcInfo") && clazz.getClassLoader() == null;
        List<Method> list = MBeanAnalyzer.eliminateCovariantMethods(Arrays.asList(clazz.getMethods()));
        SortedMap<String, Method> sortedMap = Util.newSortedMap();
        for (Method methodArray2 : list) {
            stringArray = DefaultMXBeanMappingFactory.propertyName(methodArray2);
            if (stringArray == null || bl && stringArray.equals("CompositeType") || (object = sortedMap.put(DefaultMXBeanMappingFactory.decapitalize((String)stringArray), methodArray2)) == null) continue;
            String n2 = "Class " + clazz.getName() + " has method name clash: " + ((Method)object).getName() + ", " + methodArray2.getName();
            throw new OpenDataException(n2);
        }
        int n = sortedMap.size();
        if (n == 0) {
            throw new OpenDataException("Can't map " + clazz.getName() + " to an open data type");
        }
        Method[] methodArray = new Method[n];
        stringArray = new String[n];
        object = new OpenType[n];
        int n2 = 0;
        for (Map.Entry entry : sortedMap.entrySet()) {
            Method method;
            stringArray[n2] = (String)entry.getKey();
            methodArray[n2] = method = (Method)entry.getValue();
            Type type = method.getGenericReturnType();
            object[n2] = mXBeanMappingFactory.mappingForType(type, mXBeanMappingFactory).getOpenType();
            ++n2;
        }
        CompositeType compositeType = new CompositeType(clazz.getName(), clazz.getName(), stringArray, stringArray, (OpenType<?>[])object);
        return new CompositeMapping(clazz, compositeType, stringArray, methodArray, mXBeanMappingFactory);
    }

    static InvalidObjectException invalidObjectException(String string, Throwable throwable) {
        return EnvHelp.initCause(new InvalidObjectException(string), throwable);
    }

    static InvalidObjectException invalidObjectException(Throwable throwable) {
        return DefaultMXBeanMappingFactory.invalidObjectException(throwable.getMessage(), throwable);
    }

    static OpenDataException openDataException(String string, Throwable throwable) {
        return EnvHelp.initCause(new OpenDataException(string), throwable);
    }

    static OpenDataException openDataException(Throwable throwable) {
        return DefaultMXBeanMappingFactory.openDataException(throwable.getMessage(), throwable);
    }

    static void mustBeComparable(Class<?> clazz, Type type) throws OpenDataException {
        if (!(type instanceof Class) || !Comparable.class.isAssignableFrom((Class)type)) {
            String string = "Parameter class " + type + " of " + clazz.getName() + " does not implement " + Comparable.class.getName();
            throw new OpenDataException(string);
        }
    }

    public static String decapitalize(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        int n = Character.offsetByCodePoints(string, 0, 1);
        if (n < string.length() && Character.isUpperCase(string.codePointAt(n))) {
            return string;
        }
        return string.substring(0, n).toLowerCase() + string.substring(n);
    }

    static String capitalize(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        int n = string.offsetByCodePoints(0, 1);
        return string.substring(0, n).toUpperCase() + string.substring(n);
    }

    public static String propertyName(Method method) {
        String string = null;
        String string2 = method.getName();
        if (string2.startsWith("get")) {
            string = string2.substring(3);
        } else if (string2.startsWith("is") && method.getReturnType() == Boolean.TYPE) {
            string = string2.substring(2);
        }
        if (string == null || string.length() == 0 || method.getParameterTypes().length > 0 || method.getReturnType() == Void.TYPE || string2.equals("getClass")) {
            return null;
        }
        return string;
    }

    static {
        OpenType[] openTypeArray = new OpenType[]{SimpleType.BIGDECIMAL, SimpleType.BIGINTEGER, SimpleType.BOOLEAN, SimpleType.BYTE, SimpleType.CHARACTER, SimpleType.DATE, SimpleType.DOUBLE, SimpleType.FLOAT, SimpleType.INTEGER, SimpleType.LONG, SimpleType.OBJECTNAME, SimpleType.SHORT, SimpleType.STRING, SimpleType.VOID};
        for (int i = 0; i < openTypeArray.length; ++i) {
            Class<?> clazz;
            OpenType openType = openTypeArray[i];
            try {
                clazz = Class.forName(openType.getClassName(), false, ObjectName.class.getClassLoader());
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new Error(classNotFoundException);
            }
            IdentityMapping identityMapping = new IdentityMapping(clazz, openType);
            permanentMappings.put(clazz, identityMapping);
            if (!clazz.getName().startsWith("java.lang.")) continue;
            try {
                Field field = clazz.getField("TYPE");
                Class clazz2 = (Class)field.get(null);
                IdentityMapping identityMapping2 = new IdentityMapping(clazz2, openType);
                permanentMappings.put(clazz2, identityMapping2);
                if (clazz2 == Void.TYPE) continue;
                Class<?> clazz3 = Array.newInstance(clazz2, 0).getClass();
                ArrayType<?> arrayType = ArrayType.getPrimitiveArrayType(clazz3);
                IdentityMapping identityMapping3 = new IdentityMapping(clazz3, arrayType);
                permanentMappings.put(clazz3, identityMapping3);
                continue;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                assert (false);
                continue;
            }
        }
        keyArray = new String[]{"key"};
        keyValueArray = new String[]{"key", "value"};
        inProgress = Util.newIdentityHashMap();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CompositeBuilderViaProxy
    extends CompositeBuilder {
        CompositeBuilderViaProxy(Class<?> clazz, String[] stringArray) {
            super(clazz, stringArray);
        }

        @Override
        String applicable(Method[] methodArray) {
            Class<?> clazz = this.getTargetClass();
            if (!clazz.isInterface()) {
                return "not an interface";
            }
            Set<Method> set = Util.newSet(Arrays.asList(clazz.getMethods()));
            set.removeAll(Arrays.asList(methodArray));
            String string = null;
            for (Method method : set) {
                String string2 = method.getName();
                Class<?>[] classArray = method.getParameterTypes();
                try {
                    Method method2 = Object.class.getMethod(string2, classArray);
                    if (Modifier.isPublic(method2.getModifiers())) continue;
                    string = string2;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    string = string2;
                }
            }
            if (string != null) {
                return "contains methods other than getters (" + string + ")";
            }
            return null;
        }

        @Override
        final Object fromCompositeData(CompositeData compositeData, String[] stringArray, MXBeanMapping[] mXBeanMappingArray) {
            Class<?> clazz = this.getTargetClass();
            return Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, new CompositeDataInvocationHandler(compositeData));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CompositeBuilderViaConstructor
    extends CompositeBuilder {
        private List<Constr> annotatedConstructors;

        CompositeBuilderViaConstructor(Class<?> clazz, String[] stringArray) {
            super(clazz, stringArray);
        }

        @Override
        String applicable(Method[] methodArray) throws InvalidObjectException {
            Object string;
            BitSet bitSet;
            Object object;
            Object object2;
            Class<ConstructorProperties> clazz = ConstructorProperties.class;
            Class<?> clazz2 = this.getTargetClass();
            Constructor<?>[] constructorArray = clazz2.getConstructors();
            List<Constructor<?>> list = Util.newList();
            for (Constructor<?> constructor : constructorArray) {
                if (!Modifier.isPublic(constructor.getModifiers()) || constructor.getAnnotation(clazz) == null) continue;
                list.add(constructor);
            }
            if (list.isEmpty()) {
                return "no constructor has @ConstructorProperties annotation";
            }
            this.annotatedConstructors = Util.newList();
            Map map = Util.newMap();
            String[] stringArray = this.getItemNames();
            for (int i = 0; i < stringArray.length; ++i) {
                map.put(stringArray[i], i);
            }
            Set<BitSet> set = Util.newSet();
            for (Constructor object4 : list) {
                Object[] objectArray = object4.getAnnotation(clazz).value();
                object2 = object4.getGenericParameterTypes();
                if (((Type[])object2).length != objectArray.length) {
                    object = "Number of constructor params does not match @ConstructorProperties annotation: " + object4;
                    throw new InvalidObjectException((String)object);
                }
                object = new int[methodArray.length];
                for (int i = 0; i < methodArray.length; ++i) {
                    object[i] = -1;
                }
                bitSet = new BitSet();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object3;
                    Object object52;
                    String string2 = objectArray[i];
                    if (!map.containsKey(string2)) {
                        String string3 = "@ConstructorProperties includes name " + string2 + " which does not correspond to a property";
                        for (Object object52 : map.keySet()) {
                            if (!((String)object52).equalsIgnoreCase(string2)) continue;
                            string3 = string3 + " (differs only in case from property " + (String)object52 + ")";
                        }
                        string3 = string3 + ": " + object4;
                        throw new InvalidObjectException(string3);
                    }
                    int n = (Integer)map.get(string2);
                    object[n] = i;
                    if (bitSet.get(n)) {
                        object3 = "@ConstructorProperties contains property " + string2 + " more than once: " + object4;
                        throw new InvalidObjectException((String)object3);
                    }
                    bitSet.set(n);
                    object3 = methodArray[n];
                    object52 = ((Method)object3).getGenericReturnType();
                    if (object52.equals(object2[i])) continue;
                    String string4 = "@ConstructorProperties gives property " + string2 + " of type " + object52 + " for parameter " + " of type " + object2[i] + ": " + object4;
                    throw new InvalidObjectException(string4);
                }
                if (!set.add(bitSet)) {
                    String string5 = "More than one constructor has a @ConstructorProperties annotation with this set of names: " + Arrays.toString(objectArray);
                    throw new InvalidObjectException(string5);
                }
                string = new Constr(object4, (int[])object, bitSet);
                this.annotatedConstructors.add((Constr)string);
            }
            for (BitSet bitSet2 : set) {
                boolean bl = false;
                object2 = set.iterator();
                while (object2.hasNext()) {
                    object = (BitSet)object2.next();
                    if (bitSet2 == object) {
                        bl = true;
                        continue;
                    }
                    if (!bl) continue;
                    bitSet = new BitSet();
                    bitSet.or(bitSet2);
                    bitSet.or((BitSet)object);
                    if (set.contains(bitSet)) continue;
                    string = new TreeSet();
                    int n = bitSet.nextSetBit(0);
                    while (n >= 0) {
                        string.add(stringArray[n]);
                        n = bitSet.nextSetBit(n + 1);
                    }
                    String string6 = "Constructors with @ConstructorProperties annotation  would be ambiguous for these items: " + string;
                    throw new InvalidObjectException(string6);
                }
            }
            return null;
        }

        @Override
        final Object fromCompositeData(CompositeData compositeData, String[] stringArray, MXBeanMapping[] mXBeanMappingArray) throws InvalidObjectException {
            Object object;
            Object[] objectArray;
            CompositeType compositeType = compositeData.getCompositeType();
            BitSet bitSet = new BitSet();
            for (int i = 0; i < stringArray.length; ++i) {
                if (compositeType.getType(stringArray[i]) == null) continue;
                bitSet.set(i);
            }
            Constr constr = null;
            for (Constr constr2 : this.annotatedConstructors) {
                if (!CompositeBuilderViaConstructor.subset(constr2.presentParams, bitSet) || constr != null && !CompositeBuilderViaConstructor.subset(constr.presentParams, constr2.presentParams)) continue;
                constr = constr2;
            }
            if (constr == null) {
                objectArray = "No constructor has a @ConstructorProperties for this set of items: " + compositeType.keySet();
                throw new InvalidObjectException((String)objectArray);
            }
            objectArray = new Object[constr.presentParams.cardinality()];
            for (int i = 0; i < stringArray.length; ++i) {
                if (!constr.presentParams.get(i)) continue;
                object = compositeData.get(stringArray[i]);
                Object object2 = mXBeanMappingArray[i].fromOpenValue(object);
                int n = constr.paramIndexes[i];
                if (n < 0) continue;
                objectArray[n] = object2;
            }
            try {
                return constr.constructor.newInstance(objectArray);
            }
            catch (Exception exception) {
                object = "Exception constructing " + this.getTargetClass().getName();
                throw DefaultMXBeanMappingFactory.invalidObjectException((String)object, exception);
            }
        }

        private static boolean subset(BitSet bitSet, BitSet bitSet2) {
            BitSet bitSet3 = (BitSet)bitSet.clone();
            bitSet3.andNot(bitSet2);
            return bitSet3.isEmpty();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class Constr {
            final Constructor<?> constructor;
            final int[] paramIndexes;
            final BitSet presentParams;

            Constr(Constructor<?> constructor, int[] nArray, BitSet bitSet) {
                this.constructor = constructor;
                this.paramIndexes = nArray;
                this.presentParams = bitSet;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CompositeBuilderViaSetters
    extends CompositeBuilder {
        private Method[] setters;

        CompositeBuilderViaSetters(Class<?> clazz, String[] stringArray) {
            super(clazz, stringArray);
        }

        @Override
        String applicable(Method[] methodArray) {
            Method[] methodArray2;
            try {
                methodArray2 = this.getTargetClass().getConstructor(new Class[0]);
            }
            catch (Exception exception) {
                return "does not have a public no-arg constructor";
            }
            methodArray2 = new Method[methodArray.length];
            for (int i = 0; i < methodArray.length; ++i) {
                Method method;
                Method method2 = methodArray[i];
                Class<?> clazz = method2.getReturnType();
                String string = DefaultMXBeanMappingFactory.propertyName(method2);
                String string2 = "set" + string;
                try {
                    method = this.getTargetClass().getMethod(string2, clazz);
                    if (method.getReturnType() != Void.TYPE) {
                        throw new Exception();
                    }
                }
                catch (Exception exception) {
                    return "not all getters have corresponding setters (" + method2 + ")";
                }
                methodArray2[i] = method;
            }
            this.setters = methodArray2;
            return null;
        }

        @Override
        Object fromCompositeData(CompositeData compositeData, String[] stringArray, MXBeanMapping[] mXBeanMappingArray) throws InvalidObjectException {
            Object obj;
            try {
                obj = this.getTargetClass().newInstance();
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!compositeData.containsKey(stringArray[i])) continue;
                    Object object = compositeData.get(stringArray[i]);
                    Object object2 = mXBeanMappingArray[i].fromOpenValue(object);
                    this.setters[i].invoke(obj, object2);
                }
            }
            catch (Exception exception) {
                throw DefaultMXBeanMappingFactory.invalidObjectException(exception);
            }
            return obj;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CompositeBuilderCheckGetters
    extends CompositeBuilder {
        private final MXBeanMapping[] getterConverters;
        private Throwable possibleCause;

        CompositeBuilderCheckGetters(Class<?> clazz, String[] stringArray, MXBeanMapping[] mXBeanMappingArray) {
            super(clazz, stringArray);
            this.getterConverters = mXBeanMappingArray;
        }

        @Override
        String applicable(Method[] methodArray) {
            for (int i = 0; i < methodArray.length; ++i) {
                try {
                    this.getterConverters[i].checkReconstructible();
                    continue;
                }
                catch (InvalidObjectException invalidObjectException) {
                    this.possibleCause = invalidObjectException;
                    return "method " + methodArray[i].getName() + " returns type " + "that cannot be mapped back from OpenData";
                }
            }
            return "";
        }

        @Override
        Throwable possibleCause() {
            return this.possibleCause;
        }

        @Override
        final Object fromCompositeData(CompositeData compositeData, String[] stringArray, MXBeanMapping[] mXBeanMappingArray) {
            throw new Error();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CompositeBuilderViaFrom
    extends CompositeBuilder {
        private Method fromMethod;

        CompositeBuilderViaFrom(Class<?> clazz, String[] stringArray) {
            super(clazz, stringArray);
        }

        @Override
        String applicable(Method[] methodArray) throws InvalidObjectException {
            Class<?> clazz = this.getTargetClass();
            try {
                Method method = clazz.getMethod("from", CompositeData.class);
                if (!Modifier.isStatic(method.getModifiers())) {
                    throw new InvalidObjectException("Method from(CompositeData) is not static");
                }
                if (method.getReturnType() != this.getTargetClass()) {
                    String string = "Method from(CompositeData) returns " + MXBeanIntrospector.typeName(method.getReturnType()) + " not " + MXBeanIntrospector.typeName(clazz);
                    throw new InvalidObjectException(string);
                }
                this.fromMethod = method;
                return null;
            }
            catch (InvalidObjectException invalidObjectException) {
                throw invalidObjectException;
            }
            catch (Exception exception) {
                return "no method from(CompositeData)";
            }
        }

        @Override
        final Object fromCompositeData(CompositeData compositeData, String[] stringArray, MXBeanMapping[] mXBeanMappingArray) throws InvalidObjectException {
            try {
                return this.fromMethod.invoke(null, compositeData);
            }
            catch (Exception exception) {
                throw DefaultMXBeanMappingFactory.invalidObjectException("Failed to invoke from(CompositeData)", exception);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class CompositeBuilder {
        private final Class<?> targetClass;
        private final String[] itemNames;

        CompositeBuilder(Class<?> clazz, String[] stringArray) {
            this.targetClass = clazz;
            this.itemNames = stringArray;
        }

        Class<?> getTargetClass() {
            return this.targetClass;
        }

        String[] getItemNames() {
            return this.itemNames;
        }

        abstract String applicable(Method[] var1) throws InvalidObjectException;

        Throwable possibleCause() {
            return null;
        }

        abstract Object fromCompositeData(CompositeData var1, String[] var2, MXBeanMapping[] var3) throws InvalidObjectException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class CompositeMapping
    extends NonNullMXBeanMapping {
        private final String[] itemNames;
        private final Method[] getters;
        private final MXBeanMapping[] getterMappings;
        private CompositeBuilder compositeBuilder;

        CompositeMapping(Class<?> clazz, CompositeType compositeType, String[] stringArray, Method[] methodArray, MXBeanMappingFactory mXBeanMappingFactory) throws OpenDataException {
            super(clazz, compositeType);
            assert (stringArray.length == methodArray.length);
            this.itemNames = stringArray;
            this.getters = methodArray;
            this.getterMappings = new MXBeanMapping[methodArray.length];
            for (int i = 0; i < methodArray.length; ++i) {
                Type type = methodArray[i].getGenericReturnType();
                this.getterMappings[i] = mXBeanMappingFactory.mappingForType(type, mXBeanMappingFactory);
            }
        }

        @Override
        final Object toNonNullOpenValue(Object object) throws OpenDataException {
            CompositeType compositeType = (CompositeType)this.getOpenType();
            if (object instanceof CompositeDataView) {
                return ((CompositeDataView)object).toCompositeData(compositeType);
            }
            if (object == null) {
                return null;
            }
            Object[] objectArray = new Object[this.getters.length];
            for (int i = 0; i < this.getters.length; ++i) {
                try {
                    Object object2 = this.getters[i].invoke(object, null);
                    objectArray[i] = this.getterMappings[i].toOpenValue(object2);
                    continue;
                }
                catch (Exception exception) {
                    throw DefaultMXBeanMappingFactory.openDataException("Error calling getter for " + this.itemNames[i] + ": " + exception, exception);
                }
            }
            return new CompositeDataSupport(compositeType, this.itemNames, objectArray);
        }

        /*
         * WARNING - void declaration
         */
        private synchronized void makeCompositeBuilder() throws InvalidObjectException {
            if (this.compositeBuilder != null) {
                return;
            }
            Class clazz = (Class)this.getJavaType();
            CompositeBuilder[][] compositeBuilderArrayArray = new CompositeBuilder[][]{{new CompositeBuilderViaFrom(clazz, this.itemNames)}, {new CompositeBuilderViaConstructor(clazz, this.itemNames)}, {new CompositeBuilderCheckGetters(clazz, this.itemNames, this.getterMappings), new CompositeBuilderViaSetters(clazz, this.itemNames), new CompositeBuilderViaProxy(clazz, this.itemNames)}};
            CompositeBuilder compositeBuilder = null;
            StringBuilder stringBuilder = new StringBuilder();
            Throwable throwable = null;
            block0: for (CompositeBuilder[] compositeBuilderArray : compositeBuilderArrayArray) {
                for (int i = 0; i < compositeBuilderArray.length; ++i) {
                    CompositeBuilder compositeBuilder2 = compositeBuilderArray[i];
                    String string = compositeBuilder2.applicable(this.getters);
                    if (string == null) {
                        compositeBuilder = compositeBuilder2;
                        break block0;
                    }
                    Throwable throwable2 = compositeBuilder2.possibleCause();
                    if (throwable2 != null) {
                        throwable = throwable2;
                    }
                    if (string.length() <= 0) continue;
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append("; ");
                    }
                    stringBuilder.append(string);
                    if (i == 0) continue block0;
                }
            }
            if (compositeBuilder == null) {
                void var6_9;
                String string = "Do not know how to make a " + clazz.getName() + " from a CompositeData: " + stringBuilder;
                if (throwable != null) {
                    String string2 = string + ". Remaining exceptions show a POSSIBLE cause.";
                }
                throw DefaultMXBeanMappingFactory.invalidObjectException((String)var6_9, throwable);
            }
            this.compositeBuilder = compositeBuilder;
        }

        @Override
        public void checkReconstructible() throws InvalidObjectException {
            this.makeCompositeBuilder();
        }

        @Override
        final Object fromNonNullOpenValue(Object object) throws InvalidObjectException {
            this.makeCompositeBuilder();
            return this.compositeBuilder.fromCompositeData((CompositeData)object, this.itemNames, this.getterMappings);
        }
    }

    private static final class TabularMapping
    extends NonNullMXBeanMapping {
        private final boolean sortedMap;
        private final MXBeanMapping keyMapping;
        private final MXBeanMapping valueMapping;

        TabularMapping(Type type, boolean bl, TabularType tabularType, MXBeanMapping mXBeanMapping, MXBeanMapping mXBeanMapping2) {
            super(type, tabularType);
            this.sortedMap = bl;
            this.keyMapping = mXBeanMapping;
            this.valueMapping = mXBeanMapping2;
        }

        final Object toNonNullOpenValue(Object object) throws OpenDataException {
            Object object2;
            Map map = (Map)Util.cast(object);
            if (map instanceof SortedMap && (object2 = ((SortedMap)map).comparator()) != null) {
                String string = "Cannot convert SortedMap with non-null comparator: " + object2;
                throw DefaultMXBeanMappingFactory.openDataException(string, new IllegalArgumentException(string));
            }
            object2 = (TabularType)this.getOpenType();
            TabularDataSupport tabularDataSupport = new TabularDataSupport((TabularType)object2);
            CompositeType compositeType = ((TabularType)object2).getRowType();
            for (Map.Entry entry : map.entrySet()) {
                Object object3 = this.keyMapping.toOpenValue(entry.getKey());
                Object object4 = this.valueMapping.toOpenValue(entry.getValue());
                CompositeDataSupport compositeDataSupport = new CompositeDataSupport(compositeType, keyValueArray, new Object[]{object3, object4});
                tabularDataSupport.put(compositeDataSupport);
            }
            return tabularDataSupport;
        }

        final Object fromNonNullOpenValue(Object object) throws InvalidObjectException {
            TabularData tabularData = (TabularData)object;
            Collection collection = (Collection)Util.cast(tabularData.values());
            Map<Object, Object> map = this.sortedMap ? Util.newSortedMap() : Util.newInsertionOrderMap();
            for (CompositeData compositeData : collection) {
                Object object2;
                Object object3 = this.keyMapping.fromOpenValue(compositeData.get("key"));
                if (map.put(object3, object2 = this.valueMapping.fromOpenValue(compositeData.get("value"))) == null) continue;
                String string = "Duplicate entry in TabularData: key=" + object3;
                throw new InvalidObjectException(string);
            }
            return map;
        }

        public void checkReconstructible() throws InvalidObjectException {
            this.keyMapping.checkReconstructible();
            this.valueMapping.checkReconstructible();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MXBeanRefMapping
    extends NonNullMXBeanMapping {
        MXBeanRefMapping(Type type) {
            super(type, SimpleType.OBJECTNAME);
        }

        @Override
        final Object toNonNullOpenValue(Object object) throws OpenDataException {
            MXBeanLookup mXBeanLookup = this.lookupNotNull(OpenDataException.class);
            ObjectName objectName = mXBeanLookup.mxbeanToObjectName(object);
            if (objectName == null) {
                throw new OpenDataException("No name for object: " + object);
            }
            return objectName;
        }

        @Override
        final Object fromNonNullOpenValue(Object object) throws InvalidObjectException {
            ObjectName objectName;
            MXBeanLookup mXBeanLookup = this.lookupNotNull(InvalidObjectException.class);
            Object t = mXBeanLookup.objectNameToMXBean(objectName = (ObjectName)object, (Class)this.getJavaType());
            if (t == null) {
                String string = "No MXBean for name: " + objectName;
                throw new InvalidObjectException(string);
            }
            return t;
        }

        private <T extends Exception> MXBeanLookup lookupNotNull(Class<T> clazz) throws T {
            MXBeanLookup mXBeanLookup = MXBeanLookup.getLookup();
            if (mXBeanLookup == null) {
                Exception exception;
                try {
                    Constructor<T> constructor = clazz.getConstructor(String.class);
                    exception = (Exception)constructor.newInstance("Cannot convert MXBean interface in this context");
                }
                catch (Exception exception2) {
                    throw new RuntimeException(exception2);
                }
                throw exception;
            }
            return mXBeanLookup;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CollectionMapping
    extends NonNullMXBeanMapping {
        private final Class<? extends Collection<?>> collectionClass;
        private final MXBeanMapping elementMapping;

        CollectionMapping(Type type, ArrayType<?> arrayType, Class<?> clazz, MXBeanMapping mXBeanMapping) {
            super(type, arrayType);
            Class clazz2;
            this.elementMapping = mXBeanMapping;
            Type type2 = ((ParameterizedType)type).getRawType();
            Class clazz3 = (Class)type2;
            if (clazz3 == List.class) {
                clazz2 = ArrayList.class;
            } else if (clazz3 == Set.class) {
                clazz2 = HashSet.class;
            } else if (clazz3 == SortedSet.class) {
                clazz2 = TreeSet.class;
            } else {
                assert (false);
                clazz2 = null;
            }
            this.collectionClass = (Class)Util.cast(clazz2);
        }

        @Override
        final Object toNonNullOpenValue(Object object) throws OpenDataException {
            Object[] objectArray;
            Collection collection = (Collection)object;
            if (collection instanceof SortedSet && (objectArray = ((SortedSet)collection).comparator()) != null) {
                String string = "Cannot convert SortedSet with non-null comparator: " + objectArray;
                throw DefaultMXBeanMappingFactory.openDataException(string, new IllegalArgumentException(string));
            }
            objectArray = (Object[])Array.newInstance(this.getOpenClass().getComponentType(), collection.size());
            int n = 0;
            for (Object e : collection) {
                objectArray[n++] = this.elementMapping.toOpenValue(e);
            }
            return objectArray;
        }

        @Override
        final Object fromNonNullOpenValue(Object object) throws InvalidObjectException {
            Collection collection;
            Object[] objectArray = (Object[])object;
            try {
                collection = (Collection)Util.cast(this.collectionClass.newInstance());
            }
            catch (Exception exception) {
                throw DefaultMXBeanMappingFactory.invalidObjectException("Cannot create collection", exception);
            }
            for (Object object2 : objectArray) {
                Object object3 = this.elementMapping.fromOpenValue(object2);
                if (collection.add(object3)) continue;
                String string = "Could not add " + object2 + " to " + this.collectionClass.getName() + " (duplicate set element?)";
                throw new InvalidObjectException(string);
            }
            return collection;
        }

        @Override
        public void checkReconstructible() throws InvalidObjectException {
            this.elementMapping.checkReconstructible();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ArrayMapping
    extends NonNullMXBeanMapping {
        private final MXBeanMapping elementMapping;

        ArrayMapping(Type type, ArrayType<?> arrayType, Class<?> clazz, MXBeanMapping mXBeanMapping) {
            super(type, arrayType);
            this.elementMapping = mXBeanMapping;
        }

        @Override
        final Object toNonNullOpenValue(Object object) throws OpenDataException {
            Object[] objectArray = (Object[])object;
            int n = objectArray.length;
            Object[] objectArray2 = (Object[])Array.newInstance(this.getOpenClass().getComponentType(), n);
            for (int i = 0; i < n; ++i) {
                objectArray2[i] = this.elementMapping.toOpenValue(objectArray[i]);
            }
            return objectArray2;
        }

        @Override
        final Object fromNonNullOpenValue(Object object) throws InvalidObjectException {
            Class<?> clazz;
            Object[] objectArray = (Object[])object;
            Type type = this.getJavaType();
            if (type instanceof GenericArrayType) {
                clazz = ((GenericArrayType)type).getGenericComponentType();
            } else if (type instanceof Class && ((Class)type).isArray()) {
                clazz = ((Class)type).getComponentType();
            } else {
                throw new IllegalArgumentException("Not an array: " + type);
            }
            Object[] objectArray2 = (Object[])Array.newInstance(clazz, objectArray.length);
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray2[i] = this.elementMapping.fromOpenValue(objectArray[i]);
            }
            return objectArray2;
        }

        @Override
        public void checkReconstructible() throws InvalidObjectException {
            this.elementMapping.checkReconstructible();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class EnumMapping<T extends Enum<T>>
    extends NonNullMXBeanMapping {
        private final Class<T> enumClass;

        EnumMapping(Class<T> clazz) {
            super(clazz, SimpleType.STRING);
            this.enumClass = clazz;
        }

        @Override
        final Object toNonNullOpenValue(Object object) {
            return ((Enum)object).name();
        }

        final T fromNonNullOpenValue(Object object) throws InvalidObjectException {
            try {
                return Enum.valueOf(this.enumClass, (String)object);
            }
            catch (Exception exception) {
                throw DefaultMXBeanMappingFactory.invalidObjectException("Cannot convert to enum: " + object, exception);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class IdentityMapping
    extends NonNullMXBeanMapping {
        IdentityMapping(Type type, OpenType<?> openType) {
            super(type, openType);
        }

        @Override
        boolean isIdentity() {
            return true;
        }

        @Override
        Object fromNonNullOpenValue(Object object) throws InvalidObjectException {
            return object;
        }

        @Override
        Object toNonNullOpenValue(Object object) throws OpenDataException {
            return object;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Mappings
    extends WeakHashMap<Type, WeakReference<MXBeanMapping>> {
        private Mappings() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class NonNullMXBeanMapping
    extends MXBeanMapping {
        NonNullMXBeanMapping(Type type, OpenType<?> openType) {
            super(type, openType);
        }

        @Override
        public final Object fromOpenValue(Object object) throws InvalidObjectException {
            if (object == null) {
                return null;
            }
            return this.fromNonNullOpenValue(object);
        }

        @Override
        public final Object toOpenValue(Object object) throws OpenDataException {
            if (object == null) {
                return null;
            }
            return this.toNonNullOpenValue(object);
        }

        abstract Object fromNonNullOpenValue(Object var1) throws InvalidObjectException;

        abstract Object toNonNullOpenValue(Object var1) throws OpenDataException;

        boolean isIdentity() {
            return false;
        }
    }
}

