/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.namespace;

import com.sun.jmx.namespace.HandlerInterceptor;
import com.sun.jmx.namespace.ObjectNameRouter;
import java.util.ArrayList;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.namespace.JMXNamespace;
import javax.management.namespace.JMXNamespacePermission;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamespaceInterceptor
extends HandlerInterceptor<JMXNamespace> {
    private final String targetNs;
    private final String serverName;
    private final ObjectNameRouter proc;

    public NamespaceInterceptor(String string, JMXNamespace jMXNamespace, String string2) {
        super(jMXNamespace);
        this.serverName = string;
        this.targetNs = ObjectNameRouter.normalizeNamespacePath(string2, true, true, false);
        this.proc = new ObjectNameRouter(string2, "");
    }

    public String toString() {
        return this.getClass().getName() + "(parent=" + this.serverName + ", namespace=" + this.targetNs + ")";
    }

    private MBeanServer connection() {
        MBeanServer mBeanServer = super.source();
        if (mBeanServer != null) {
            return mBeanServer;
        }
        throw new NullPointerException("getMBeanServerConnection");
    }

    @Override
    protected MBeanServer source() {
        return this.connection();
    }

    @Override
    protected MBeanServer getServerForLoading() {
        return super.source();
    }

    @Override
    protected ObjectName toSource(ObjectName objectName) {
        return this.proc.toSourceContext(objectName, true);
    }

    @Override
    protected ObjectName toTarget(ObjectName objectName) {
        return this.proc.toTargetContext(objectName, false);
    }

    @Override
    void check(ObjectName objectName, String string, String string2) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            return;
        }
        if ("getDomains".equals(string2)) {
            return;
        }
        JMXNamespacePermission jMXNamespacePermission = new JMXNamespacePermission(this.serverName, string, objectName, string2);
        securityManager.checkPermission(jMXNamespacePermission);
    }

    @Override
    void checkCreate(ObjectName objectName, String string, String string2) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            return;
        }
        JMXNamespacePermission jMXNamespacePermission = new JMXNamespacePermission(this.serverName, string, objectName, string2);
        securityManager.checkPermission(jMXNamespacePermission);
    }

    @Override
    AttributeList checkAttributes(ObjectName objectName, AttributeList attributeList, String string) {
        this.check(objectName, null, string);
        if (attributeList == null || attributeList.isEmpty()) {
            return attributeList;
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            return attributeList;
        }
        AttributeList attributeList2 = new AttributeList();
        for (Attribute attribute : attributeList.asList()) {
            try {
                this.check(objectName, attribute.getName(), string);
                attributeList2.add(attribute);
            }
            catch (SecurityException securityException) {}
        }
        return attributeList2;
    }

    @Override
    String[] checkAttributes(ObjectName objectName, String[] stringArray, String string) {
        this.check(objectName, null, string);
        if (stringArray == null || stringArray.length == 0) {
            return stringArray;
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            return stringArray;
        }
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        for (String string2 : stringArray) {
            try {
                this.check(objectName, string2, string);
                arrayList.add(string2);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    @Override
    String[] checkDomains(String[] stringArray, String string) {
        return super.checkDomains(stringArray, string);
    }

    @Override
    boolean checkQuery(ObjectName objectName, String string) {
        try {
            this.check(objectName, null, string);
            return true;
        }
        catch (SecurityException securityException) {
            return false;
        }
    }
}

