/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.utils;

import com.sun.org.apache.xml.internal.security.algorithms.SignatureAlgorithm;
import com.sun.org.apache.xml.internal.security.signature.XMLSignatureException;
import java.io.ByteArrayOutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SignerOutputStream
extends ByteArrayOutputStream {
    final SignatureAlgorithm sa;
    static Logger log = Logger.getLogger(SignerOutputStream.class.getName());

    public SignerOutputStream(SignatureAlgorithm signatureAlgorithm) {
        this.sa = signatureAlgorithm;
    }

    public void write(byte[] byArray) {
        super.write(byArray, 0, byArray.length);
        try {
            this.sa.update(byArray);
        }
        catch (XMLSignatureException xMLSignatureException) {
            throw new RuntimeException("" + xMLSignatureException);
        }
    }

    public void write(int n) {
        super.write(n);
        try {
            this.sa.update((byte)n);
        }
        catch (XMLSignatureException xMLSignatureException) {
            throw new RuntimeException("" + xMLSignatureException);
        }
    }

    public void write(byte[] byArray, int n, int n2) {
        super.write(byArray, n, n2);
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Canonicalized SignedInfo:");
            StringBuffer stringBuffer = new StringBuffer(n2);
            for (int i = n; i < n + n2; ++i) {
                stringBuffer.append((char)byArray[i]);
            }
            log.log(Level.FINE, stringBuffer.toString());
        }
        try {
            this.sa.update(byArray, n, n2);
        }
        catch (XMLSignatureException xMLSignatureException) {
            throw new RuntimeException("" + xMLSignatureException);
        }
    }
}

