/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.fastinfoset.util;

import com.sun.xml.internal.fastinfoset.CommonResourceBundle;
import com.sun.xml.internal.fastinfoset.util.KeyIntMap;

public class StringIntMap
extends KeyIntMap {
    protected StringIntMap _readOnlyMap;
    protected Entry[] _table;

    public StringIntMap(int n, float f) {
        super(n, f);
        this._table = new Entry[this._capacity];
    }

    public StringIntMap(int n) {
        this(n, 0.75f);
    }

    public StringIntMap() {
        this(16, 0.75f);
    }

    public void clear() {
        for (int i = 0; i < this._table.length; ++i) {
            this._table[i] = null;
        }
        this._size = 0;
    }

    public void setReadOnlyMap(KeyIntMap keyIntMap, boolean bl) {
        if (!(keyIntMap instanceof StringIntMap)) {
            throw new IllegalArgumentException(CommonResourceBundle.getInstance().getString("message.illegalClass", new Object[]{keyIntMap}));
        }
        this.setReadOnlyMap((StringIntMap)keyIntMap, bl);
    }

    public final void setReadOnlyMap(StringIntMap stringIntMap, boolean bl) {
        this._readOnlyMap = stringIntMap;
        if (this._readOnlyMap != null) {
            this._readOnlyMapSize = this._readOnlyMap.size();
            if (bl) {
                this.clear();
            }
        } else {
            this._readOnlyMapSize = 0;
        }
    }

    public final int obtainIndex(String string) {
        int n;
        int n2 = StringIntMap.hashHash(string.hashCode());
        if (this._readOnlyMap != null && (n = this._readOnlyMap.get(string, n2)) != -1) {
            return n;
        }
        n = StringIntMap.indexFor(n2, this._table.length);
        Entry entry = this._table[n];
        while (entry != null) {
            if (entry._hash == n2 && this.eq(string, entry._key)) {
                return entry._value;
            }
            entry = entry._next;
        }
        this.addEntry(string, n2, this._size + this._readOnlyMapSize, n);
        return -1;
    }

    public final void add(String string) {
        int n = StringIntMap.hashHash(string.hashCode());
        int n2 = StringIntMap.indexFor(n, this._table.length);
        this.addEntry(string, n, this._size + this._readOnlyMapSize, n2);
    }

    public final int get(String string) {
        return this.get(string, StringIntMap.hashHash(string.hashCode()));
    }

    private final int get(String string, int n) {
        int n2;
        if (this._readOnlyMap != null && (n2 = this._readOnlyMap.get(string, n)) != -1) {
            return n2;
        }
        n2 = StringIntMap.indexFor(n, this._table.length);
        Entry entry = this._table[n2];
        while (entry != null) {
            if (entry._hash == n && this.eq(string, entry._key)) {
                return entry._value;
            }
            entry = entry._next;
        }
        return -1;
    }

    private final void addEntry(String string, int n, int n2, int n3) {
        Entry entry = this._table[n3];
        this._table[n3] = new Entry(string, n, n2, entry);
        if (this._size++ >= this._threshold) {
            this.resize(2 * this._table.length);
        }
    }

    protected final void resize(int n) {
        this._capacity = n;
        Entry[] entryArray = this._table;
        int n2 = entryArray.length;
        if (n2 == 0x100000) {
            this._threshold = Integer.MAX_VALUE;
            return;
        }
        Entry[] entryArray2 = new Entry[this._capacity];
        this.transfer(entryArray2);
        this._table = entryArray2;
        this._threshold = (int)((float)this._capacity * this._loadFactor);
    }

    private final void transfer(Entry[] entryArray) {
        Entry[] entryArray2 = this._table;
        int n = entryArray.length;
        for (int i = 0; i < entryArray2.length; ++i) {
            Entry entry;
            Entry entry2 = entryArray2[i];
            if (entry2 == null) continue;
            entryArray2[i] = null;
            do {
                entry = entry2._next;
                int n2 = StringIntMap.indexFor(entry2._hash, n);
                entry2._next = entryArray[n2];
                entryArray[n2] = entry2;
            } while ((entry2 = entry) != null);
        }
    }

    private final boolean eq(String string, String string2) {
        return string == string2 || string.equals(string2);
    }

    protected static class Entry
    extends KeyIntMap.BaseEntry {
        final String _key;
        Entry _next;

        public Entry(String string, int n, int n2, Entry entry) {
            super(n, n2);
            this._key = string;
            this._next = entry;
        }
    }
}

