/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.protocol.soap.server;

import com.sun.xml.internal.ws.binding.BindingImpl;
import com.sun.xml.internal.ws.encoding.internal.InternalEncoder;
import com.sun.xml.internal.ws.encoding.soap.SOAPEPTFactory;
import com.sun.xml.internal.ws.encoding.soap.SOAPEncoder;
import com.sun.xml.internal.ws.encoding.soap.internal.InternalMessage;
import com.sun.xml.internal.ws.handler.LogicalMessageImpl;
import com.sun.xml.internal.ws.handler.SOAPHandlerContext;
import com.sun.xml.internal.ws.pept.ept.MessageInfo;
import com.sun.xml.internal.ws.protocol.soap.server.SOAPMessageDispatcher;
import com.sun.xml.internal.ws.server.RuntimeContext;
import com.sun.xml.internal.ws.server.RuntimeEndpointInfo;
import com.sun.xml.internal.ws.server.ServerRtException;
import com.sun.xml.internal.ws.server.provider.ProviderModel;
import com.sun.xml.internal.ws.server.provider.ProviderPeptTie;
import com.sun.xml.internal.ws.util.FastInfosetUtil;
import com.sun.xml.internal.ws.util.MessageInfoUtil;
import com.sun.xml.internal.ws.util.SOAPUtil;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Source;
import javax.xml.ws.Service;

public class ProviderSOAPMD
extends SOAPMessageDispatcher {
    protected void toMessageInfo(MessageInfo messageInfo, SOAPHandlerContext sOAPHandlerContext) {
        Object[] objectArray = new Object[1];
        RuntimeContext runtimeContext = MessageInfoUtil.getRuntimeContext(messageInfo);
        RuntimeEndpointInfo runtimeEndpointInfo = runtimeContext.getRuntimeEndpointInfo();
        Class clazz = runtimeEndpointInfo.getImplementorClass();
        ProviderModel providerModel = runtimeEndpointInfo.getProviderModel();
        boolean bl = providerModel.isSource();
        Service.Mode mode = providerModel.getServiceMode();
        if (mode == Service.Mode.PAYLOAD) {
            if (bl) {
                objectArray[0] = new LogicalMessageImpl(sOAPHandlerContext).getPayload();
            }
        } else {
            InternalMessage internalMessage = sOAPHandlerContext.getInternalMessage();
            SOAPMessage sOAPMessage = sOAPHandlerContext.getSOAPMessage();
            try {
                if (internalMessage != null) {
                    SOAPEPTFactory sOAPEPTFactory = (SOAPEPTFactory)((Object)messageInfo.getEPTFactory());
                    SOAPEncoder sOAPEncoder = sOAPEPTFactory.getSOAPEncoder();
                    sOAPMessage = sOAPEncoder.toSOAPMessage(internalMessage, sOAPMessage);
                }
                objectArray[0] = bl ? sOAPMessage.getSOAPPart().getContent() : sOAPMessage;
            }
            catch (Exception exception) {
                messageInfo.setResponseType(2);
                messageInfo.setResponse(exception);
            }
        }
        messageInfo.setData(objectArray);
        messageInfo.setMethod(ProviderPeptTie.invoke_Method);
    }

    protected void setResponseInContext(MessageInfo messageInfo, SOAPHandlerContext sOAPHandlerContext) {
        Object object = messageInfo.getResponse();
        RuntimeContext runtimeContext = MessageInfoUtil.getRuntimeContext(messageInfo);
        RuntimeEndpointInfo runtimeEndpointInfo = runtimeContext.getRuntimeEndpointInfo();
        Class clazz = runtimeEndpointInfo.getImplementorClass();
        ProviderModel providerModel = runtimeEndpointInfo.getProviderModel();
        Service.Mode mode = providerModel.getServiceMode();
        if (messageInfo.getResponseType() == 0 && mode == Service.Mode.MESSAGE) {
            SOAPMessage sOAPMessage = null;
            if (object instanceof SOAPMessage) {
                sOAPMessage = (SOAPMessage)object;
            } else {
                try {
                    Source source = (Source)object;
                    String string = ((BindingImpl)runtimeEndpointInfo.getBinding()).getBindingId();
                    sOAPMessage = SOAPUtil.createMessage(string);
                    sOAPMessage.getSOAPPart().setContent(source);
                }
                catch (SOAPException sOAPException) {
                    throw new ServerRtException("soapencoder.err", new Object[]{sOAPException});
                }
            }
            FastInfosetUtil.ensureCorrectEncoding(messageInfo, sOAPMessage);
            sOAPHandlerContext.setSOAPMessage(sOAPMessage);
            sOAPHandlerContext.setInternalMessage(null);
        } else {
            SOAPEPTFactory sOAPEPTFactory = (SOAPEPTFactory)((Object)messageInfo.getEPTFactory());
            InternalEncoder internalEncoder = sOAPEPTFactory.getInternalEncoder();
            InternalMessage internalMessage = (InternalMessage)internalEncoder.toInternalMessage(messageInfo);
            sOAPHandlerContext.setInternalMessage(internalMessage);
            sOAPHandlerContext.setSOAPMessage(null);
        }
    }
}

