/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.streaming;

import java.io.ByteArrayInputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;

public class DOMStreamReader
implements XMLStreamReader,
NamespaceContext {
    Node _current;
    Node _start;
    NamedNodeMap _namedNodeMap;
    List<Attr> _currentAttributes = new ArrayList<Attr>();
    List<Attr> _currentNamespaces = new ArrayList<Attr>();
    boolean _needAttributesSplit;
    int _state;
    private static Location dummyLocation = new Location(){

        public int getCharacterOffset() {
            return -1;
        }

        public int getColumnNumber() {
            return -1;
        }

        public int getLineNumber() {
            return -1;
        }

        public String getPublicId() {
            return null;
        }

        public String getSystemId() {
            return null;
        }
    };

    public DOMStreamReader() {
    }

    public DOMStreamReader(Node node) {
        this.setCurrentNode(node);
    }

    public void setCurrentNode(Node node) {
        this._start = this._current = node;
        this._state = 7;
    }

    public void close() throws XMLStreamException {
    }

    private void splitAttributes() {
        if (!this._needAttributesSplit) {
            return;
        }
        this._currentAttributes.clear();
        this._currentNamespaces.clear();
        this._namedNodeMap = this._current.getAttributes();
        if (this._namedNodeMap != null) {
            int n = this._namedNodeMap.getLength();
            for (int i = 0; i < n; ++i) {
                Attr attr = (Attr)this._namedNodeMap.item(i);
                String string = attr.getNodeName();
                if (string.startsWith("xmlns:") || string.equals("xmlns")) {
                    this._currentNamespaces.add(attr);
                    continue;
                }
                this._currentAttributes.add(attr);
            }
        }
        this._needAttributesSplit = false;
    }

    public int getAttributeCount() {
        if (this._state == 1) {
            this.splitAttributes();
            return this._currentAttributes.size();
        }
        throw new IllegalStateException("DOMStreamReader: getAttributeCount() called in illegal state");
    }

    public String getAttributeLocalName(int n) {
        if (this._state == 1) {
            this.splitAttributes();
            String string = this._currentAttributes.get(n).getLocalName();
            return string != null ? string : QName.valueOf(this._currentAttributes.get(n).getNodeName()).getLocalPart();
        }
        throw new IllegalStateException("DOMStreamReader: getAttributeLocalName() called in illegal state");
    }

    public QName getAttributeName(int n) {
        if (this._state == 1) {
            this.splitAttributes();
            Node node = this._currentAttributes.get(n);
            String string = node.getLocalName();
            if (string != null) {
                String string2 = node.getPrefix();
                String string3 = node.getNamespaceURI();
                return new QName(string3 != null ? string3 : "", string, string2 != null ? string2 : "");
            }
            return QName.valueOf(node.getNodeName());
        }
        throw new IllegalStateException("DOMStreamReader: getAttributeName() called in illegal state");
    }

    public String getAttributeNamespace(int n) {
        if (this._state == 1) {
            this.splitAttributes();
            String string = this._currentAttributes.get(n).getNamespaceURI();
            return string != null ? string : "";
        }
        throw new IllegalStateException("DOMStreamReader: getAttributeNamespace() called in illegal state");
    }

    public String getAttributePrefix(int n) {
        if (this._state == 1) {
            this.splitAttributes();
            String string = this._currentAttributes.get(n).getPrefix();
            return string != null ? string : "";
        }
        throw new IllegalStateException("DOMStreamReader: getAttributePrefix() called in illegal state");
    }

    public String getAttributeType(int n) {
        if (this._state == 1) {
            return "CDATA";
        }
        throw new IllegalStateException("DOMStreamReader: getAttributeType() called in illegal state");
    }

    public String getAttributeValue(int n) {
        if (this._state == 1) {
            this.splitAttributes();
            return this._currentAttributes.get(n).getNodeValue();
        }
        throw new IllegalStateException("DOMStreamReader: getAttributeValue() called in illegal state");
    }

    public String getAttributeValue(String string, String string2) {
        if (this._state == 1) {
            this.splitAttributes();
            if (this._namedNodeMap != null) {
                Node node = this._namedNodeMap.getNamedItemNS(string, string2);
                return node != null ? node.getNodeValue() : null;
            }
            return null;
        }
        throw new IllegalStateException("DOMStreamReader: getAttributeValue() called in illegal state");
    }

    public String getCharacterEncodingScheme() {
        return null;
    }

    public String getElementText() throws XMLStreamException {
        throw new RuntimeException("DOMStreamReader: getElementText() not implemented");
    }

    public String getEncoding() {
        return null;
    }

    public int getEventType() {
        return this._state;
    }

    public String getLocalName() {
        if (this._state == 1 || this._state == 2) {
            String string = this._current.getLocalName();
            return string != null ? string : QName.valueOf(this._current.getNodeName()).getLocalPart();
        }
        if (this._state == 9) {
            return this._current.getNodeName();
        }
        throw new IllegalStateException("DOMStreamReader: getAttributeValue() called in illegal state");
    }

    public Location getLocation() {
        return dummyLocation;
    }

    public QName getName() {
        if (this._state == 1 || this._state == 2) {
            String string = this._current.getLocalName();
            if (string != null) {
                String string2 = this._current.getPrefix();
                String string3 = this._current.getNamespaceURI();
                return new QName(string3 != null ? string3 : "", string, string2 != null ? string2 : "");
            }
            return QName.valueOf(this._current.getNodeName());
        }
        throw new IllegalStateException("DOMStreamReader: getName() called in illegal state");
    }

    public NamespaceContext getNamespaceContext() {
        return this;
    }

    public int getNamespaceCount() {
        if (this._state == 1 || this._state == 2) {
            this.splitAttributes();
            return this._currentNamespaces.size();
        }
        throw new IllegalStateException("DOMStreamReader: getNamespaceCount() called in illegal state");
    }

    public String getNamespacePrefix(int n) {
        if (this._state == 1 || this._state == 2) {
            this.splitAttributes();
            Attr attr = this._currentNamespaces.get(n);
            String string = attr.getLocalName();
            if (string == null) {
                string = QName.valueOf(attr.getNodeName()).getLocalPart();
            }
            return string.equals("xmlns") ? null : string;
        }
        throw new IllegalStateException("DOMStreamReader: getNamespacePrefix() called in illegal state");
    }

    public String getNamespaceURI() {
        if (this._state == 1 || this._state == 2) {
            String string = this._current.getNamespaceURI();
            return string != null ? string : "";
        }
        return null;
    }

    public String getNamespaceURI(int n) {
        if (this._state == 1 || this._state == 2) {
            this.splitAttributes();
            return this._currentNamespaces.get(n).getValue();
        }
        throw new IllegalStateException("DOMStreamReader: getNamespaceURI(int) called in illegal state");
    }

    public String getNamespaceURI(String string) {
        boolean bl;
        short s;
        if (string == null) {
            throw new IllegalArgumentException("DOMStreamReader: getNamespaceURI(String) call with a null prefix");
        }
        if (string.equals("xml")) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        if (string.equals("xmlns")) {
            return "http://www.w3.org/2000/xmlns/";
        }
        Node node = this._current;
        while ((s = node.getNodeType()) != 9 && s != 1) {
            node = node.getParentNode();
        }
        boolean bl2 = bl = string.length() == 0;
        while (node.getNodeType() != 9) {
            Attr attr;
            NamedNodeMap namedNodeMap = node.getAttributes();
            Attr attr2 = attr = bl ? (Attr)namedNodeMap.getNamedItem("xmlns") : (Attr)namedNodeMap.getNamedItem("xmlns:" + string);
            if (attr != null) {
                return attr.getValue();
            }
            node = node.getParentNode();
        }
        return null;
    }

    public String getPrefix(String string) {
        short s;
        if (string == null) {
            throw new IllegalArgumentException("DOMStreamReader: getPrefix(String) call with a null namespace URI");
        }
        if (string.equals("http://www.w3.org/XML/1998/namespace")) {
            return "xml";
        }
        if (string.equals("http://www.w3.org/2000/xmlns/")) {
            return "xmlns";
        }
        Node node = this._current;
        while ((s = node.getNodeType()) != 9 && s != 1) {
            node = node.getParentNode();
        }
        while (node.getNodeType() != 9) {
            NamedNodeMap namedNodeMap = node.getAttributes();
            for (int i = namedNodeMap.getLength() - 1; i >= 0; --i) {
                Attr attr = (Attr)namedNodeMap.item(i);
                String string2 = attr.getNodeName();
                if (!string2.startsWith("xmlns:") && !string2.equals("xmlns") || !attr.getValue().equals(string)) continue;
                if (string2.equals("xmlns")) {
                    return "";
                }
                String string3 = attr.getLocalName();
                return string3 != null ? string3 : QName.valueOf(string2).getLocalPart();
            }
            node = node.getParentNode();
        }
        return null;
    }

    public Iterator getPrefixes(String string) {
        String string2 = this.getPrefix(string);
        if (string2 == null) {
            return Collections.emptyList().iterator();
        }
        return Collections.singletonList(string2).iterator();
    }

    public String getPIData() {
        if (this._state == 3) {
            return ((ProcessingInstruction)this._current).getData();
        }
        return null;
    }

    public String getPITarget() {
        if (this._state == 3) {
            return ((ProcessingInstruction)this._current).getTarget();
        }
        return null;
    }

    public String getPrefix() {
        if (this._state == 1 || this._state == 2) {
            String string = this._current.getPrefix();
            return string != null ? string : "";
        }
        return null;
    }

    public Object getProperty(String string) throws IllegalArgumentException {
        return null;
    }

    public String getText() {
        if (this._state == 4 || this._state == 12 || this._state == 5 || this._state == 9) {
            return this._current.getNodeValue();
        }
        throw new IllegalStateException("DOMStreamReader: getTextLength() called in illegal state");
    }

    public char[] getTextCharacters() {
        return this.getText().toCharArray();
    }

    public int getTextCharacters(int n, char[] cArray, int n2, int n3) throws XMLStreamException {
        char[] cArray2 = this.getTextCharacters();
        System.arraycopy(cArray2, n, cArray, n2, n3);
        return Math.min(n3, cArray2.length - n);
    }

    public int getTextLength() {
        if (this._state == 4 || this._state == 12 || this._state == 5 || this._state == 9) {
            return this._current.getNodeValue().length();
        }
        throw new IllegalStateException("DOMStreamReader: getTextLength() called in illegal state");
    }

    public int getTextStart() {
        if (this._state == 4 || this._state == 12 || this._state == 5 || this._state == 9) {
            return 0;
        }
        throw new IllegalStateException("DOMStreamReader: getTextStart() called in illegal state");
    }

    public String getVersion() {
        return null;
    }

    public boolean hasName() {
        return this._state == 1 || this._state == 2;
    }

    public boolean hasNext() throws XMLStreamException {
        return this._state != 8;
    }

    public boolean hasText() {
        if (this._state == 4 || this._state == 12 || this._state == 5 || this._state == 9) {
            return this._current.getNodeValue().trim().length() > 0;
        }
        return false;
    }

    public boolean isAttributeSpecified(int n) {
        return false;
    }

    public boolean isCharacters() {
        return this._state == 4;
    }

    public boolean isEndElement() {
        return this._state == 2;
    }

    public boolean isStandalone() {
        return true;
    }

    public boolean isStartElement() {
        return this._state == 1;
    }

    public boolean isWhiteSpace() {
        short s = this._current.getNodeType();
        if (s == 3 || s == 4) {
            return this._current.getNodeValue().trim().length() == 0;
        }
        return false;
    }

    private static int mapNodeTypeToState(int n) {
        switch (n) {
            case 4: {
                return 12;
            }
            case 8: {
                return 5;
            }
            case 1: {
                return 1;
            }
            case 6: {
                return 15;
            }
            case 5: {
                return 9;
            }
            case 12: {
                return 14;
            }
            case 7: {
                return 3;
            }
            case 3: {
                return 4;
            }
        }
        throw new RuntimeException("DOMStreamReader: Unexpected node type");
    }

    public int next() throws XMLStreamException {
        this._needAttributesSplit = true;
        switch (this._state) {
            case 8: {
                throw new IllegalStateException("DOMStreamReader: Calling next() at END_DOCUMENT");
            }
            case 7: {
                if (this._current.getNodeType() == 1) {
                    this._state = 1;
                    return 1;
                }
                Node node = this._current.getFirstChild();
                if (node == null) {
                    this._state = 8;
                    return 8;
                }
                this._current = node;
                this._state = DOMStreamReader.mapNodeTypeToState(this._current.getNodeType());
                return this._state;
            }
            case 1: {
                this._current.normalize();
                Node node = this._current.getFirstChild();
                if (node == null) {
                    this._state = 2;
                    return 2;
                }
                this._current = node;
                this._state = DOMStreamReader.mapNodeTypeToState(this._current.getNodeType());
                return this._state;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 12: {
                if (this._current == this._start) {
                    this._state = 8;
                    return 8;
                }
                Node node = this._current.getNextSibling();
                if (node == null) {
                    this._current = this._current.getParentNode();
                    this._state = this._current == null || this._current.getNodeType() == 9 ? 8 : 2;
                    return this._state;
                }
                this._current = node;
                this._state = DOMStreamReader.mapNodeTypeToState(this._current.getNodeType());
                return this._state;
            }
        }
        throw new RuntimeException("DOMStreamReader: Unexpected internal state");
    }

    public int nextTag() throws XMLStreamException {
        int n = this.next();
        while (n == 4 && this.isWhiteSpace() || n == 12 && this.isWhiteSpace() || n == 6 || n == 3 || n == 5) {
            n = this.next();
        }
        if (n != 1 && n != 2) {
            throw new XMLStreamException("DOMStreamReader: Expected start or end tag");
        }
        return n;
    }

    public void require(int n, String string, String string2) throws XMLStreamException {
        if (n != this._state) {
            throw new XMLStreamException("DOMStreamReader: Required event type not found");
        }
        if (string != null && !string.equals(this.getNamespaceURI())) {
            throw new XMLStreamException("DOMStreamReader: Required namespaceURI not found");
        }
        if (string2 != null && !string2.equals(this.getLocalName())) {
            throw new XMLStreamException("DOMStreamReader: Required localName not found");
        }
    }

    public boolean standaloneSet() {
        return true;
    }

    private static void displayDOM(Node node, OutputStream outputStream) {
        try {
            System.out.println("\n====\n");
            TransformerFactory.newInstance().newTransformer().transform(new DOMSource(node), new StreamResult(outputStream));
            System.out.println("\n====\n");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void verifyDOMIntegrity(Node node) {
        switch (node.getNodeType()) {
            case 1: 
            case 2: {
                if (node.getLocalName() == null) {
                    System.out.println("WARNING: DOM level 1 node found");
                    System.out.println(" -> node.getNodeName() = " + node.getNodeName());
                    System.out.println(" -> node.getNamespaceURI() = " + node.getNamespaceURI());
                    System.out.println(" -> node.getLocalName() = " + node.getLocalName());
                    System.out.println(" -> node.getPrefix() = " + node.getPrefix());
                }
                if (node.getNodeType() == 2) {
                    return;
                }
                NamedNodeMap namedNodeMap = ((Element)node).getAttributes();
                for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                    DOMStreamReader.verifyDOMIntegrity(namedNodeMap.item(i));
                }
            }
            case 9: {
                NodeList nodeList = node.getChildNodes();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    DOMStreamReader.verifyDOMIntegrity(nodeList.item(i));
                }
                break;
            }
        }
    }

    public static void main(String[] stringArray) throws Exception {
        String string = "<?xml version='1.0' encoding='UTF-8'?><env:Envelope xmlns:env='http://schemas.xmlsoap.org/soap/envelope/'><env:Body><env:Fault><faultcode>env:Server</faultcode><faultstring>Internal server error</faultstring></env:Fault></env:Body></env:Envelope>";
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(new ByteArrayInputStream(string.getBytes("UTF-8")));
        DOMStreamReader dOMStreamReader = new DOMStreamReader(document);
        while (dOMStreamReader.hasNext()) {
            System.out.println("dsr.next() = " + dOMStreamReader.next());
            if (dOMStreamReader.getEventType() != 1 && dOMStreamReader.getEventType() != 2) continue;
            System.out.println("dsr.getName = " + dOMStreamReader.getName());
            if (dOMStreamReader.getEventType() != 1) continue;
            System.out.println("dsr.getAttributeCount() = " + dOMStreamReader.getAttributeCount());
        }
    }
}

