/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.transport.http.server;

import com.sun.net.httpserver.HttpContext;
import com.sun.xml.internal.ws.server.DocInfo;
import com.sun.xml.internal.ws.server.RuntimeEndpointInfo;
import com.sun.xml.internal.ws.server.ServerRtException;
import com.sun.xml.internal.ws.server.Tie;
import com.sun.xml.internal.ws.spi.runtime.Binding;
import com.sun.xml.internal.ws.transport.http.server.EndpointDocInfo;
import com.sun.xml.internal.ws.transport.http.server.EndpointEntityResolver;
import com.sun.xml.internal.ws.transport.http.server.ServerMgr;
import com.sun.xml.internal.ws.transport.http.server.WSHttpHandler;
import com.sun.xml.internal.ws.transport.http.server.WebServiceContextImpl;
import com.sun.xml.internal.ws.util.ByteArrayBuffer;
import com.sun.xml.internal.ws.util.xml.XmlUtil;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.xml.sax.EntityResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpEndpoint {
    private static final Logger logger = Logger.getLogger("javax.enterprise.resource.webservices.jaxws.server.http");
    private String address;
    private HttpContext httpContext;
    private final RuntimeEndpointInfo endpointInfo = new RuntimeEndpointInfo();
    private String primaryWsdl;
    private Executor executor;
    private final Map<String, Object> properties;
    private static final int MAX_THREADS = 5;

    public HttpEndpoint(Object object, Binding binding, List<Source> list, Map<String, Object> map, Executor executor) {
        this.endpointInfo.setImplementor(object);
        this.endpointInfo.setImplementorClass(object.getClass());
        this.endpointInfo.setBinding(binding);
        this.endpointInfo.setUrlPattern("");
        this.endpointInfo.setMetadata(list);
        this.properties = map;
        this.executor = executor;
    }

    private void setServiceName() {
        QName qName;
        if (this.properties != null && (qName = (QName)this.properties.get("javax.xml.ws.wsdl.service")) != null) {
            this.endpointInfo.setServiceName(qName);
        }
    }

    private void setPortName() {
        QName qName;
        if (this.properties != null && (qName = (QName)this.properties.get("javax.xml.ws.wsdl.port")) != null) {
            this.endpointInfo.setPortName(qName);
        }
    }

    private void setDocInfo() throws MalformedURLException {
        Object object;
        Object object2;
        List<Source> list = this.endpointInfo.getMetadata();
        String string = this.endpointInfo.getWsdlLocation();
        if (string != null) {
            object2 = this.endpointInfo.getImplementorClass().getClassLoader();
            object = ((ClassLoader)object2).getResource(string);
            if (object == null) {
                throw new ServerRtException("cannot.load.wsdl", string);
            }
            Object object3 = null;
            try {
                object3 = new StreamSource(((URL)object).openStream());
            }
            catch (IOException iOException) {
                throw new ServerRtException("server.rt.err", new Object[]{iOException});
            }
            this.primaryWsdl = ((URL)object).toExternalForm();
            object3.setSystemId(this.primaryWsdl);
            if (list == null) {
                list = new ArrayList<Source>();
                this.endpointInfo.setMetadata(list);
            }
            list.add((Source)object3);
        }
        if (list != null) {
            object2 = new HashMap();
            object = XmlUtil.newTransformer();
            for (Source source : list) {
                URL uRL;
                ByteArrayBuffer byteArrayBuffer = new ByteArrayBuffer();
                try {
                    ((Transformer)object).transform(source, new StreamResult(byteArrayBuffer));
                    byteArrayBuffer.close();
                }
                catch (TransformerException transformerException) {
                    throw new ServerRtException("server.rt.err", new Object[]{transformerException});
                }
                String string2 = source.getSystemId();
                try {
                    uRL = new URL(string2);
                }
                catch (MalformedURLException malformedURLException) {
                    logger.severe("Metadata Source's systemId=" + string2 + " is incorrect. Provide a correct one");
                    throw malformedURLException;
                }
                EndpointDocInfo endpointDocInfo = new EndpointDocInfo(uRL, byteArrayBuffer);
                DocInfo docInfo = object2.put(string2, endpointDocInfo);
                if (docInfo == null) continue;
                logger.warning("Duplicate Source objects for systemId=" + string2 + " in metadata");
            }
            this.endpointInfo.setMetadata((Map<String, DocInfo>)object2);
        }
    }

    private void findPrimaryWSDL() throws Exception {
        Object object;
        Object object2;
        Map<String, DocInfo> map = this.endpointInfo.getDocMetadata();
        if (this.primaryWsdl != null && (object2 = map.get(this.primaryWsdl)).getService() == null) {
            throw new ServerRtException("not.primary.wsdl", this.primaryWsdl);
        }
        if (map != null) {
            boolean bl = false;
            boolean bl2 = false;
            for (Map.Entry<String, DocInfo> entry3 : map.entrySet()) {
                boolean entry2;
                object = entry3.getValue();
                if (object.getService() != null) {
                    if (!bl) {
                        bl = true;
                    } else {
                        throw new ServerRtException("duplicate.primary.wsdl", entry3.getKey());
                    }
                }
                if (!object.isHavingPortType()) continue;
                if (!entry2) {
                    entry2 = true;
                    continue;
                }
                throw new ServerRtException("duplicate.abstract.wsdl", entry3.getKey());
            }
        }
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                Map.Entry<String, DocInfo> entry3;
                DocInfo docInfo = (DocInfo)entry.getValue();
                if (docInfo.getService() == null) continue;
                entry3 = new URL((String)entry.getKey());
                object = new EndpointEntityResolver(map);
                this.endpointInfo.setWsdlInfo((URL)((Object)entry3), (EntityResolver)object);
                docInfo.setQueryString("wsdl");
                break;
            }
        }
    }

    public void fillEndpointInfo() throws Exception {
        this.setServiceName();
        this.setPortName();
        this.endpointInfo.doServiceNameProcessing();
        this.endpointInfo.doPortNameProcessing();
        this.endpointInfo.doPortTypeNameProcessing();
        this.setDocInfo();
        RuntimeEndpointInfo.fillDocInfo(this.endpointInfo);
        this.findPrimaryWSDL();
    }

    public void generateWSDLDocs() {
        if (this.endpointInfo.needWSDLGeneration()) {
            this.endpointInfo.generateWSDL();
        }
    }

    public void publish(String string) {
        try {
            this.address = string;
            this.httpContext = ServerMgr.getInstance().createContext(string);
            try {
                this.publish(this.httpContext);
            }
            catch (Exception exception) {
                ServerMgr.getInstance().removeContext(this.httpContext);
                throw exception;
            }
        }
        catch (Exception exception) {
            throw new ServerRtException("server.rt.err", new Object[]{exception});
        }
    }

    public void publish(Object object) {
        this.httpContext = (HttpContext)object;
        try {
            this.publish(this.httpContext);
        }
        catch (Exception exception) {
            throw new ServerRtException("server.rt.err", new Object[]{exception});
        }
    }

    public void stop() {
        if (this.address == null) {
            this.httpContext.getServer().removeContext(this.httpContext);
        } else {
            ServerMgr.getInstance().removeContext(this.httpContext);
        }
        this.endpointInfo.endService();
    }

    private void publish(HttpContext httpContext) throws Exception {
        this.endpointInfo.verifyImplementorClass();
        this.fillEndpointInfo();
        this.endpointInfo.init();
        this.generateWSDLDocs();
        RuntimeEndpointInfo.publishWSDLDocs(this.endpointInfo);
        logger.fine("Doc Metadata=" + this.endpointInfo.getDocMetadata());
        WebServiceContextImpl webServiceContextImpl = new WebServiceContextImpl();
        this.endpointInfo.setWebServiceContext(webServiceContextImpl);
        this.endpointInfo.injectContext();
        this.endpointInfo.beginService();
        Tie tie = new Tie();
        httpContext.setHandler(new WSHttpHandler(tie, this.endpointInfo, this.executor));
    }
}

