/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.util;

import com.sun.xml.internal.ws.encoding.xml.XMLMessage;
import com.sun.xml.internal.ws.pept.ept.MessageInfo;
import com.sun.xml.internal.ws.spi.runtime.WSConnection;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.transform.stream.StreamSource;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.http.HTTPException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLConnectionUtil {
    private static final String DEFAULT_SERVER_ERROR = "<?xml version='1.0' encoding='UTF-8'?><err>Internal Server Error</err>";

    public static XMLMessage getXMLMessage(WSConnection wSConnection, MessageInfo messageInfo) {
        try {
            Map<String, List<String>> map = wSConnection.getHeaders();
            MimeHeaders mimeHeaders = new MimeHeaders();
            if (map != null) {
                for (Map.Entry<String, List<String>> entry : map.entrySet()) {
                    String string = entry.getKey();
                    for (String string2 : entry.getValue()) {
                        try {
                            mimeHeaders.addHeader(string, string2);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {}
                    }
                }
            }
            return new XMLMessage(mimeHeaders, wSConnection.getInput());
        }
        catch (Exception exception) {
            throw (HTTPException)new HTTPException(500).initCause(exception);
        }
    }

    private static void send(WSConnection wSConnection, XMLMessage xMLMessage) {
        try {
            HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
            MimeHeaders mimeHeaders = xMLMessage.getMimeHeaders();
            Iterator iterator = mimeHeaders.getAllHeaders();
            while (iterator.hasNext()) {
                MimeHeader mimeHeader = (MimeHeader)iterator.next();
                String string = mimeHeader.getName();
                ArrayList<String> arrayList = (ArrayList<String>)hashMap.get(string);
                if (arrayList == null) {
                    arrayList = new ArrayList<String>();
                    hashMap.put(string, arrayList);
                }
                arrayList.add(mimeHeader.getValue());
            }
            wSConnection.setHeaders(hashMap);
            xMLMessage.writeTo(wSConnection.getOutput());
        }
        catch (Exception exception) {
            throw (HTTPException)new HTTPException(500).initCause(exception);
        }
        try {
            wSConnection.closeOutput();
        }
        catch (Exception exception) {
            throw (HTTPException)new HTTPException(500).initCause(exception);
        }
    }

    public static void sendResponse(WSConnection wSConnection, XMLMessage xMLMessage) {
        XMLConnectionUtil.setStatus(wSConnection, xMLMessage.getStatus());
        XMLConnectionUtil.send(wSConnection, xMLMessage);
    }

    public static void sendResponseOneway(WSConnection wSConnection) {
        XMLConnectionUtil.setStatus(wSConnection, 202);
        wSConnection.getOutput();
        wSConnection.closeOutput();
    }

    public static void sendResponseError(WSConnection wSConnection, MessageInfo messageInfo) {
        try {
            StreamSource streamSource = new StreamSource(new ByteArrayInputStream(DEFAULT_SERVER_ERROR.getBytes()));
            String string = (String)messageInfo.getMetaData("com.sun.xml.ws.client.ContentNegotiation");
            XMLMessage xMLMessage = new XMLMessage(streamSource, string == "optimistic");
            XMLConnectionUtil.setStatus(wSConnection, 500);
            XMLConnectionUtil.send(wSConnection, xMLMessage);
        }
        catch (Exception exception) {
            throw new WebServiceException(exception);
        }
    }

    public static Map<String, List<String>> getHeaders(WSConnection wSConnection) {
        return wSConnection.getHeaders();
    }

    public static void setHeaders(WSConnection wSConnection, Map<String, List<String>> map) {
        wSConnection.setHeaders(map);
    }

    public static void setStatus(WSConnection wSConnection, int n) {
        wSConnection.setStatus(n);
    }
}

