/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.wsdl.parser;

import com.sun.xml.internal.ws.model.Mode;
import com.sun.xml.internal.ws.model.ParameterBinding;
import com.sun.xml.internal.ws.wsdl.parser.Binding;
import com.sun.xml.internal.ws.wsdl.parser.BindingOperation;
import com.sun.xml.internal.ws.wsdl.parser.Message;
import com.sun.xml.internal.ws.wsdl.parser.Part;
import com.sun.xml.internal.ws.wsdl.parser.Port;
import com.sun.xml.internal.ws.wsdl.parser.PortType;
import com.sun.xml.internal.ws.wsdl.parser.PortTypeOperation;
import com.sun.xml.internal.ws.wsdl.parser.Service;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSDLDocument {
    protected Map<QName, Message> messages = new HashMap<QName, Message>();
    protected Map<QName, PortType> portTypes = new HashMap<QName, PortType>();
    protected Map<QName, Binding> bindings = new HashMap<QName, Binding>();
    protected Map<QName, Service> services = new LinkedHashMap<QName, Service>();

    public void addMessage(Message message) {
        this.messages.put(message.getName(), message);
    }

    public Message getMessage(QName qName) {
        return this.messages.get(qName);
    }

    public void addPortType(PortType portType) {
        this.portTypes.put(portType.getName(), portType);
    }

    public PortType getPortType(QName qName) {
        return this.portTypes.get(qName);
    }

    public void addBinding(Binding binding) {
        this.bindings.put(binding.getName(), binding);
    }

    public Binding getBinding(QName qName) {
        return this.bindings.get(qName);
    }

    public void addService(Service service) {
        this.services.put(service.getName(), service);
    }

    public Service getService(QName qName) {
        return this.services.get(qName);
    }

    public Map<QName, Service> getServices() {
        return this.services;
    }

    public QName getFirstServiceName() {
        if (this.services.isEmpty()) {
            return null;
        }
        return this.services.values().iterator().next().getName();
    }

    public QName getFirstPortName() {
        if (this.services.isEmpty()) {
            return null;
        }
        Service service = this.services.values().iterator().next();
        Iterator iterator = service.keySet().iterator();
        QName qName = iterator.hasNext() ? (QName)iterator.next() : null;
        return qName;
    }

    private Port getFirstPort() {
        if (this.services.isEmpty()) {
            return null;
        }
        Service service = this.services.values().iterator().next();
        Collection collection = service.values();
        Port port = collection != null ? (collection.iterator().hasNext() ? (Port)collection.iterator().next() : null) : null;
        return port;
    }

    public String getBindingId() {
        Port port = this.getFirstPort();
        if (port == null) {
            return null;
        }
        Binding binding = this.bindings.get(port.getBindingName());
        if (binding == null) {
            return null;
        }
        return binding.getBindingId();
    }

    public String getBindingId(QName qName, QName qName2) {
        Binding binding;
        Port port;
        Service service = this.services.get(qName);
        if (service != null && (port = (Port)service.get(qName2)) != null && (binding = this.bindings.get(port.getBindingName())) != null) {
            return binding.getBindingId();
        }
        return null;
    }

    public Binding getBinding(QName qName, QName qName2) {
        Port port;
        Service service = this.services.get(qName);
        if (service != null && (port = (Port)service.get(qName2)) != null) {
            QName qName3 = port.getBindingName();
            return this.bindings.get(qName3);
        }
        return null;
    }

    public List<Binding> getBindings(Service service, String string) {
        ArrayList<Binding> arrayList = new ArrayList<Binding>();
        Collection collection = service.values();
        if (collection.isEmpty()) {
            return arrayList;
        }
        for (Port port : collection) {
            Binding binding = this.bindings.get(port.getName());
            if (binding == null) {
                return arrayList;
            }
            if (!binding.equals(string)) continue;
            arrayList.add(binding);
        }
        return arrayList;
    }

    public QName getPortName(QName qName, QName qName2) {
        Service service = this.services.get(qName);
        for (Port port : service.values()) {
            QName qName3 = port.getBindingName();
            assert (qName3 != null);
            Binding binding = this.bindings.get(qName3);
            QName qName4 = binding.getPortTypeName();
            assert (qName4 != null);
            if (!qName4.equals(qName2)) continue;
            return port.getName();
        }
        return null;
    }

    public void finalizeBinding(Binding binding) {
        assert (binding != null);
        QName qName = binding.getPortTypeName();
        if (qName == null) {
            return;
        }
        PortType portType = this.portTypes.get(qName);
        if (portType == null) {
            return;
        }
        for (String string : binding.keySet()) {
            Object object;
            Object object22;
            PortTypeOperation portTypeOperation = (PortTypeOperation)portType.get(string);
            if (portTypeOperation == null) {
                return;
            }
            QName qName2 = portTypeOperation.getInputMessage();
            if (qName2 == null) continue;
            Message message = this.messages.get(qName2);
            BindingOperation bindingOperation = (BindingOperation)binding.get(string);
            int n = 0;
            if (message != null) {
                for (Object object22 : message) {
                    object = bindingOperation.getInputBinding((String)object22);
                    if (!((ParameterBinding)object).isBody()) continue;
                    bindingOperation.addPart(new Part((String)object22, (ParameterBinding)object, n++), Mode.IN);
                }
            }
            n = 0;
            QName qName3 = portTypeOperation.getOutputMessage();
            if (qName3 == null || (object22 = this.messages.get(qName3)) == null) continue;
            object = ((HashSet)object22).iterator();
            while (object.hasNext()) {
                String string2 = (String)object.next();
                ParameterBinding parameterBinding = bindingOperation.getOutputBinding(string2);
                if (!parameterBinding.isBody()) continue;
                bindingOperation.addPart(new Part(string2, parameterBinding, n++), Mode.OUT);
            }
        }
    }
}

