/*
 * Decompiled with CFR 0.152.
 */
package javax.management.namespace;

import java.io.IOException;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.namespace.JMXNamespaces;

public class JMXNamespaceView {
    private static final ObjectName ALL_NAMESPACES;
    private static final int NAMESPACE_SEPARATOR_LENGTH;
    private final JMXNamespaceView parent;
    private final MBeanServerConnection here;
    private final String where;

    private static MBeanServerConnection checkRoot(MBeanServerConnection mBeanServerConnection) {
        if (mBeanServerConnection == null) {
            throw new IllegalArgumentException("namespaceRoot: null is not a valid value");
        }
        return mBeanServerConnection;
    }

    public JMXNamespaceView(MBeanServerConnection mBeanServerConnection) {
        this(null, JMXNamespaceView.checkRoot(mBeanServerConnection), "");
    }

    private JMXNamespaceView(JMXNamespaceView jMXNamespaceView, MBeanServerConnection mBeanServerConnection, String string) {
        this.parent = jMXNamespaceView;
        this.here = mBeanServerConnection;
        this.where = string;
    }

    public String where() {
        return this.where;
    }

    public String[] list() throws IOException {
        Set<ObjectName> set = this.here.queryNames(ALL_NAMESPACES, null);
        String[] stringArray = new String[set.size()];
        int n = 0;
        for (ObjectName objectName : set) {
            String string = objectName.getDomain();
            stringArray[n++] = string.substring(0, string.length() - NAMESPACE_SEPARATOR_LENGTH);
        }
        return stringArray;
    }

    public JMXNamespaceView down(String string) {
        if (string.equals("")) {
            return this;
        }
        if (string.startsWith("//")) {
            throw new IllegalArgumentException(string + ": can't start with " + "//");
        }
        String[] stringArray = string.split("//");
        JMXNamespaceView jMXNamespaceView = this;
        String string2 = this.where;
        for (String string3 : stringArray) {
            JMXNamespaceView jMXNamespaceView2;
            if (string3.equals("")) {
                throw new IllegalArgumentException(string + ": invalid path element");
            }
            string2 = JMXNamespaces.concat(string2, string3);
            jMXNamespaceView = jMXNamespaceView2 = this.makeJMXNamespaceView(this.root(), jMXNamespaceView, string2);
        }
        return jMXNamespaceView;
    }

    public JMXNamespaceView up() {
        return this.parent;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public JMXNamespaceView root() {
        if (this.parent == null) {
            return this;
        }
        return this.parent.root();
    }

    public MBeanServerConnection getMBeanServerConnection() {
        return this.here;
    }

    public ObjectName getJMXNamespaceMBeanName() {
        if (this.parent == null) {
            return null;
        }
        return JMXNamespaces.getNamespaceObjectName(this.where);
    }

    public int hashCode() {
        return this.where.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof JMXNamespaceView)) {
            return false;
        }
        if (!this.where.equals(((JMXNamespaceView)object).where)) {
            return false;
        }
        return this.root().getMBeanServerConnection().equals(((JMXNamespaceView)object).root().getMBeanServerConnection());
    }

    private JMXNamespaceView makeJMXNamespaceView(JMXNamespaceView jMXNamespaceView, JMXNamespaceView jMXNamespaceView2, String string) {
        if (string.equals("")) {
            return jMXNamespaceView;
        }
        return new JMXNamespaceView(jMXNamespaceView2, this.narrowToNamespace(jMXNamespaceView.getMBeanServerConnection(), string), string);
    }

    private MBeanServerConnection narrowToNamespace(MBeanServerConnection mBeanServerConnection, String string) {
        if (mBeanServerConnection instanceof MBeanServer) {
            return JMXNamespaces.narrowToNamespace((MBeanServer)mBeanServerConnection, string);
        }
        return JMXNamespaces.narrowToNamespace(mBeanServerConnection, string);
    }

    static {
        try {
            ALL_NAMESPACES = ObjectName.getInstance("*//:type=JMXNamespace");
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            throw new ExceptionInInitializerError(malformedObjectNameException);
        }
        NAMESPACE_SEPARATOR_LENGTH = "//".length();
    }
}

