/*
 * Decompiled with CFR 0.152.
 */
package javax.management.timer;

import com.sun.jmx.defaults.JmxProperties;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import java.util.TimerTask;
import java.util.TreeSet;
import java.util.Vector;
import java.util.logging.Level;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;
import javax.management.timer.TimerAlarmClock;
import javax.management.timer.TimerAlarmClockNotification;
import javax.management.timer.TimerMBean;
import javax.management.timer.TimerNotification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Timer
extends NotificationBroadcasterSupport
implements TimerMBean,
MBeanRegistration {
    public static final long ONE_SECOND = 1000L;
    public static final long ONE_MINUTE = 60000L;
    public static final long ONE_HOUR = 3600000L;
    public static final long ONE_DAY = 86400000L;
    public static final long ONE_WEEK = 604800000L;
    private Map<Integer, Object[]> timerTable = new Hashtable<Integer, Object[]>();
    private boolean sendPastNotifications = false;
    private transient boolean isActive = false;
    private transient long sequenceNumber = 0L;
    private static final int TIMER_NOTIF_INDEX = 0;
    private static final int TIMER_DATE_INDEX = 1;
    private static final int TIMER_PERIOD_INDEX = 2;
    private static final int TIMER_NB_OCCUR_INDEX = 3;
    private static final int ALARM_CLOCK_INDEX = 4;
    private static final int FIXED_RATE_INDEX = 5;
    private int counterID = 0;
    private java.util.Timer timer;

    @Override
    public ObjectName preRegister(MBeanServer mBeanServer, ObjectName objectName) throws Exception {
        return objectName;
    }

    @Override
    public void postRegister(Boolean bl) {
    }

    @Override
    public void preDeregister() throws Exception {
        JmxProperties.TIMER_LOGGER.logp(Level.FINER, Timer.class.getName(), "preDeregister", "stop the timer");
        this.stop();
    }

    @Override
    public void postDeregister() {
    }

    @Override
    public synchronized MBeanNotificationInfo[] getNotificationInfo() {
        TreeSet<String> treeSet = new TreeSet<String>();
        for (Object[] objectArray : this.timerTable.values()) {
            TimerNotification timerNotification = (TimerNotification)objectArray[0];
            treeSet.add(timerNotification.getType());
        }
        String[] stringArray = treeSet.toArray(new String[0]);
        return new MBeanNotificationInfo[]{new MBeanNotificationInfo(stringArray, TimerNotification.class.getName(), "Notification sent by Timer MBean")};
    }

    @Override
    public synchronized void start() {
        JmxProperties.TIMER_LOGGER.logp(Level.FINER, Timer.class.getName(), "start", "starting the timer");
        if (!this.isActive) {
            this.timer = new java.util.Timer();
            Date date = new Date();
            this.sendPastNotifications(date, this.sendPastNotifications);
            for (Object[] objectArray : this.timerTable.values()) {
                TimerAlarmClock timerAlarmClock;
                Date date2 = (Date)objectArray[1];
                boolean bl = (Boolean)objectArray[5];
                if (bl) {
                    timerAlarmClock = new TimerAlarmClock(this, date2);
                    objectArray[4] = timerAlarmClock;
                    this.timer.schedule((TimerTask)timerAlarmClock, timerAlarmClock.next);
                    continue;
                }
                timerAlarmClock = new TimerAlarmClock(this, date2.getTime() - date.getTime());
                objectArray[4] = timerAlarmClock;
                this.timer.schedule((TimerTask)timerAlarmClock, timerAlarmClock.timeout);
            }
            this.isActive = true;
            JmxProperties.TIMER_LOGGER.logp(Level.FINER, Timer.class.getName(), "start", "timer started");
        } else {
            JmxProperties.TIMER_LOGGER.logp(Level.FINER, Timer.class.getName(), "start", "the timer is already activated");
        }
    }

    @Override
    public synchronized void stop() {
        JmxProperties.TIMER_LOGGER.logp(Level.FINER, Timer.class.getName(), "stop", "stopping the timer");
        if (this.isActive) {
            for (Object[] objectArray : this.timerTable.values()) {
                TimerAlarmClock timerAlarmClock = (TimerAlarmClock)objectArray[4];
                if (timerAlarmClock == null) continue;
                timerAlarmClock.cancel();
            }
            this.timer.cancel();
            this.isActive = false;
            JmxProperties.TIMER_LOGGER.logp(Level.FINER, Timer.class.getName(), "stop", "timer stopped");
        } else {
            JmxProperties.TIMER_LOGGER.logp(Level.FINER, Timer.class.getName(), "stop", "the timer is already deactivated");
        }
    }

    @Override
    public synchronized Integer addNotification(String string, String string2, Object object, Date date, long l, long l2, boolean bl) throws IllegalArgumentException {
        if (date == null) {
            throw new IllegalArgumentException("Timer notification date cannot be null.");
        }
        if (l < 0L || l2 < 0L) {
            throw new IllegalArgumentException("Negative values for the periodicity");
        }
        Date date2 = new Date();
        if (date2.after(date)) {
            date.setTime(date2.getTime());
            if (JmxProperties.TIMER_LOGGER.isLoggable(Level.FINER)) {
                JmxProperties.TIMER_LOGGER.logp(Level.FINER, Timer.class.getName(), "addNotification", "update timer notification to add with:\n\tNotification date = " + date);
            }
        }
        Integer n = ++this.counterID;
        TimerNotification timerNotification = new TimerNotification(string, this, 0L, 0L, string2, n);
        timerNotification.setUserData(object);
        Object[] objectArray = new Object[6];
        TimerAlarmClock timerAlarmClock = bl ? new TimerAlarmClock(this, date) : new TimerAlarmClock(this, date.getTime() - date2.getTime());
        Date date3 = new Date(date.getTime());
        objectArray[0] = timerNotification;
        objectArray[1] = date3;
        objectArray[2] = l;
        objectArray[3] = l2;
        objectArray[4] = timerAlarmClock;
        objectArray[5] = bl;
        if (JmxProperties.TIMER_LOGGER.isLoggable(Level.FINER)) {
            StringBuilder stringBuilder = new StringBuilder().append("adding timer notification:\n\t").append("Notification source = ").append(timerNotification.getSource()).append("\n\tNotification type = ").append(timerNotification.getType()).append("\n\tNotification ID = ").append(n).append("\n\tNotification date = ").append(date3).append("\n\tNotification period = ").append(l).append("\n\tNotification nb of occurrences = ").append(l2).append("\n\tNotification executes at fixed rate = ").append(bl);
            JmxProperties.TIMER_LOGGER.logp(Level.FINER, Timer.class.getName(), "addNotification", stringBuilder.toString());
        }
        this.timerTable.put(n, objectArray);
        if (this.isActive) {
            if (bl) {
                this.timer.schedule((TimerTask)timerAlarmClock, timerAlarmClock.next);
            } else {
                this.timer.schedule((TimerTask)timerAlarmClock, timerAlarmClock.timeout);
            }
        }
        JmxProperties.TIMER_LOGGER.logp(Level.FINER, Timer.class.getName(), "addNotification", "timer notification added");
        return n;
    }

    @Override
    public synchronized Integer addNotification(String string, String string2, Object object, Date date, long l, long l2) throws IllegalArgumentException {
        return this.addNotification(string, string2, object, date, l, l2, false);
    }

    @Override
    public synchronized Integer addNotification(String string, String string2, Object object, Date date, long l) throws IllegalArgumentException {
        return this.addNotification(string, string2, object, date, l, 0L);
    }

    @Override
    public synchronized Integer addNotification(String string, String string2, Object object, Date date) throws IllegalArgumentException {
        return this.addNotification(string, string2, object, date, 0L, 0L);
    }

    @Override
    public synchronized void removeNotification(Integer n) throws InstanceNotFoundException {
        if (!this.timerTable.containsKey(n)) {
            throw new InstanceNotFoundException("Timer notification to remove not in the list of notifications");
        }
        Object[] objectArray = this.timerTable.get(n);
        TimerAlarmClock timerAlarmClock = (TimerAlarmClock)objectArray[4];
        if (timerAlarmClock != null) {
            timerAlarmClock.cancel();
        }
        if (JmxProperties.TIMER_LOGGER.isLoggable(Level.FINER)) {
            StringBuilder stringBuilder = new StringBuilder().append("removing timer notification:").append("\n\tNotification source = ").append(((TimerNotification)objectArray[0]).getSource()).append("\n\tNotification type = ").append(((TimerNotification)objectArray[0]).getType()).append("\n\tNotification ID = ").append(((TimerNotification)objectArray[0]).getNotificationID()).append("\n\tNotification date = ").append(objectArray[1]).append("\n\tNotification period = ").append(objectArray[2]).append("\n\tNotification nb of occurrences = ").append(objectArray[3]).append("\n\tNotification executes at fixed rate = ").append(objectArray[5]);
            JmxProperties.TIMER_LOGGER.logp(Level.FINER, Timer.class.getName(), "removeNotification", stringBuilder.toString());
        }
        this.timerTable.remove(n);
        JmxProperties.TIMER_LOGGER.logp(Level.FINER, Timer.class.getName(), "removeNotification", "timer notification removed");
    }

    @Override
    public synchronized void removeNotifications(String string) throws InstanceNotFoundException {
        Vector<Integer> vector = this.getNotificationIDs(string);
        if (vector.isEmpty()) {
            throw new InstanceNotFoundException("Timer notifications to remove not in the list of notifications");
        }
        for (Integer n : vector) {
            this.removeNotification(n);
        }
    }

    @Override
    public synchronized void removeAllNotifications() {
        for (Object[] objectArray : this.timerTable.values()) {
            TimerAlarmClock timerAlarmClock = (TimerAlarmClock)objectArray[4];
            timerAlarmClock.cancel();
        }
        JmxProperties.TIMER_LOGGER.logp(Level.FINER, Timer.class.getName(), "removeAllNotifications", "removing all timer notifications");
        this.timerTable.clear();
        JmxProperties.TIMER_LOGGER.logp(Level.FINER, Timer.class.getName(), "removeAllNotifications", "all timer notifications removed");
        this.counterID = 0;
        JmxProperties.TIMER_LOGGER.logp(Level.FINER, Timer.class.getName(), "removeAllNotifications", "timer notification counter ID reset");
    }

    @Override
    public int getNbNotifications() {
        return this.timerTable.size();
    }

    @Override
    public synchronized Vector<Integer> getAllNotificationIDs() {
        return new Vector<Integer>(this.timerTable.keySet());
    }

    @Override
    public synchronized Vector<Integer> getNotificationIDs(String string) {
        Vector<Integer> vector = new Vector<Integer>();
        for (Map.Entry<Integer, Object[]> entry : this.timerTable.entrySet()) {
            Object[] objectArray = entry.getValue();
            String string2 = ((TimerNotification)objectArray[0]).getType();
            if (!(string == null ? string2 == null : string.equals(string2))) continue;
            vector.addElement(entry.getKey());
        }
        return vector;
    }

    @Override
    public String getNotificationType(Integer n) {
        Object[] objectArray = this.timerTable.get(n);
        if (objectArray != null) {
            return ((TimerNotification)objectArray[0]).getType();
        }
        return null;
    }

    @Override
    public String getNotificationMessage(Integer n) {
        Object[] objectArray = this.timerTable.get(n);
        if (objectArray != null) {
            return ((TimerNotification)objectArray[0]).getMessage();
        }
        return null;
    }

    @Override
    public Object getNotificationUserData(Integer n) {
        Object[] objectArray = this.timerTable.get(n);
        if (objectArray != null) {
            return ((TimerNotification)objectArray[0]).getUserData();
        }
        return null;
    }

    @Override
    public Date getDate(Integer n) {
        Object[] objectArray = this.timerTable.get(n);
        if (objectArray != null) {
            Date date = (Date)objectArray[1];
            return new Date(date.getTime());
        }
        return null;
    }

    @Override
    public Long getPeriod(Integer n) {
        Object[] objectArray = this.timerTable.get(n);
        if (objectArray != null) {
            return (Long)objectArray[2];
        }
        return null;
    }

    @Override
    public Long getNbOccurences(Integer n) {
        Object[] objectArray = this.timerTable.get(n);
        if (objectArray != null) {
            return (Long)objectArray[3];
        }
        return null;
    }

    @Override
    public Boolean getFixedRate(Integer n) {
        Object[] objectArray = this.timerTable.get(n);
        if (objectArray != null) {
            Boolean bl = (Boolean)objectArray[5];
            return (boolean)bl;
        }
        return null;
    }

    @Override
    public boolean getSendPastNotifications() {
        return this.sendPastNotifications;
    }

    @Override
    public void setSendPastNotifications(boolean bl) {
        this.sendPastNotifications = bl;
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    @Override
    public boolean isEmpty() {
        return this.timerTable.isEmpty();
    }

    private synchronized void sendPastNotifications(Date date, boolean bl) {
        for (Object[] objectArray : this.timerTable.values()) {
            TimerNotification timerNotification = (TimerNotification)objectArray[0];
            Integer n = timerNotification.getNotificationID();
            Date date2 = (Date)objectArray[1];
            while (date.after(date2) && this.timerTable.containsKey(n)) {
                if (bl) {
                    if (JmxProperties.TIMER_LOGGER.isLoggable(Level.FINER)) {
                        StringBuilder stringBuilder = new StringBuilder().append("sending past timer notification:").append("\n\tNotification source = ").append(timerNotification.getSource()).append("\n\tNotification type = ").append(timerNotification.getType()).append("\n\tNotification ID = ").append(timerNotification.getNotificationID()).append("\n\tNotification date = ").append(date2).append("\n\tNotification period = ").append(objectArray[2]).append("\n\tNotification nb of occurrences = ").append(objectArray[3]).append("\n\tNotification executes at fixed rate = ").append(objectArray[5]);
                        JmxProperties.TIMER_LOGGER.logp(Level.FINER, Timer.class.getName(), "sendPastNotifications", stringBuilder.toString());
                    }
                    this.sendNotification(date2, timerNotification);
                    JmxProperties.TIMER_LOGGER.logp(Level.FINER, Timer.class.getName(), "sendPastNotifications", "past timer notification sent");
                }
                this.updateTimerTable(timerNotification.getNotificationID());
            }
        }
    }

    private synchronized void updateTimerTable(Integer n) {
        Object[] objectArray = this.timerTable.get(n);
        Date date = (Date)objectArray[1];
        Long l = (Long)objectArray[2];
        Long l2 = (Long)objectArray[3];
        Boolean bl = (Boolean)objectArray[5];
        TimerAlarmClock timerAlarmClock = (TimerAlarmClock)objectArray[4];
        if (l != 0L) {
            if (l2 == 0L || l2 > 1L) {
                date.setTime(date.getTime() + l);
                objectArray[3] = Math.max(0L, l2 - 1L);
                l2 = (Long)objectArray[3];
                if (this.isActive) {
                    if (bl.booleanValue()) {
                        timerAlarmClock = new TimerAlarmClock(this, date);
                        objectArray[4] = timerAlarmClock;
                        this.timer.schedule((TimerTask)timerAlarmClock, timerAlarmClock.next);
                    } else {
                        timerAlarmClock = new TimerAlarmClock(this, l);
                        objectArray[4] = timerAlarmClock;
                        this.timer.schedule((TimerTask)timerAlarmClock, timerAlarmClock.timeout);
                    }
                }
                if (JmxProperties.TIMER_LOGGER.isLoggable(Level.FINER)) {
                    TimerNotification timerNotification = (TimerNotification)objectArray[0];
                    StringBuilder stringBuilder = new StringBuilder().append("update timer notification with:").append("\n\tNotification source = ").append(timerNotification.getSource()).append("\n\tNotification type = ").append(timerNotification.getType()).append("\n\tNotification ID = ").append(n).append("\n\tNotification date = ").append(date).append("\n\tNotification period = ").append(l).append("\n\tNotification nb of occurrences = ").append(l2).append("\n\tNotification executes at fixed rate = ").append(bl);
                    JmxProperties.TIMER_LOGGER.logp(Level.FINER, Timer.class.getName(), "updateTimerTable", stringBuilder.toString());
                }
            } else {
                if (timerAlarmClock != null) {
                    timerAlarmClock.cancel();
                }
                this.timerTable.remove(n);
            }
        } else {
            if (timerAlarmClock != null) {
                timerAlarmClock.cancel();
            }
            this.timerTable.remove(n);
        }
    }

    void notifyAlarmClock(TimerAlarmClockNotification timerAlarmClockNotification) {
        TimerNotification timerNotification = null;
        Date date = null;
        TimerAlarmClock timerAlarmClock = (TimerAlarmClock)timerAlarmClockNotification.getSource();
        for (Object[] objectArray : this.timerTable.values()) {
            if (objectArray[4] != timerAlarmClock) continue;
            timerNotification = (TimerNotification)objectArray[0];
            date = (Date)objectArray[1];
            break;
        }
        this.sendNotification(date, timerNotification);
        this.updateTimerTable(timerNotification.getNotificationID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendNotification(Date date, TimerNotification timerNotification) {
        long l;
        if (JmxProperties.TIMER_LOGGER.isLoggable(Level.FINER)) {
            StringBuilder stringBuilder = new StringBuilder().append("sending timer notification:").append("\n\tNotification source = ").append(timerNotification.getSource()).append("\n\tNotification type = ").append(timerNotification.getType()).append("\n\tNotification ID = ").append(timerNotification.getNotificationID()).append("\n\tNotification date = ").append(date);
            JmxProperties.TIMER_LOGGER.logp(Level.FINER, Timer.class.getName(), "sendNotification", stringBuilder.toString());
        }
        Object object = this;
        synchronized (object) {
            ++this.sequenceNumber;
            l = this.sequenceNumber;
        }
        object = timerNotification;
        synchronized (object) {
            timerNotification.setTimeStamp(date.getTime());
            timerNotification.setSequenceNumber(l);
            this.sendNotification((TimerNotification)timerNotification.cloneTimerNotification());
        }
        JmxProperties.TIMER_LOGGER.logp(Level.FINER, Timer.class.getName(), "sendNotification", "timer notification sent");
    }
}

