/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.colorchooser;

import javax.swing.colorchooser.ColorModel;
import javax.swing.colorchooser.ColorModelHSL;

final class ColorModelHSV
extends ColorModel {
    ColorModelHSV() {
        super("hsv", "Hue", "Saturation", "Value", "Transparency");
    }

    void setColor(int n, float[] fArray) {
        super.setColor(n, fArray);
        ColorModelHSV.RGBtoHSV(fArray, fArray);
        fArray[3] = 1.0f - fArray[3];
    }

    int getColor(float[] fArray) {
        fArray[3] = 1.0f - fArray[3];
        ColorModelHSV.HSVtoRGB(fArray, fArray);
        return super.getColor(fArray);
    }

    int getMaximum(int n) {
        return n == 0 ? 360 : 100;
    }

    float getDefault(int n) {
        return n == 0 ? -1.0f : 1.0f;
    }

    private static float[] HSVtoRGB(float[] fArray, float[] fArray2) {
        float f;
        if (fArray2 == null) {
            fArray2 = new float[3];
        }
        float f2 = fArray[0];
        float f3 = fArray[1];
        fArray2[0] = f = fArray[2];
        fArray2[1] = f;
        fArray2[2] = f;
        if (f3 > 0.0f) {
            f2 = f2 < 1.0f ? f2 * 6.0f : 0.0f;
            int n = (int)f2;
            float f4 = f2 - (float)n;
            switch (n) {
                case 0: {
                    fArray2[1] = fArray2[1] * (1.0f - f3 * (1.0f - f4));
                    fArray2[2] = fArray2[2] * (1.0f - f3);
                    break;
                }
                case 1: {
                    fArray2[0] = fArray2[0] * (1.0f - f3 * f4);
                    fArray2[2] = fArray2[2] * (1.0f - f3);
                    break;
                }
                case 2: {
                    fArray2[0] = fArray2[0] * (1.0f - f3);
                    fArray2[2] = fArray2[2] * (1.0f - f3 * (1.0f - f4));
                    break;
                }
                case 3: {
                    fArray2[0] = fArray2[0] * (1.0f - f3);
                    fArray2[1] = fArray2[1] * (1.0f - f3 * f4);
                    break;
                }
                case 4: {
                    fArray2[0] = fArray2[0] * (1.0f - f3 * (1.0f - f4));
                    fArray2[1] = fArray2[1] * (1.0f - f3);
                    break;
                }
                case 5: {
                    fArray2[1] = fArray2[1] * (1.0f - f3);
                    fArray2[2] = fArray2[2] * (1.0f - f3 * f4);
                }
            }
        }
        return fArray2;
    }

    private static float[] RGBtoHSV(float[] fArray, float[] fArray2) {
        float f;
        float f2;
        float f3;
        if (fArray2 == null) {
            fArray2 = new float[3];
        }
        if ((f3 = (f2 = ColorModelHSL.max(fArray[0], fArray[1], fArray[2])) - (f = ColorModelHSL.min(fArray[0], fArray[1], fArray[2]))) > 0.0f) {
            f3 /= f2;
        }
        fArray2[0] = ColorModelHSL.getHue(fArray[0], fArray[1], fArray[2], f2, f);
        fArray2[1] = f3;
        fArray2[2] = f2;
        return fArray2;
    }
}

