/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.IllegalComponentStateException;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Dictionary;
import java.util.Enumeration;
import javax.swing.AbstractAction;
import javax.swing.BoundedRangeModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.SliderUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicLookAndFeel;
import javax.swing.plaf.basic.LazyActionMap;
import sun.swing.DefaultLookup;
import sun.swing.UIAction;

public class BasicSliderUI
extends SliderUI {
    private static final Actions SHARED_ACTION = new Actions();
    public static final int POSITIVE_SCROLL = 1;
    public static final int NEGATIVE_SCROLL = -1;
    public static final int MIN_SCROLL = -2;
    public static final int MAX_SCROLL = 2;
    protected Timer scrollTimer;
    protected JSlider slider;
    protected Insets focusInsets = null;
    protected Insets insetCache = null;
    protected boolean leftToRightCache = true;
    protected Rectangle focusRect = null;
    protected Rectangle contentRect = null;
    protected Rectangle labelRect = null;
    protected Rectangle tickRect = null;
    protected Rectangle trackRect = null;
    protected Rectangle thumbRect = null;
    protected int trackBuffer = 0;
    private transient boolean isDragging;
    protected TrackListener trackListener;
    protected ChangeListener changeListener;
    protected ComponentListener componentListener;
    protected FocusListener focusListener;
    protected ScrollListener scrollListener;
    protected PropertyChangeListener propertyChangeListener;
    private Handler handler;
    private int lastValue;
    private Color shadowColor;
    private Color highlightColor;
    private Color focusColor;
    private boolean checkedLabelBaselines;
    private boolean sameLabelBaselines;
    private static Rectangle unionRect = new Rectangle();

    protected Color getShadowColor() {
        return this.shadowColor;
    }

    protected Color getHighlightColor() {
        return this.highlightColor;
    }

    protected Color getFocusColor() {
        return this.focusColor;
    }

    protected boolean isDragging() {
        return this.isDragging;
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicSliderUI((JSlider)jComponent);
    }

    public BasicSliderUI(JSlider jSlider) {
    }

    public void installUI(JComponent jComponent) {
        this.slider = (JSlider)jComponent;
        this.checkedLabelBaselines = false;
        this.slider.setEnabled(this.slider.isEnabled());
        LookAndFeel.installProperty(this.slider, "opaque", Boolean.TRUE);
        this.isDragging = false;
        this.trackListener = this.createTrackListener(this.slider);
        this.changeListener = this.createChangeListener(this.slider);
        this.componentListener = this.createComponentListener(this.slider);
        this.focusListener = this.createFocusListener(this.slider);
        this.scrollListener = this.createScrollListener(this.slider);
        this.propertyChangeListener = this.createPropertyChangeListener(this.slider);
        this.installDefaults(this.slider);
        this.installListeners(this.slider);
        this.installKeyboardActions(this.slider);
        this.scrollTimer = new Timer(100, this.scrollListener);
        this.scrollTimer.setInitialDelay(300);
        this.insetCache = this.slider.getInsets();
        this.leftToRightCache = BasicGraphicsUtils.isLeftToRight(this.slider);
        this.focusRect = new Rectangle();
        this.contentRect = new Rectangle();
        this.labelRect = new Rectangle();
        this.tickRect = new Rectangle();
        this.trackRect = new Rectangle();
        this.thumbRect = new Rectangle();
        this.lastValue = this.slider.getValue();
        this.calculateGeometry();
    }

    public void uninstallUI(JComponent jComponent) {
        if (jComponent != this.slider) {
            throw new IllegalComponentStateException(this + " was asked to deinstall() " + jComponent + " when it only knows about " + this.slider + ".");
        }
        LookAndFeel.uninstallBorder(this.slider);
        this.scrollTimer.stop();
        this.scrollTimer = null;
        this.uninstallListeners(this.slider);
        this.uninstallKeyboardActions(this.slider);
        this.focusInsets = null;
        this.insetCache = null;
        this.leftToRightCache = true;
        this.focusRect = null;
        this.contentRect = null;
        this.labelRect = null;
        this.tickRect = null;
        this.trackRect = null;
        this.thumbRect = null;
        this.trackListener = null;
        this.changeListener = null;
        this.componentListener = null;
        this.focusListener = null;
        this.scrollListener = null;
        this.propertyChangeListener = null;
        this.slider = null;
    }

    protected void installDefaults(JSlider jSlider) {
        LookAndFeel.installBorder(jSlider, "Slider.border");
        LookAndFeel.installColorsAndFont(jSlider, "Slider.background", "Slider.foreground", "Slider.font");
        this.highlightColor = UIManager.getColor("Slider.highlight");
        this.shadowColor = UIManager.getColor("Slider.shadow");
        this.focusColor = UIManager.getColor("Slider.focus");
        this.focusInsets = (Insets)UIManager.get("Slider.focusInsets");
    }

    protected TrackListener createTrackListener(JSlider jSlider) {
        return new TrackListener();
    }

    protected ChangeListener createChangeListener(JSlider jSlider) {
        return this.getHandler();
    }

    protected ComponentListener createComponentListener(JSlider jSlider) {
        return this.getHandler();
    }

    protected FocusListener createFocusListener(JSlider jSlider) {
        return this.getHandler();
    }

    protected ScrollListener createScrollListener(JSlider jSlider) {
        return new ScrollListener();
    }

    protected PropertyChangeListener createPropertyChangeListener(JSlider jSlider) {
        return this.getHandler();
    }

    private Handler getHandler() {
        if (this.handler == null) {
            this.handler = new Handler();
        }
        return this.handler;
    }

    protected void installListeners(JSlider jSlider) {
        jSlider.addMouseListener(this.trackListener);
        jSlider.addMouseMotionListener(this.trackListener);
        jSlider.addFocusListener(this.focusListener);
        jSlider.addComponentListener(this.componentListener);
        jSlider.addPropertyChangeListener(this.propertyChangeListener);
        jSlider.getModel().addChangeListener(this.changeListener);
    }

    protected void uninstallListeners(JSlider jSlider) {
        jSlider.removeMouseListener(this.trackListener);
        jSlider.removeMouseMotionListener(this.trackListener);
        jSlider.removeFocusListener(this.focusListener);
        jSlider.removeComponentListener(this.componentListener);
        jSlider.removePropertyChangeListener(this.propertyChangeListener);
        jSlider.getModel().removeChangeListener(this.changeListener);
        this.handler = null;
    }

    protected void installKeyboardActions(JSlider jSlider) {
        InputMap inputMap = this.getInputMap(0, jSlider);
        SwingUtilities.replaceUIInputMap(jSlider, 0, inputMap);
        LazyActionMap.installLazyActionMap(jSlider, BasicSliderUI.class, "Slider.actionMap");
    }

    InputMap getInputMap(int n, JSlider jSlider) {
        if (n == 0) {
            InputMap inputMap;
            InputMap inputMap2 = (InputMap)DefaultLookup.get(jSlider, this, "Slider.focusInputMap");
            if (jSlider.getComponentOrientation().isLeftToRight() || (inputMap = (InputMap)DefaultLookup.get(jSlider, this, "Slider.focusInputMap.RightToLeft")) == null) {
                return inputMap2;
            }
            inputMap.setParent(inputMap2);
            return inputMap;
        }
        return null;
    }

    static void loadActionMap(LazyActionMap lazyActionMap) {
        lazyActionMap.put(new Actions("positiveUnitIncrement"));
        lazyActionMap.put(new Actions("positiveBlockIncrement"));
        lazyActionMap.put(new Actions("negativeUnitIncrement"));
        lazyActionMap.put(new Actions("negativeBlockIncrement"));
        lazyActionMap.put(new Actions("minScroll"));
        lazyActionMap.put(new Actions("maxScroll"));
    }

    protected void uninstallKeyboardActions(JSlider jSlider) {
        SwingUtilities.replaceUIActionMap(jSlider, null);
        SwingUtilities.replaceUIInputMap(jSlider, 0, null);
    }

    public int getBaseline(JComponent jComponent, int n, int n2) {
        super.getBaseline(jComponent, n, n2);
        if (this.slider.getPaintLabels() && this.labelsHaveSameBaselines()) {
            Integer n3;
            FontMetrics fontMetrics = this.slider.getFontMetrics(this.slider.getFont());
            Insets insets = this.slider.getInsets();
            Dimension dimension = this.getThumbSize();
            if (this.slider.getOrientation() == 0) {
                int n4;
                int n5 = this.getTickLength();
                int n6 = n2 - insets.top - insets.bottom - this.focusInsets.top - this.focusInsets.bottom;
                int n7 = n4 = dimension.height;
                if (this.slider.getPaintTicks()) {
                    n7 += n5;
                }
                int n8 = insets.top + this.focusInsets.top + (n6 - (n7 += this.getHeightOfTallestLabel()) - 1) / 2;
                int n9 = n4;
                int n10 = n8 + n9;
                int n11 = n5;
                if (!this.slider.getPaintTicks()) {
                    n11 = 0;
                }
                int n12 = n10 + n11;
                return n12 + fontMetrics.getAscent();
            }
            boolean bl = this.slider.getInverted();
            Integer n13 = n3 = bl ? this.getLowestValue() : this.getHighestValue();
            if (n3 != null) {
                int n14 = dimension.height;
                int n15 = Math.max(fontMetrics.getHeight() / 2, n14 / 2);
                int n16 = this.focusInsets.top + insets.top;
                int n17 = n16 + n15;
                int n18 = n2 - this.focusInsets.top - this.focusInsets.bottom - insets.top - insets.bottom - n15 - n15;
                int n19 = this.yPositionForValue(n3, n17, n18);
                return n19 - fontMetrics.getHeight() / 2 + fontMetrics.getAscent();
            }
        }
        return 0;
    }

    public Component.BaselineResizeBehavior getBaselineResizeBehavior(JComponent jComponent) {
        super.getBaselineResizeBehavior(jComponent);
        return Component.BaselineResizeBehavior.OTHER;
    }

    protected boolean labelsHaveSameBaselines() {
        if (!this.checkedLabelBaselines) {
            this.checkedLabelBaselines = true;
            Dictionary dictionary = this.slider.getLabelTable();
            if (dictionary != null) {
                this.sameLabelBaselines = true;
                Enumeration enumeration = dictionary.elements();
                int n = -1;
                while (enumeration.hasMoreElements()) {
                    JComponent jComponent = (JComponent)enumeration.nextElement();
                    Dimension dimension = jComponent.getPreferredSize();
                    int n2 = jComponent.getBaseline(dimension.width, dimension.height);
                    if (n2 >= 0) {
                        if (n == -1) {
                            n = n2;
                            continue;
                        }
                        if (n == n2) continue;
                        this.sameLabelBaselines = false;
                    } else {
                        this.sameLabelBaselines = false;
                    }
                    break;
                }
            } else {
                this.sameLabelBaselines = false;
            }
        }
        return this.sameLabelBaselines;
    }

    public Dimension getPreferredHorizontalSize() {
        Dimension dimension = (Dimension)DefaultLookup.get(this.slider, this, "Slider.horizontalSize");
        if (dimension == null) {
            dimension = new Dimension(200, 21);
        }
        return dimension;
    }

    public Dimension getPreferredVerticalSize() {
        Dimension dimension = (Dimension)DefaultLookup.get(this.slider, this, "Slider.verticalSize");
        if (dimension == null) {
            dimension = new Dimension(21, 200);
        }
        return dimension;
    }

    public Dimension getMinimumHorizontalSize() {
        Dimension dimension = (Dimension)DefaultLookup.get(this.slider, this, "Slider.minimumHorizontalSize");
        if (dimension == null) {
            dimension = new Dimension(36, 21);
        }
        return dimension;
    }

    public Dimension getMinimumVerticalSize() {
        Dimension dimension = (Dimension)DefaultLookup.get(this.slider, this, "Slider.minimumVerticalSize");
        if (dimension == null) {
            dimension = new Dimension(21, 36);
        }
        return dimension;
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        Dimension dimension;
        this.recalculateIfInsetsChanged();
        if (this.slider.getOrientation() == 1) {
            dimension = new Dimension(this.getPreferredVerticalSize());
            dimension.width = this.insetCache.left + this.insetCache.right;
            dimension.width += this.focusInsets.left + this.focusInsets.right;
            dimension.width += this.trackRect.width + this.tickRect.width + this.labelRect.width;
        } else {
            dimension = new Dimension(this.getPreferredHorizontalSize());
            dimension.height = this.insetCache.top + this.insetCache.bottom;
            dimension.height += this.focusInsets.top + this.focusInsets.bottom;
            dimension.height += this.trackRect.height + this.tickRect.height + this.labelRect.height;
        }
        return dimension;
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        Dimension dimension;
        this.recalculateIfInsetsChanged();
        if (this.slider.getOrientation() == 1) {
            dimension = new Dimension(this.getMinimumVerticalSize());
            dimension.width = this.insetCache.left + this.insetCache.right;
            dimension.width += this.focusInsets.left + this.focusInsets.right;
            dimension.width += this.trackRect.width + this.tickRect.width + this.labelRect.width;
        } else {
            dimension = new Dimension(this.getMinimumHorizontalSize());
            dimension.height = this.insetCache.top + this.insetCache.bottom;
            dimension.height += this.focusInsets.top + this.focusInsets.bottom;
            dimension.height += this.trackRect.height + this.tickRect.height + this.labelRect.height;
        }
        return dimension;
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        Dimension dimension = this.getPreferredSize(jComponent);
        if (this.slider.getOrientation() == 1) {
            dimension.height = Short.MAX_VALUE;
        } else {
            dimension.width = Short.MAX_VALUE;
        }
        return dimension;
    }

    protected void calculateGeometry() {
        this.calculateFocusRect();
        this.calculateContentRect();
        this.calculateThumbSize();
        this.calculateTrackBuffer();
        this.calculateTrackRect();
        this.calculateTickRect();
        this.calculateLabelRect();
        this.calculateThumbLocation();
    }

    protected void calculateFocusRect() {
        this.focusRect.x = this.insetCache.left;
        this.focusRect.y = this.insetCache.top;
        this.focusRect.width = this.slider.getWidth() - (this.insetCache.left + this.insetCache.right);
        this.focusRect.height = this.slider.getHeight() - (this.insetCache.top + this.insetCache.bottom);
    }

    protected void calculateThumbSize() {
        Dimension dimension = this.getThumbSize();
        this.thumbRect.setSize(dimension.width, dimension.height);
    }

    protected void calculateContentRect() {
        this.contentRect.x = this.focusRect.x + this.focusInsets.left;
        this.contentRect.y = this.focusRect.y + this.focusInsets.top;
        this.contentRect.width = this.focusRect.width - (this.focusInsets.left + this.focusInsets.right);
        this.contentRect.height = this.focusRect.height - (this.focusInsets.top + this.focusInsets.bottom);
    }

    private int getTickSpacing() {
        int n = this.slider.getMajorTickSpacing();
        int n2 = this.slider.getMinorTickSpacing();
        int n3 = n2 > 0 ? n2 : (n > 0 ? n : 0);
        return n3;
    }

    protected void calculateThumbLocation() {
        int n;
        if (this.slider.getSnapToTicks()) {
            int n2 = n = this.slider.getValue();
            int n3 = this.getTickSpacing();
            if (n3 != 0) {
                if ((n - this.slider.getMinimum()) % n3 != 0) {
                    float f = (float)(n - this.slider.getMinimum()) / (float)n3;
                    int n4 = Math.round(f);
                    if ((double)(f - (float)((int)f)) == 0.5 && n < this.lastValue) {
                        --n4;
                    }
                    n2 = this.slider.getMinimum() + n4 * n3;
                }
                if (n2 != n) {
                    this.slider.setValue(n2);
                }
            }
        }
        if (this.slider.getOrientation() == 0) {
            n = this.xPositionForValue(this.slider.getValue());
            this.thumbRect.x = n - this.thumbRect.width / 2;
            this.thumbRect.y = this.trackRect.y;
        } else {
            n = this.yPositionForValue(this.slider.getValue());
            this.thumbRect.x = this.trackRect.x;
            this.thumbRect.y = n - this.thumbRect.height / 2;
        }
    }

    protected void calculateTrackBuffer() {
        if (this.slider.getPaintLabels() && this.slider.getLabelTable() != null) {
            Component component = this.getHighestValueLabel();
            Component component2 = this.getLowestValueLabel();
            if (this.slider.getOrientation() == 0) {
                this.trackBuffer = Math.max(component.getBounds().width, component2.getBounds().width) / 2;
                this.trackBuffer = Math.max(this.trackBuffer, this.thumbRect.width / 2);
            } else {
                this.trackBuffer = Math.max(component.getBounds().height, component2.getBounds().height) / 2;
                this.trackBuffer = Math.max(this.trackBuffer, this.thumbRect.height / 2);
            }
        } else {
            this.trackBuffer = this.slider.getOrientation() == 0 ? this.thumbRect.width / 2 : this.thumbRect.height / 2;
        }
    }

    protected void calculateTrackRect() {
        if (this.slider.getOrientation() == 0) {
            int n = this.thumbRect.height;
            if (this.slider.getPaintTicks()) {
                n += this.getTickLength();
            }
            if (this.slider.getPaintLabels()) {
                n += this.getHeightOfTallestLabel();
            }
            this.trackRect.x = this.contentRect.x + this.trackBuffer;
            this.trackRect.y = this.contentRect.y + (this.contentRect.height - n - 1) / 2;
            this.trackRect.width = this.contentRect.width - this.trackBuffer * 2;
            this.trackRect.height = this.thumbRect.height;
        } else {
            int n = this.thumbRect.width;
            if (BasicGraphicsUtils.isLeftToRight(this.slider)) {
                if (this.slider.getPaintTicks()) {
                    n += this.getTickLength();
                }
                if (this.slider.getPaintLabels()) {
                    n += this.getWidthOfWidestLabel();
                }
            } else {
                if (this.slider.getPaintTicks()) {
                    n -= this.getTickLength();
                }
                if (this.slider.getPaintLabels()) {
                    n -= this.getWidthOfWidestLabel();
                }
            }
            this.trackRect.x = this.contentRect.x + (this.contentRect.width - n - 1) / 2;
            this.trackRect.y = this.contentRect.y + this.trackBuffer;
            this.trackRect.width = this.thumbRect.width;
            this.trackRect.height = this.contentRect.height - this.trackBuffer * 2;
        }
    }

    protected int getTickLength() {
        return 8;
    }

    protected void calculateTickRect() {
        if (this.slider.getOrientation() == 0) {
            this.tickRect.x = this.trackRect.x;
            this.tickRect.y = this.trackRect.y + this.trackRect.height;
            this.tickRect.width = this.trackRect.width;
            this.tickRect.height = this.slider.getPaintTicks() ? this.getTickLength() : 0;
        } else {
            this.tickRect.width = this.slider.getPaintTicks() ? this.getTickLength() : 0;
            this.tickRect.x = BasicGraphicsUtils.isLeftToRight(this.slider) ? this.trackRect.x + this.trackRect.width : this.trackRect.x - this.tickRect.width;
            this.tickRect.y = this.trackRect.y;
            this.tickRect.height = this.trackRect.height;
        }
    }

    protected void calculateLabelRect() {
        if (this.slider.getPaintLabels()) {
            if (this.slider.getOrientation() == 0) {
                this.labelRect.x = this.tickRect.x - this.trackBuffer;
                this.labelRect.y = this.tickRect.y + this.tickRect.height;
                this.labelRect.width = this.tickRect.width + this.trackBuffer * 2;
                this.labelRect.height = this.getHeightOfTallestLabel();
            } else {
                if (BasicGraphicsUtils.isLeftToRight(this.slider)) {
                    this.labelRect.x = this.tickRect.x + this.tickRect.width;
                    this.labelRect.width = this.getWidthOfWidestLabel();
                } else {
                    this.labelRect.width = this.getWidthOfWidestLabel();
                    this.labelRect.x = this.tickRect.x - this.labelRect.width;
                }
                this.labelRect.y = this.tickRect.y - this.trackBuffer;
                this.labelRect.height = this.tickRect.height + this.trackBuffer * 2;
            }
        } else if (this.slider.getOrientation() == 0) {
            this.labelRect.x = this.tickRect.x;
            this.labelRect.y = this.tickRect.y + this.tickRect.height;
            this.labelRect.width = this.tickRect.width;
            this.labelRect.height = 0;
        } else {
            this.labelRect.x = BasicGraphicsUtils.isLeftToRight(this.slider) ? this.tickRect.x + this.tickRect.width : this.tickRect.x;
            this.labelRect.y = this.tickRect.y;
            this.labelRect.width = 0;
            this.labelRect.height = this.tickRect.height;
        }
    }

    protected Dimension getThumbSize() {
        Dimension dimension = new Dimension();
        if (this.slider.getOrientation() == 1) {
            dimension.width = 20;
            dimension.height = 11;
        } else {
            dimension.width = 11;
            dimension.height = 20;
        }
        return dimension;
    }

    protected int getWidthOfWidestLabel() {
        Dictionary dictionary = this.slider.getLabelTable();
        int n = 0;
        if (dictionary != null) {
            Enumeration enumeration = dictionary.keys();
            while (enumeration.hasMoreElements()) {
                JComponent jComponent = (JComponent)dictionary.get(enumeration.nextElement());
                n = Math.max(jComponent.getPreferredSize().width, n);
            }
        }
        return n;
    }

    protected int getHeightOfTallestLabel() {
        Dictionary dictionary = this.slider.getLabelTable();
        int n = 0;
        if (dictionary != null) {
            Enumeration enumeration = dictionary.keys();
            while (enumeration.hasMoreElements()) {
                JComponent jComponent = (JComponent)dictionary.get(enumeration.nextElement());
                n = Math.max(jComponent.getPreferredSize().height, n);
            }
        }
        return n;
    }

    protected int getWidthOfHighValueLabel() {
        Component component = this.getHighestValueLabel();
        int n = 0;
        if (component != null) {
            n = component.getPreferredSize().width;
        }
        return n;
    }

    protected int getWidthOfLowValueLabel() {
        Component component = this.getLowestValueLabel();
        int n = 0;
        if (component != null) {
            n = component.getPreferredSize().width;
        }
        return n;
    }

    protected int getHeightOfHighValueLabel() {
        Component component = this.getHighestValueLabel();
        int n = 0;
        if (component != null) {
            n = component.getPreferredSize().height;
        }
        return n;
    }

    protected int getHeightOfLowValueLabel() {
        Component component = this.getLowestValueLabel();
        int n = 0;
        if (component != null) {
            n = component.getPreferredSize().height;
        }
        return n;
    }

    protected boolean drawInverted() {
        if (this.slider.getOrientation() == 0) {
            if (BasicGraphicsUtils.isLeftToRight(this.slider)) {
                return this.slider.getInverted();
            }
            return !this.slider.getInverted();
        }
        return this.slider.getInverted();
    }

    protected Integer getHighestValue() {
        Dictionary dictionary = this.slider.getLabelTable();
        if (dictionary != null) {
            Enumeration enumeration = dictionary.keys();
            int n = this.slider.getMinimum() - 1;
            while (enumeration.hasMoreElements()) {
                n = Math.max(n, (Integer)enumeration.nextElement());
            }
            if (n == this.slider.getMinimum() - 1) {
                return null;
            }
            return n;
        }
        return null;
    }

    protected Integer getLowestValue() {
        Dictionary dictionary = this.slider.getLabelTable();
        if (dictionary != null) {
            Enumeration enumeration = dictionary.keys();
            int n = this.slider.getMaximum() + 1;
            while (enumeration.hasMoreElements()) {
                n = Math.min(n, (Integer)enumeration.nextElement());
            }
            if (n == this.slider.getMaximum() + 1) {
                return null;
            }
            return n;
        }
        return null;
    }

    protected Component getLowestValueLabel() {
        Integer n = this.getLowestValue();
        if (n != null) {
            return (Component)this.slider.getLabelTable().get(n);
        }
        return null;
    }

    protected Component getHighestValueLabel() {
        Integer n = this.getHighestValue();
        if (n != null) {
            return (Component)this.slider.getLabelTable().get(n);
        }
        return null;
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        this.recalculateIfInsetsChanged();
        this.recalculateIfOrientationChanged();
        Rectangle rectangle = graphics.getClipBounds();
        if (!rectangle.intersects(this.trackRect) && this.slider.getPaintTrack()) {
            this.calculateGeometry();
        }
        if (this.slider.getPaintTrack() && rectangle.intersects(this.trackRect)) {
            this.paintTrack(graphics);
        }
        if (this.slider.getPaintTicks() && rectangle.intersects(this.tickRect)) {
            this.paintTicks(graphics);
        }
        if (this.slider.getPaintLabels() && rectangle.intersects(this.labelRect)) {
            this.paintLabels(graphics);
        }
        if (this.slider.hasFocus() && rectangle.intersects(this.focusRect)) {
            this.paintFocus(graphics);
        }
        if (rectangle.intersects(this.thumbRect)) {
            this.paintThumb(graphics);
        }
    }

    protected void recalculateIfInsetsChanged() {
        Insets insets = this.slider.getInsets();
        if (!insets.equals(this.insetCache)) {
            this.insetCache = insets;
            this.calculateGeometry();
        }
    }

    protected void recalculateIfOrientationChanged() {
        boolean bl = BasicGraphicsUtils.isLeftToRight(this.slider);
        if (bl != this.leftToRightCache) {
            this.leftToRightCache = bl;
            this.calculateGeometry();
        }
    }

    public void paintFocus(Graphics graphics) {
        graphics.setColor(this.getFocusColor());
        BasicGraphicsUtils.drawDashedRect(graphics, this.focusRect.x, this.focusRect.y, this.focusRect.width, this.focusRect.height);
    }

    public void paintTrack(Graphics graphics) {
        Rectangle rectangle = this.trackRect;
        if (this.slider.getOrientation() == 0) {
            int n = rectangle.height / 2 - 2;
            int n2 = rectangle.width;
            graphics.translate(rectangle.x, rectangle.y + n);
            graphics.setColor(this.getShadowColor());
            graphics.drawLine(0, 0, n2 - 1, 0);
            graphics.drawLine(0, 1, 0, 2);
            graphics.setColor(this.getHighlightColor());
            graphics.drawLine(0, 3, n2, 3);
            graphics.drawLine(n2, 0, n2, 3);
            graphics.setColor(Color.black);
            graphics.drawLine(1, 1, n2 - 2, 1);
            graphics.translate(-rectangle.x, -(rectangle.y + n));
        } else {
            int n = rectangle.width / 2 - 2;
            int n3 = rectangle.height;
            graphics.translate(rectangle.x + n, rectangle.y);
            graphics.setColor(this.getShadowColor());
            graphics.drawLine(0, 0, 0, n3 - 1);
            graphics.drawLine(1, 0, 2, 0);
            graphics.setColor(this.getHighlightColor());
            graphics.drawLine(3, 0, 3, n3);
            graphics.drawLine(0, n3, 3, n3);
            graphics.setColor(Color.black);
            graphics.drawLine(1, 1, 1, n3 - 2);
            graphics.translate(-(rectangle.x + n), -rectangle.y);
        }
    }

    public void paintTicks(Graphics graphics) {
        Rectangle rectangle = this.tickRect;
        graphics.setColor(DefaultLookup.getColor(this.slider, this, "Slider.tickColor", Color.black));
        if (this.slider.getOrientation() == 0) {
            int n;
            int n2;
            graphics.translate(0, rectangle.y);
            if (this.slider.getMinorTickSpacing() > 0) {
                for (n2 = this.slider.getMinimum(); n2 <= this.slider.getMaximum(); n2 += this.slider.getMinorTickSpacing()) {
                    n = this.xPositionForValue(n2);
                    this.paintMinorTickForHorizSlider(graphics, rectangle, n);
                }
            }
            if (this.slider.getMajorTickSpacing() > 0) {
                for (n2 = this.slider.getMinimum(); n2 <= this.slider.getMaximum(); n2 += this.slider.getMajorTickSpacing()) {
                    n = this.xPositionForValue(n2);
                    this.paintMajorTickForHorizSlider(graphics, rectangle, n);
                }
            }
            graphics.translate(0, -rectangle.y);
        } else {
            int n;
            graphics.translate(rectangle.x, 0);
            int n3 = this.slider.getMinimum();
            if (this.slider.getMinorTickSpacing() > 0) {
                int n4 = 0;
                if (!BasicGraphicsUtils.isLeftToRight(this.slider)) {
                    n4 = rectangle.width - rectangle.width / 2;
                    graphics.translate(n4, 0);
                }
                while (n3 <= this.slider.getMaximum()) {
                    n = this.yPositionForValue(n3);
                    this.paintMinorTickForVertSlider(graphics, rectangle, n);
                    n3 += this.slider.getMinorTickSpacing();
                }
                if (!BasicGraphicsUtils.isLeftToRight(this.slider)) {
                    graphics.translate(-n4, 0);
                }
            }
            if (this.slider.getMajorTickSpacing() > 0) {
                n3 = this.slider.getMinimum();
                if (!BasicGraphicsUtils.isLeftToRight(this.slider)) {
                    graphics.translate(2, 0);
                }
                while (n3 <= this.slider.getMaximum()) {
                    n = this.yPositionForValue(n3);
                    this.paintMajorTickForVertSlider(graphics, rectangle, n);
                    n3 += this.slider.getMajorTickSpacing();
                }
                if (!BasicGraphicsUtils.isLeftToRight(this.slider)) {
                    graphics.translate(-2, 0);
                }
            }
            graphics.translate(-rectangle.x, 0);
        }
    }

    protected void paintMinorTickForHorizSlider(Graphics graphics, Rectangle rectangle, int n) {
        graphics.drawLine(n, 0, n, rectangle.height / 2 - 1);
    }

    protected void paintMajorTickForHorizSlider(Graphics graphics, Rectangle rectangle, int n) {
        graphics.drawLine(n, 0, n, rectangle.height - 2);
    }

    protected void paintMinorTickForVertSlider(Graphics graphics, Rectangle rectangle, int n) {
        graphics.drawLine(0, n, rectangle.width / 2 - 1, n);
    }

    protected void paintMajorTickForVertSlider(Graphics graphics, Rectangle rectangle, int n) {
        graphics.drawLine(0, n, rectangle.width - 2, n);
    }

    public void paintLabels(Graphics graphics) {
        Rectangle rectangle = this.labelRect;
        Dictionary dictionary = this.slider.getLabelTable();
        if (dictionary != null) {
            Enumeration enumeration = dictionary.keys();
            int n = this.slider.getMinimum();
            int n2 = this.slider.getMaximum();
            boolean bl = this.slider.isEnabled();
            while (enumeration.hasMoreElements()) {
                Integer n3 = (Integer)enumeration.nextElement();
                int n4 = n3;
                if (n4 < n || n4 > n2) continue;
                JComponent jComponent = (JComponent)dictionary.get(n3);
                jComponent.setEnabled(bl);
                if (jComponent instanceof JLabel) {
                    Icon icon;
                    Icon icon2 = icon = jComponent.isEnabled() ? ((JLabel)jComponent).getIcon() : ((JLabel)jComponent).getDisabledIcon();
                    if (icon instanceof ImageIcon) {
                        Toolkit.getDefaultToolkit().checkImage(((ImageIcon)icon).getImage(), -1, -1, this.slider);
                    }
                }
                if (this.slider.getOrientation() == 0) {
                    graphics.translate(0, rectangle.y);
                    this.paintHorizontalLabel(graphics, n4, jComponent);
                    graphics.translate(0, -rectangle.y);
                    continue;
                }
                int n5 = 0;
                if (!BasicGraphicsUtils.isLeftToRight(this.slider)) {
                    n5 = rectangle.width - jComponent.getPreferredSize().width;
                }
                graphics.translate(rectangle.x + n5, 0);
                this.paintVerticalLabel(graphics, n4, jComponent);
                graphics.translate(-rectangle.x - n5, 0);
            }
        }
    }

    protected void paintHorizontalLabel(Graphics graphics, int n, Component component) {
        int n2 = this.xPositionForValue(n);
        int n3 = n2 - component.getPreferredSize().width / 2;
        graphics.translate(n3, 0);
        component.paint(graphics);
        graphics.translate(-n3, 0);
    }

    protected void paintVerticalLabel(Graphics graphics, int n, Component component) {
        int n2 = this.yPositionForValue(n);
        int n3 = n2 - component.getPreferredSize().height / 2;
        graphics.translate(0, n3);
        component.paint(graphics);
        graphics.translate(0, -n3);
    }

    public void paintThumb(Graphics graphics) {
        Rectangle rectangle = this.thumbRect;
        int n = rectangle.width;
        int n2 = rectangle.height;
        graphics.translate(rectangle.x, rectangle.y);
        if (this.slider.isEnabled()) {
            graphics.setColor(this.slider.getBackground());
        } else {
            graphics.setColor(this.slider.getBackground().darker());
        }
        Boolean bl = (Boolean)this.slider.getClientProperty("Slider.paintThumbArrowShape");
        if (!this.slider.getPaintTicks() && bl == null || bl == Boolean.FALSE) {
            graphics.fillRect(0, 0, n, n2);
            graphics.setColor(Color.black);
            graphics.drawLine(0, n2 - 1, n - 1, n2 - 1);
            graphics.drawLine(n - 1, 0, n - 1, n2 - 1);
            graphics.setColor(this.highlightColor);
            graphics.drawLine(0, 0, 0, n2 - 2);
            graphics.drawLine(1, 0, n - 2, 0);
            graphics.setColor(this.shadowColor);
            graphics.drawLine(1, n2 - 2, n - 2, n2 - 2);
            graphics.drawLine(n - 2, 1, n - 2, n2 - 3);
        } else if (this.slider.getOrientation() == 0) {
            int n3 = n / 2;
            graphics.fillRect(1, 1, n - 3, n2 - 1 - n3);
            Polygon polygon = new Polygon();
            polygon.addPoint(1, n2 - n3);
            polygon.addPoint(n3 - 1, n2 - 1);
            polygon.addPoint(n - 2, n2 - 1 - n3);
            graphics.fillPolygon(polygon);
            graphics.setColor(this.highlightColor);
            graphics.drawLine(0, 0, n - 2, 0);
            graphics.drawLine(0, 1, 0, n2 - 1 - n3);
            graphics.drawLine(0, n2 - n3, n3 - 1, n2 - 1);
            graphics.setColor(Color.black);
            graphics.drawLine(n - 1, 0, n - 1, n2 - 2 - n3);
            graphics.drawLine(n - 1, n2 - 1 - n3, n - 1 - n3, n2 - 1);
            graphics.setColor(this.shadowColor);
            graphics.drawLine(n - 2, 1, n - 2, n2 - 2 - n3);
            graphics.drawLine(n - 2, n2 - 1 - n3, n - 1 - n3, n2 - 2);
        } else {
            int n4 = n2 / 2;
            if (BasicGraphicsUtils.isLeftToRight(this.slider)) {
                graphics.fillRect(1, 1, n - 1 - n4, n2 - 3);
                Polygon polygon = new Polygon();
                polygon.addPoint(n - n4 - 1, 0);
                polygon.addPoint(n - 1, n4);
                polygon.addPoint(n - 1 - n4, n2 - 2);
                graphics.fillPolygon(polygon);
                graphics.setColor(this.highlightColor);
                graphics.drawLine(0, 0, 0, n2 - 2);
                graphics.drawLine(1, 0, n - 1 - n4, 0);
                graphics.drawLine(n - n4 - 1, 0, n - 1, n4);
                graphics.setColor(Color.black);
                graphics.drawLine(0, n2 - 1, n - 2 - n4, n2 - 1);
                graphics.drawLine(n - 1 - n4, n2 - 1, n - 1, n2 - 1 - n4);
                graphics.setColor(this.shadowColor);
                graphics.drawLine(1, n2 - 2, n - 2 - n4, n2 - 2);
                graphics.drawLine(n - 1 - n4, n2 - 2, n - 2, n2 - n4 - 1);
            } else {
                graphics.fillRect(5, 1, n - 1 - n4, n2 - 3);
                Polygon polygon = new Polygon();
                polygon.addPoint(n4, 0);
                polygon.addPoint(0, n4);
                polygon.addPoint(n4, n2 - 2);
                graphics.fillPolygon(polygon);
                graphics.setColor(this.highlightColor);
                graphics.drawLine(n4 - 1, 0, n - 2, 0);
                graphics.drawLine(0, n4, n4, 0);
                graphics.setColor(Color.black);
                graphics.drawLine(0, n2 - 1 - n4, n4, n2 - 1);
                graphics.drawLine(n4, n2 - 1, n - 1, n2 - 1);
                graphics.setColor(this.shadowColor);
                graphics.drawLine(n4, n2 - 2, n - 2, n2 - 2);
                graphics.drawLine(n - 1, 1, n - 1, n2 - 2);
            }
        }
        graphics.translate(-rectangle.x, -rectangle.y);
    }

    public void setThumbLocation(int n, int n2) {
        unionRect.setBounds(this.thumbRect);
        this.thumbRect.setLocation(n, n2);
        SwingUtilities.computeUnion(this.thumbRect.x, this.thumbRect.y, this.thumbRect.width, this.thumbRect.height, unionRect);
        this.slider.repaint(BasicSliderUI.unionRect.x, BasicSliderUI.unionRect.y, BasicSliderUI.unionRect.width, BasicSliderUI.unionRect.height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scrollByBlock(int n) {
        JSlider jSlider = this.slider;
        synchronized (jSlider) {
            int n2;
            int n3 = (this.slider.getMaximum() - this.slider.getMinimum()) / 10;
            if (n3 == 0) {
                n3 = 1;
            }
            if (this.slider.getSnapToTicks() && n3 < (n2 = this.getTickSpacing())) {
                n3 = n2;
            }
            n2 = n3 * (n > 0 ? 1 : -1);
            this.slider.setValue(this.slider.getValue() + n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scrollByUnit(int n) {
        JSlider jSlider = this.slider;
        synchronized (jSlider) {
            int n2;
            int n3 = n2 = n > 0 ? 1 : -1;
            if (this.slider.getSnapToTicks()) {
                n2 *= this.getTickSpacing();
            }
            this.slider.setValue(this.slider.getValue() + n2);
        }
    }

    protected void scrollDueToClickInTrack(int n) {
        this.scrollByBlock(n);
    }

    protected int xPositionForValue(int n) {
        int n2;
        int n3 = this.slider.getMinimum();
        int n4 = this.slider.getMaximum();
        int n5 = this.trackRect.width;
        double d = (double)n4 - (double)n3;
        double d2 = (double)n5 / d;
        int n6 = this.trackRect.x;
        int n7 = this.trackRect.x + (this.trackRect.width - 1);
        if (!this.drawInverted()) {
            n2 = n6;
            n2 = (int)((long)n2 + Math.round(d2 * ((double)n - (double)n3)));
        } else {
            n2 = n7;
            n2 = (int)((long)n2 - Math.round(d2 * ((double)n - (double)n3)));
        }
        n2 = Math.max(n6, n2);
        n2 = Math.min(n7, n2);
        return n2;
    }

    protected int yPositionForValue(int n) {
        return this.yPositionForValue(n, this.trackRect.y, this.trackRect.height);
    }

    protected int yPositionForValue(int n, int n2, int n3) {
        int n4;
        int n5 = this.slider.getMinimum();
        int n6 = this.slider.getMaximum();
        double d = (double)n6 - (double)n5;
        double d2 = (double)n3 / d;
        int n7 = n2 + (n3 - 1);
        if (!this.drawInverted()) {
            n4 = n2;
            n4 = (int)((long)n4 + Math.round(d2 * ((double)n6 - (double)n)));
        } else {
            n4 = n2;
            n4 = (int)((long)n4 + Math.round(d2 * ((double)n - (double)n5)));
        }
        n4 = Math.max(n2, n4);
        n4 = Math.min(n7, n4);
        return n4;
    }

    public int valueForYPosition(int n) {
        int n2;
        int n3 = this.slider.getMinimum();
        int n4 = this.slider.getMaximum();
        int n5 = this.trackRect.height;
        int n6 = this.trackRect.y;
        int n7 = this.trackRect.y + (this.trackRect.height - 1);
        if (n <= n6) {
            n2 = this.drawInverted() ? n3 : n4;
        } else if (n >= n7) {
            n2 = this.drawInverted() ? n4 : n3;
        } else {
            int n8 = n - n6;
            double d = (double)n4 - (double)n3;
            double d2 = d / (double)n5;
            int n9 = (int)Math.round((double)n8 * d2);
            n2 = this.drawInverted() ? n3 + n9 : n4 - n9;
        }
        return n2;
    }

    public int valueForXPosition(int n) {
        int n2;
        int n3 = this.slider.getMinimum();
        int n4 = this.slider.getMaximum();
        int n5 = this.trackRect.width;
        int n6 = this.trackRect.x;
        int n7 = this.trackRect.x + (this.trackRect.width - 1);
        if (n <= n6) {
            n2 = this.drawInverted() ? n4 : n3;
        } else if (n >= n7) {
            n2 = this.drawInverted() ? n3 : n4;
        } else {
            int n8 = n - n6;
            double d = (double)n4 - (double)n3;
            double d2 = d / (double)n5;
            int n9 = (int)Math.round((double)n8 * d2);
            n2 = this.drawInverted() ? n4 - n9 : n3 + n9;
        }
        return n2;
    }

    private static class Actions
    extends UIAction {
        public static final String POSITIVE_UNIT_INCREMENT = "positiveUnitIncrement";
        public static final String POSITIVE_BLOCK_INCREMENT = "positiveBlockIncrement";
        public static final String NEGATIVE_UNIT_INCREMENT = "negativeUnitIncrement";
        public static final String NEGATIVE_BLOCK_INCREMENT = "negativeBlockIncrement";
        public static final String MIN_SCROLL_INCREMENT = "minScroll";
        public static final String MAX_SCROLL_INCREMENT = "maxScroll";

        Actions() {
            super(null);
        }

        public Actions(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JSlider jSlider = (JSlider)actionEvent.getSource();
            BasicSliderUI basicSliderUI = (BasicSliderUI)BasicLookAndFeel.getUIOfType(jSlider.getUI(), BasicSliderUI.class);
            String string = this.getName();
            if (basicSliderUI == null) {
                return;
            }
            if (POSITIVE_UNIT_INCREMENT == string) {
                this.scroll(jSlider, basicSliderUI, 1, false);
            } else if (NEGATIVE_UNIT_INCREMENT == string) {
                this.scroll(jSlider, basicSliderUI, -1, false);
            } else if (POSITIVE_BLOCK_INCREMENT == string) {
                this.scroll(jSlider, basicSliderUI, 1, true);
            } else if (NEGATIVE_BLOCK_INCREMENT == string) {
                this.scroll(jSlider, basicSliderUI, -1, true);
            } else if (MIN_SCROLL_INCREMENT == string) {
                this.scroll(jSlider, basicSliderUI, -2, false);
            } else if (MAX_SCROLL_INCREMENT == string) {
                this.scroll(jSlider, basicSliderUI, 2, false);
            }
        }

        private void scroll(JSlider jSlider, BasicSliderUI basicSliderUI, int n, boolean bl) {
            boolean bl2 = jSlider.getInverted();
            if (n == -1 || n == 1) {
                if (bl2) {
                    int n2 = n = n == 1 ? -1 : 1;
                }
                if (bl) {
                    basicSliderUI.scrollByBlock(n);
                } else {
                    basicSliderUI.scrollByUnit(n);
                }
            } else {
                if (bl2) {
                    n = n == -2 ? 2 : -2;
                }
                jSlider.setValue(n == -2 ? jSlider.getMinimum() : jSlider.getMaximum());
            }
        }
    }

    static class SharedActionScroller
    extends AbstractAction {
        int dir;
        boolean block;

        public SharedActionScroller(int n, boolean bl) {
            this.dir = n;
            this.block = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JSlider jSlider = (JSlider)actionEvent.getSource();
            BasicSliderUI basicSliderUI = (BasicSliderUI)BasicLookAndFeel.getUIOfType(jSlider.getUI(), BasicSliderUI.class);
            if (basicSliderUI == null) {
                return;
            }
            SHARED_ACTION.scroll(jSlider, basicSliderUI, this.dir, this.block);
        }
    }

    public class ActionScroller
    extends AbstractAction {
        int dir;
        boolean block;
        JSlider slider;

        public ActionScroller(JSlider jSlider, int n, boolean bl) {
            this.dir = n;
            this.block = bl;
            this.slider = jSlider;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SHARED_ACTION.scroll(this.slider, BasicSliderUI.this, this.dir, this.block);
        }

        public boolean isEnabled() {
            boolean bl = true;
            if (this.slider != null) {
                bl = this.slider.isEnabled();
            }
            return bl;
        }
    }

    public class FocusHandler
    implements FocusListener {
        public void focusGained(FocusEvent focusEvent) {
            BasicSliderUI.this.getHandler().focusGained(focusEvent);
        }

        public void focusLost(FocusEvent focusEvent) {
            BasicSliderUI.this.getHandler().focusLost(focusEvent);
        }
    }

    public class ComponentHandler
    extends ComponentAdapter {
        public void componentResized(ComponentEvent componentEvent) {
            BasicSliderUI.this.getHandler().componentResized(componentEvent);
        }
    }

    public class ScrollListener
    implements ActionListener {
        int direction = 1;
        boolean useBlockIncrement;

        public ScrollListener() {
            this.direction = 1;
            this.useBlockIncrement = true;
        }

        public ScrollListener(int n, boolean bl) {
            this.direction = n;
            this.useBlockIncrement = bl;
        }

        public void setDirection(int n) {
            this.direction = n;
        }

        public void setScrollByBlock(boolean bl) {
            this.useBlockIncrement = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.useBlockIncrement) {
                BasicSliderUI.this.scrollByBlock(this.direction);
            } else {
                BasicSliderUI.this.scrollByUnit(this.direction);
            }
            if (!BasicSliderUI.this.trackListener.shouldScroll(this.direction)) {
                ((Timer)actionEvent.getSource()).stop();
            }
        }
    }

    public class TrackListener
    extends MouseInputAdapter {
        protected transient int offset;
        protected transient int currentMouseX;
        protected transient int currentMouseY;

        public void mouseReleased(MouseEvent mouseEvent) {
            if (!BasicSliderUI.this.slider.isEnabled()) {
                return;
            }
            this.offset = 0;
            BasicSliderUI.this.scrollTimer.stop();
            if (BasicSliderUI.this.slider.getSnapToTicks()) {
                BasicSliderUI.this.isDragging = false;
                BasicSliderUI.this.slider.setValueIsAdjusting(false);
            } else {
                BasicSliderUI.this.slider.setValueIsAdjusting(false);
                BasicSliderUI.this.isDragging = false;
            }
            BasicSliderUI.this.slider.repaint();
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (!BasicSliderUI.this.slider.isEnabled()) {
                return;
            }
            BasicSliderUI.this.calculateGeometry();
            this.currentMouseX = mouseEvent.getX();
            this.currentMouseY = mouseEvent.getY();
            if (BasicSliderUI.this.slider.isRequestFocusEnabled()) {
                BasicSliderUI.this.slider.requestFocus();
            }
            if (BasicSliderUI.this.thumbRect.contains(this.currentMouseX, this.currentMouseY)) {
                if (UIManager.getBoolean("Slider.onlyLeftMouseButtonDrag") && !SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    return;
                }
                switch (BasicSliderUI.this.slider.getOrientation()) {
                    case 1: {
                        this.offset = this.currentMouseY - BasicSliderUI.this.thumbRect.y;
                        break;
                    }
                    case 0: {
                        this.offset = this.currentMouseX - BasicSliderUI.this.thumbRect.x;
                    }
                }
                BasicSliderUI.this.isDragging = true;
                return;
            }
            if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
                return;
            }
            BasicSliderUI.this.isDragging = false;
            BasicSliderUI.this.slider.setValueIsAdjusting(true);
            Dimension dimension = BasicSliderUI.this.slider.getSize();
            int n = 1;
            switch (BasicSliderUI.this.slider.getOrientation()) {
                case 1: {
                    if (BasicSliderUI.this.thumbRect.isEmpty()) {
                        int n2 = dimension.height / 2;
                        if (!BasicSliderUI.this.drawInverted()) {
                            n = this.currentMouseY < n2 ? 1 : -1;
                            break;
                        }
                        n = this.currentMouseY < n2 ? -1 : 1;
                        break;
                    }
                    int n3 = BasicSliderUI.this.thumbRect.y;
                    if (!BasicSliderUI.this.drawInverted()) {
                        n = this.currentMouseY < n3 ? 1 : -1;
                        break;
                    }
                    n = this.currentMouseY < n3 ? -1 : 1;
                    break;
                }
                case 0: {
                    if (BasicSliderUI.this.thumbRect.isEmpty()) {
                        int n4 = dimension.width / 2;
                        if (!BasicSliderUI.this.drawInverted()) {
                            n = this.currentMouseX < n4 ? -1 : 1;
                            break;
                        }
                        n = this.currentMouseX < n4 ? 1 : -1;
                        break;
                    }
                    int n5 = BasicSliderUI.this.thumbRect.x;
                    if (!BasicSliderUI.this.drawInverted()) {
                        n = this.currentMouseX < n5 ? -1 : 1;
                        break;
                    }
                    int n6 = n = this.currentMouseX < n5 ? 1 : -1;
                }
            }
            if (this.shouldScroll(n)) {
                BasicSliderUI.this.scrollDueToClickInTrack(n);
            }
            if (this.shouldScroll(n)) {
                BasicSliderUI.this.scrollTimer.stop();
                BasicSliderUI.this.scrollListener.setDirection(n);
                BasicSliderUI.this.scrollTimer.start();
            }
        }

        public boolean shouldScroll(int n) {
            Rectangle rectangle = BasicSliderUI.this.thumbRect;
            if (BasicSliderUI.this.slider.getOrientation() == 1 ? ((BasicSliderUI.this.drawInverted() ? n < 0 : n > 0) ? rectangle.y <= this.currentMouseY : rectangle.y + rectangle.height >= this.currentMouseY) : ((BasicSliderUI.this.drawInverted() ? n < 0 : n > 0) ? rectangle.x + rectangle.width >= this.currentMouseX : rectangle.x <= this.currentMouseX)) {
                return false;
            }
            if (n > 0 && BasicSliderUI.this.slider.getValue() + BasicSliderUI.this.slider.getExtent() >= BasicSliderUI.this.slider.getMaximum()) {
                return false;
            }
            return n >= 0 || BasicSliderUI.this.slider.getValue() > BasicSliderUI.this.slider.getMinimum();
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (!BasicSliderUI.this.slider.isEnabled()) {
                return;
            }
            this.currentMouseX = mouseEvent.getX();
            this.currentMouseY = mouseEvent.getY();
            if (!BasicSliderUI.this.isDragging) {
                return;
            }
            BasicSliderUI.this.slider.setValueIsAdjusting(true);
            switch (BasicSliderUI.this.slider.getOrientation()) {
                case 1: {
                    int n = BasicSliderUI.this.thumbRect.height / 2;
                    int n2 = mouseEvent.getY() - this.offset;
                    int n3 = BasicSliderUI.this.trackRect.y;
                    int n4 = BasicSliderUI.this.trackRect.y + (BasicSliderUI.this.trackRect.height - 1);
                    int n5 = BasicSliderUI.this.yPositionForValue(BasicSliderUI.this.slider.getMaximum() - BasicSliderUI.this.slider.getExtent());
                    if (BasicSliderUI.this.drawInverted()) {
                        n4 = n5;
                    } else {
                        n3 = n5;
                    }
                    n2 = Math.max(n2, n3 - n);
                    n2 = Math.min(n2, n4 - n);
                    BasicSliderUI.this.setThumbLocation(BasicSliderUI.this.thumbRect.x, n2);
                    int n6 = n2 + n;
                    BasicSliderUI.this.slider.setValue(BasicSliderUI.this.valueForYPosition(n6));
                    break;
                }
                case 0: {
                    int n = BasicSliderUI.this.thumbRect.width / 2;
                    int n7 = mouseEvent.getX() - this.offset;
                    int n8 = BasicSliderUI.this.trackRect.x;
                    int n9 = BasicSliderUI.this.trackRect.x + (BasicSliderUI.this.trackRect.width - 1);
                    int n10 = BasicSliderUI.this.xPositionForValue(BasicSliderUI.this.slider.getMaximum() - BasicSliderUI.this.slider.getExtent());
                    if (BasicSliderUI.this.drawInverted()) {
                        n8 = n10;
                    } else {
                        n9 = n10;
                    }
                    n7 = Math.max(n7, n8 - n);
                    n7 = Math.min(n7, n9 - n);
                    BasicSliderUI.this.setThumbLocation(n7, BasicSliderUI.this.thumbRect.y);
                    int n11 = n7 + n;
                    BasicSliderUI.this.slider.setValue(BasicSliderUI.this.valueForXPosition(n11));
                    break;
                }
                default: {
                    return;
                }
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }
    }

    public class ChangeHandler
    implements ChangeListener {
        public void stateChanged(ChangeEvent changeEvent) {
            BasicSliderUI.this.getHandler().stateChanged(changeEvent);
        }
    }

    private class Handler
    implements ChangeListener,
    ComponentListener,
    FocusListener,
    PropertyChangeListener {
        private Handler() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            if (!BasicSliderUI.this.isDragging) {
                BasicSliderUI.this.calculateThumbLocation();
                BasicSliderUI.this.slider.repaint();
            }
            BasicSliderUI.this.lastValue = BasicSliderUI.this.slider.getValue();
        }

        public void componentHidden(ComponentEvent componentEvent) {
        }

        public void componentMoved(ComponentEvent componentEvent) {
        }

        public void componentResized(ComponentEvent componentEvent) {
            BasicSliderUI.this.calculateGeometry();
            BasicSliderUI.this.slider.repaint();
        }

        public void componentShown(ComponentEvent componentEvent) {
        }

        public void focusGained(FocusEvent focusEvent) {
            BasicSliderUI.this.slider.repaint();
        }

        public void focusLost(FocusEvent focusEvent) {
            BasicSliderUI.this.slider.repaint();
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string == "orientation" || string == "inverted" || string == "labelTable" || string == "majorTickSpacing" || string == "minorTickSpacing" || string == "paintTicks" || string == "paintTrack" || string == "font" || string == "paintLabels") {
                BasicSliderUI.this.checkedLabelBaselines = false;
                BasicSliderUI.this.calculateGeometry();
                BasicSliderUI.this.slider.repaint();
            } else if (string == "componentOrientation") {
                BasicSliderUI.this.calculateGeometry();
                BasicSliderUI.this.slider.repaint();
                InputMap inputMap = BasicSliderUI.this.getInputMap(0, BasicSliderUI.this.slider);
                SwingUtilities.replaceUIInputMap(BasicSliderUI.this.slider, 0, inputMap);
            } else if (string == "model") {
                ((BoundedRangeModel)propertyChangeEvent.getOldValue()).removeChangeListener(BasicSliderUI.this.changeListener);
                ((BoundedRangeModel)propertyChangeEvent.getNewValue()).addChangeListener(BasicSliderUI.this.changeListener);
                BasicSliderUI.this.calculateThumbLocation();
                BasicSliderUI.this.slider.repaint();
            }
        }
    }

    public class PropertyChangeHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            BasicSliderUI.this.getHandler().propertyChange(propertyChangeEvent);
        }
    }
}

