/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.synth;

import java.awt.Canvas;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Shape;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthSplitPaneDivider;
import javax.swing.plaf.synth.SynthStyle;
import sun.swing.plaf.synth.SynthUI;

class SynthSplitPaneUI
extends BasicSplitPaneUI
implements PropertyChangeListener,
SynthUI {
    private static Set<KeyStroke> managingFocusForwardTraversalKeys;
    private static Set<KeyStroke> managingFocusBackwardTraversalKeys;
    private SynthStyle style;
    private SynthStyle dividerStyle;

    SynthSplitPaneUI() {
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new SynthSplitPaneUI();
    }

    protected void installDefaults() {
        this.updateStyle(this.splitPane);
        this.setOrientation(this.splitPane.getOrientation());
        this.setContinuousLayout(this.splitPane.isContinuousLayout());
        this.resetLayoutManager();
        if (this.nonContinuousLayoutDivider == null) {
            this.setNonContinuousLayoutDivider(this.createDefaultNonContinuousLayoutDivider(), true);
        } else {
            this.setNonContinuousLayoutDivider(this.nonContinuousLayoutDivider, true);
        }
        if (managingFocusForwardTraversalKeys == null) {
            managingFocusForwardTraversalKeys = new HashSet<KeyStroke>();
            managingFocusForwardTraversalKeys.add(KeyStroke.getKeyStroke(9, 0));
        }
        this.splitPane.setFocusTraversalKeys(0, managingFocusForwardTraversalKeys);
        if (managingFocusBackwardTraversalKeys == null) {
            managingFocusBackwardTraversalKeys = new HashSet<KeyStroke>();
            managingFocusBackwardTraversalKeys.add(KeyStroke.getKeyStroke(9, 1));
        }
        this.splitPane.setFocusTraversalKeys(1, managingFocusBackwardTraversalKeys);
    }

    private void updateStyle(JSplitPane jSplitPane) {
        SynthContext synthContext = this.getContext(jSplitPane, Region.SPLIT_PANE_DIVIDER, 1);
        SynthStyle synthStyle = this.dividerStyle;
        this.dividerStyle = SynthLookAndFeel.updateStyle(synthContext, this);
        synthContext.dispose();
        synthContext = this.getContext((JComponent)jSplitPane, 1);
        SynthStyle synthStyle2 = this.style;
        this.style = SynthLookAndFeel.updateStyle(synthContext, this);
        if (this.style != synthStyle2) {
            Object object = this.style.get(synthContext, "SplitPane.size");
            if (object == null) {
                object = 6;
            }
            LookAndFeel.installProperty(jSplitPane, "dividerSize", object);
            object = this.style.get(synthContext, "SplitPane.oneTouchExpandable");
            if (object != null) {
                LookAndFeel.installProperty(jSplitPane, "oneTouchExpandable", object);
            }
            if (this.divider != null) {
                jSplitPane.remove(this.divider);
                this.divider.setDividerSize(jSplitPane.getDividerSize());
            }
            if (synthStyle2 != null) {
                this.uninstallKeyboardActions();
                this.installKeyboardActions();
            }
        }
        if (this.style != synthStyle2 || this.dividerStyle != synthStyle) {
            if (this.divider != null) {
                jSplitPane.remove(this.divider);
            }
            this.divider = this.createDefaultDivider();
            this.divider.setBasicSplitPaneUI(this);
            jSplitPane.add((Component)this.divider, "divider");
        }
        synthContext.dispose();
    }

    protected void installListeners() {
        super.installListeners();
        this.splitPane.addPropertyChangeListener(this);
    }

    protected void uninstallDefaults() {
        SynthContext synthContext = this.getContext((JComponent)this.splitPane, 1);
        this.style.uninstallDefaults(synthContext);
        synthContext.dispose();
        this.style = null;
        synthContext = this.getContext(this.splitPane, Region.SPLIT_PANE_DIVIDER, 1);
        this.dividerStyle.uninstallDefaults(synthContext);
        synthContext.dispose();
        this.dividerStyle = null;
        super.uninstallDefaults();
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        this.splitPane.removePropertyChangeListener(this);
    }

    public SynthContext getContext(JComponent jComponent) {
        return this.getContext(jComponent, this.getComponentState(jComponent));
    }

    private SynthContext getContext(JComponent jComponent, int n) {
        return SynthContext.getContext(SynthContext.class, jComponent, SynthLookAndFeel.getRegion(jComponent), this.style, n);
    }

    private Region getRegion(JComponent jComponent) {
        return SynthLookAndFeel.getRegion(jComponent);
    }

    private int getComponentState(JComponent jComponent) {
        return SynthLookAndFeel.getComponentState(jComponent);
    }

    SynthContext getContext(JComponent jComponent, Region region) {
        return this.getContext(jComponent, region, this.getComponentState(jComponent, region));
    }

    private SynthContext getContext(JComponent jComponent, Region region, int n) {
        if (region == Region.SPLIT_PANE_DIVIDER) {
            return SynthContext.getContext(SynthContext.class, jComponent, region, this.dividerStyle, n);
        }
        return SynthContext.getContext(SynthContext.class, jComponent, region, this.style, n);
    }

    private int getComponentState(JComponent jComponent, Region region) {
        int n = SynthLookAndFeel.getComponentState(jComponent);
        if (this.divider.isMouseOver()) {
            n |= 2;
        }
        return n;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (SynthLookAndFeel.shouldUpdateStyle(propertyChangeEvent)) {
            this.updateStyle((JSplitPane)propertyChangeEvent.getSource());
        }
    }

    public BasicSplitPaneDivider createDefaultDivider() {
        SynthSplitPaneDivider synthSplitPaneDivider = new SynthSplitPaneDivider(this);
        synthSplitPaneDivider.setDividerSize(this.splitPane.getDividerSize());
        return synthSplitPaneDivider;
    }

    protected Component createDefaultNonContinuousLayoutDivider() {
        return new Canvas(){

            public void paint(Graphics graphics) {
                SynthSplitPaneUI.this.paintDragDivider(graphics, 0, 0, this.getWidth(), this.getHeight());
            }
        };
    }

    public void update(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        SynthLookAndFeel.update(synthContext, graphics);
        synthContext.getPainter().paintSplitPaneBackground(synthContext, graphics, 0, 0, jComponent.getWidth(), jComponent.getHeight());
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    protected void paint(SynthContext synthContext, Graphics graphics) {
        super.paint(graphics, this.splitPane);
    }

    public void paintBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        synthContext.getPainter().paintSplitPaneBorder(synthContext, graphics, n, n2, n3, n4);
    }

    private void paintDragDivider(Graphics graphics, int n, int n2, int n3, int n4) {
        SynthContext synthContext = this.getContext((JComponent)this.splitPane, Region.SPLIT_PANE_DIVIDER);
        synthContext.setComponentState((synthContext.getComponentState() | 2) ^ 2 | 4);
        Shape shape = graphics.getClip();
        graphics.clipRect(n, n2, n3, n4);
        synthContext.getPainter().paintSplitPaneDragDivider(synthContext, graphics, n, n2, n3, n4, this.splitPane.getOrientation());
        graphics.setClip(shape);
        synthContext.dispose();
    }

    public void finishedPaintingChildren(JSplitPane jSplitPane, Graphics graphics) {
        if (jSplitPane == this.splitPane && this.getLastDragLocation() != -1 && !this.isContinuousLayout() && !this.draggingHW) {
            if (jSplitPane.getOrientation() == 1) {
                this.paintDragDivider(graphics, this.getLastDragLocation(), 0, this.dividerSize - 1, this.splitPane.getHeight() - 1);
            } else {
                this.paintDragDivider(graphics, 0, this.getLastDragLocation(), this.splitPane.getWidth() - 1, this.dividerSize - 1);
            }
        }
    }
}

