/*
 * Decompiled with CFR 0.152.
 */
package sun.management;

import com.sun.management.GcInfo;
import java.io.InvalidObjectException;
import java.lang.management.MemoryUsage;
import java.lang.reflect.Method;
import java.util.Map;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import sun.management.GcInfoBuilder;
import sun.management.LazyCompositeData;
import sun.management.MappedMXBeanType;
import sun.management.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GcInfoCompositeData
extends LazyCompositeData {
    private final GcInfo info;
    private final GcInfoBuilder builder;
    private final Object[] gcExtItemValues;
    private static final String ID = "id";
    private static final String START_TIME = "startTime";
    private static final String END_TIME = "endTime";
    private static final String DURATION = "duration";
    private static final String MEMORY_USAGE_BEFORE_GC = "memoryUsageBeforeGc";
    private static final String MEMORY_USAGE_AFTER_GC = "memoryUsageAfterGc";
    private static final String[] baseGcInfoItemNames = new String[]{"id", "startTime", "endTime", "duration", "memoryUsageBeforeGc", "memoryUsageAfterGc"};
    private static MappedMXBeanType memoryUsageMapType;
    private static OpenType[] baseGcInfoItemTypes;
    private static CompositeType baseGcInfoCompositeType;

    public GcInfoCompositeData(GcInfo gcInfo, GcInfoBuilder gcInfoBuilder, Object[] objectArray) {
        this.info = gcInfo;
        this.builder = gcInfoBuilder;
        this.gcExtItemValues = objectArray;
    }

    public GcInfo getGcInfo() {
        return this.info;
    }

    @Override
    protected CompositeData getCompositeData() {
        Object[] objectArray;
        try {
            objectArray = new Object[]{new Long(this.info.getId()), new Long(this.info.getStartTime()), new Long(this.info.getEndTime()), new Long(this.info.getDuration()), memoryUsageMapType.toOpenTypeData(this.info.getMemoryUsageBeforeGc()), memoryUsageMapType.toOpenTypeData(this.info.getMemoryUsageAfterGc())};
        }
        catch (OpenDataException openDataException) {
            throw new AssertionError((Object)openDataException);
        }
        int n = this.builder.getGcExtItemCount();
        if (n == 0 && this.gcExtItemValues != null && this.gcExtItemValues.length != 0) {
            throw new AssertionError((Object)"Unexpected Gc Extension Item Values");
        }
        if (n > 0 && (this.gcExtItemValues == null || n != this.gcExtItemValues.length)) {
            throw new AssertionError((Object)"Unmatched Gc Extension Item Values");
        }
        Object[] objectArray2 = new Object[objectArray.length + n];
        System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
        if (n > 0) {
            System.arraycopy(this.gcExtItemValues, 0, objectArray2, objectArray.length, n);
        }
        try {
            return new CompositeDataSupport(this.builder.getGcInfoCompositeType(), this.builder.getItemNames(), objectArray2);
        }
        catch (OpenDataException openDataException) {
            throw new AssertionError((Object)openDataException);
        }
    }

    static String[] getBaseGcInfoItemNames() {
        return baseGcInfoItemNames;
    }

    static synchronized OpenType[] getBaseGcInfoItemTypes() {
        if (baseGcInfoItemTypes == null) {
            OpenType openType = memoryUsageMapType.getOpenType();
            baseGcInfoItemTypes = new OpenType[]{SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, openType, openType};
        }
        return baseGcInfoItemTypes;
    }

    public static long getId(CompositeData compositeData) {
        return GcInfoCompositeData.getLong(compositeData, ID);
    }

    public static long getStartTime(CompositeData compositeData) {
        return GcInfoCompositeData.getLong(compositeData, START_TIME);
    }

    public static long getEndTime(CompositeData compositeData) {
        return GcInfoCompositeData.getLong(compositeData, END_TIME);
    }

    public static Map<String, MemoryUsage> getMemoryUsageBeforeGc(CompositeData compositeData) {
        try {
            TabularData tabularData = (TabularData)compositeData.get(MEMORY_USAGE_BEFORE_GC);
            return GcInfoCompositeData.cast(memoryUsageMapType.toJavaTypeData(tabularData));
        }
        catch (InvalidObjectException invalidObjectException) {
            throw new AssertionError((Object)invalidObjectException);
        }
        catch (OpenDataException openDataException) {
            throw new AssertionError((Object)openDataException);
        }
    }

    public static Map<String, MemoryUsage> cast(Object object) {
        return (Map)object;
    }

    public static Map<String, MemoryUsage> getMemoryUsageAfterGc(CompositeData compositeData) {
        try {
            TabularData tabularData = (TabularData)compositeData.get(MEMORY_USAGE_AFTER_GC);
            return GcInfoCompositeData.cast(memoryUsageMapType.toJavaTypeData(tabularData));
        }
        catch (InvalidObjectException invalidObjectException) {
            throw new AssertionError((Object)invalidObjectException);
        }
        catch (OpenDataException openDataException) {
            throw new AssertionError((Object)openDataException);
        }
    }

    public static void validateCompositeData(CompositeData compositeData) {
        if (compositeData == null) {
            throw new NullPointerException("Null CompositeData");
        }
        if (!GcInfoCompositeData.isTypeMatched(GcInfoCompositeData.getBaseGcInfoCompositeType(), compositeData.getCompositeType())) {
            throw new IllegalArgumentException("Unexpected composite type for GcInfo");
        }
    }

    private static synchronized CompositeType getBaseGcInfoCompositeType() {
        if (baseGcInfoCompositeType == null) {
            try {
                baseGcInfoCompositeType = new CompositeType("sun.management.BaseGcInfoCompositeType", "CompositeType for Base GcInfo", GcInfoCompositeData.getBaseGcInfoItemNames(), GcInfoCompositeData.getBaseGcInfoItemNames(), GcInfoCompositeData.getBaseGcInfoItemTypes());
            }
            catch (OpenDataException openDataException) {
                throw Util.newException(openDataException);
            }
        }
        return baseGcInfoCompositeType;
    }

    static {
        try {
            Method method = GcInfo.class.getMethod("getMemoryUsageBeforeGc", new Class[0]);
            memoryUsageMapType = MappedMXBeanType.getMappedType(method.getGenericReturnType());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new AssertionError((Object)noSuchMethodException);
        }
        catch (OpenDataException openDataException) {
            throw new AssertionError((Object)openDataException);
        }
        baseGcInfoItemTypes = null;
        baseGcInfoCompositeType = null;
    }
}

