/*
 * Decompiled with CFR 0.152.
 */
package sun.management;

import java.lang.management.LockInfo;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import sun.management.LazyCompositeData;
import sun.management.LockDataConverter;
import sun.management.MappedMXBeanType;
import sun.management.MonitorInfoCompositeData;
import sun.management.StackTraceElementCompositeData;

public class ThreadInfoCompositeData
extends LazyCompositeData {
    private final ThreadInfo threadInfo;
    private final CompositeData cdata;
    private final boolean currentVersion;
    private static final String THREAD_ID = "threadId";
    private static final String THREAD_NAME = "threadName";
    private static final String THREAD_STATE = "threadState";
    private static final String BLOCKED_TIME = "blockedTime";
    private static final String BLOCKED_COUNT = "blockedCount";
    private static final String WAITED_TIME = "waitedTime";
    private static final String WAITED_COUNT = "waitedCount";
    private static final String LOCK_INFO = "lockInfo";
    private static final String LOCK_NAME = "lockName";
    private static final String LOCK_OWNER_ID = "lockOwnerId";
    private static final String LOCK_OWNER_NAME = "lockOwnerName";
    private static final String STACK_TRACE = "stackTrace";
    private static final String SUSPENDED = "suspended";
    private static final String IN_NATIVE = "inNative";
    private static final String LOCKED_MONITORS = "lockedMonitors";
    private static final String LOCKED_SYNCS = "lockedSynchronizers";
    private static final String[] threadInfoItemNames;
    private static final String[] threadInfoV6Attributes;
    private static final CompositeType threadInfoCompositeType;
    private static final CompositeType threadInfoV5CompositeType;
    private static final CompositeType lockInfoCompositeType;

    private ThreadInfoCompositeData(ThreadInfo threadInfo) {
        this.threadInfo = threadInfo;
        this.currentVersion = true;
        this.cdata = null;
    }

    private ThreadInfoCompositeData(CompositeData compositeData) {
        this.threadInfo = null;
        this.currentVersion = ThreadInfoCompositeData.isCurrentVersion(compositeData);
        this.cdata = compositeData;
    }

    public ThreadInfo getThreadInfo() {
        return this.threadInfo;
    }

    public boolean isCurrentVersion() {
        return this.currentVersion;
    }

    public static ThreadInfoCompositeData getInstance(CompositeData compositeData) {
        ThreadInfoCompositeData.validateCompositeData(compositeData);
        return new ThreadInfoCompositeData(compositeData);
    }

    public static CompositeData toCompositeData(ThreadInfo threadInfo) {
        ThreadInfoCompositeData threadInfoCompositeData = new ThreadInfoCompositeData(threadInfo);
        return threadInfoCompositeData.getCompositeData();
    }

    protected CompositeData getCompositeData() {
        Object object;
        StackTraceElement[] stackTraceElementArray = this.threadInfo.getStackTrace();
        CompositeData[] compositeDataArray = new CompositeData[stackTraceElementArray.length];
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            object = stackTraceElementArray[i];
            compositeDataArray[i] = StackTraceElementCompositeData.toCompositeData((StackTraceElement)object);
        }
        LockDataConverter lockDataConverter = new LockDataConverter(this.threadInfo);
        object = lockDataConverter.toLockInfoCompositeData();
        CompositeData[] compositeDataArray2 = lockDataConverter.toLockedSynchronizersCompositeData();
        MonitorInfo[] monitorInfoArray = this.threadInfo.getLockedMonitors();
        CompositeData[] compositeDataArray3 = new CompositeData[monitorInfoArray.length];
        for (int i = 0; i < monitorInfoArray.length; ++i) {
            MonitorInfo monitorInfo = monitorInfoArray[i];
            compositeDataArray3[i] = MonitorInfoCompositeData.toCompositeData(monitorInfo);
        }
        Object[] objectArray = new Object[]{new Long(this.threadInfo.getThreadId()), this.threadInfo.getThreadName(), this.threadInfo.getThreadState().name(), new Long(this.threadInfo.getBlockedTime()), new Long(this.threadInfo.getBlockedCount()), new Long(this.threadInfo.getWaitedTime()), new Long(this.threadInfo.getWaitedCount()), object, this.threadInfo.getLockName(), new Long(this.threadInfo.getLockOwnerId()), this.threadInfo.getLockOwnerName(), compositeDataArray, new Boolean(this.threadInfo.isSuspended()), new Boolean(this.threadInfo.isInNative()), compositeDataArray3, compositeDataArray2};
        try {
            return new CompositeDataSupport(threadInfoCompositeType, threadInfoItemNames, objectArray);
        }
        catch (OpenDataException openDataException) {
            throw new AssertionError((Object)openDataException);
        }
    }

    private static boolean isV5Attribute(String string) {
        for (String string2 : threadInfoV6Attributes) {
            if (!string.equals(string2)) continue;
            return false;
        }
        return true;
    }

    public static boolean isCurrentVersion(CompositeData compositeData) {
        if (compositeData == null) {
            throw new NullPointerException("Null CompositeData");
        }
        return ThreadInfoCompositeData.isTypeMatched(threadInfoCompositeType, compositeData.getCompositeType());
    }

    public long threadId() {
        return ThreadInfoCompositeData.getLong(this.cdata, THREAD_ID);
    }

    public String threadName() {
        String string = ThreadInfoCompositeData.getString(this.cdata, THREAD_NAME);
        if (string == null) {
            throw new IllegalArgumentException("Invalid composite data: Attribute threadName has null value");
        }
        return string;
    }

    public Thread.State threadState() {
        return Thread.State.valueOf(ThreadInfoCompositeData.getString(this.cdata, THREAD_STATE));
    }

    public long blockedTime() {
        return ThreadInfoCompositeData.getLong(this.cdata, BLOCKED_TIME);
    }

    public long blockedCount() {
        return ThreadInfoCompositeData.getLong(this.cdata, BLOCKED_COUNT);
    }

    public long waitedTime() {
        return ThreadInfoCompositeData.getLong(this.cdata, WAITED_TIME);
    }

    public long waitedCount() {
        return ThreadInfoCompositeData.getLong(this.cdata, WAITED_COUNT);
    }

    public String lockName() {
        return ThreadInfoCompositeData.getString(this.cdata, LOCK_NAME);
    }

    public long lockOwnerId() {
        return ThreadInfoCompositeData.getLong(this.cdata, LOCK_OWNER_ID);
    }

    public String lockOwnerName() {
        return ThreadInfoCompositeData.getString(this.cdata, LOCK_OWNER_NAME);
    }

    public boolean suspended() {
        return ThreadInfoCompositeData.getBoolean(this.cdata, SUSPENDED);
    }

    public boolean inNative() {
        return ThreadInfoCompositeData.getBoolean(this.cdata, IN_NATIVE);
    }

    public StackTraceElement[] stackTrace() {
        CompositeData[] compositeDataArray = (CompositeData[])this.cdata.get(STACK_TRACE);
        StackTraceElement[] stackTraceElementArray = new StackTraceElement[compositeDataArray.length];
        for (int i = 0; i < compositeDataArray.length; ++i) {
            CompositeData compositeData = compositeDataArray[i];
            stackTraceElementArray[i] = StackTraceElementCompositeData.from(compositeData);
        }
        return stackTraceElementArray;
    }

    public LockInfo lockInfo() {
        LockDataConverter lockDataConverter = new LockDataConverter();
        CompositeData compositeData = (CompositeData)this.cdata.get(LOCK_INFO);
        return lockDataConverter.toLockInfo(compositeData);
    }

    public MonitorInfo[] lockedMonitors() {
        CompositeData[] compositeDataArray = (CompositeData[])this.cdata.get(LOCKED_MONITORS);
        MonitorInfo[] monitorInfoArray = new MonitorInfo[compositeDataArray.length];
        for (int i = 0; i < compositeDataArray.length; ++i) {
            CompositeData compositeData = compositeDataArray[i];
            monitorInfoArray[i] = MonitorInfo.from(compositeData);
        }
        return monitorInfoArray;
    }

    public LockInfo[] lockedSynchronizers() {
        LockDataConverter lockDataConverter = new LockDataConverter();
        CompositeData[] compositeDataArray = (CompositeData[])this.cdata.get(LOCKED_SYNCS);
        return lockDataConverter.toLockedSynchronizers(compositeDataArray);
    }

    public static void validateCompositeData(CompositeData compositeData) {
        CompositeData[] compositeDataArray;
        if (compositeData == null) {
            throw new NullPointerException("Null CompositeData");
        }
        CompositeType compositeType = compositeData.getCompositeType();
        boolean bl = true;
        if (!ThreadInfoCompositeData.isTypeMatched(threadInfoCompositeType, compositeType)) {
            bl = false;
            if (!ThreadInfoCompositeData.isTypeMatched(threadInfoV5CompositeType, compositeType)) {
                throw new IllegalArgumentException("Unexpected composite type for ThreadInfo");
            }
        }
        if ((compositeDataArray = (CompositeData[])compositeData.get(STACK_TRACE)) == null) {
            throw new IllegalArgumentException("StackTraceElement[] is missing");
        }
        if (compositeDataArray.length > 0) {
            StackTraceElementCompositeData.validateCompositeData(compositeDataArray[0]);
        }
        if (bl) {
            CompositeData[] compositeDataArray2;
            CompositeData compositeData2 = (CompositeData)compositeData.get(LOCK_INFO);
            if (compositeData2 != null && !ThreadInfoCompositeData.isTypeMatched(lockInfoCompositeType, compositeData2.getCompositeType())) {
                throw new IllegalArgumentException("Unexpected composite type for \"lockInfo\" attribute.");
            }
            CompositeData[] compositeDataArray3 = (CompositeData[])compositeData.get(LOCKED_MONITORS);
            if (compositeDataArray3 == null) {
                throw new IllegalArgumentException("MonitorInfo[] is null");
            }
            if (compositeDataArray3.length > 0) {
                MonitorInfoCompositeData.validateCompositeData(compositeDataArray3[0]);
            }
            if ((compositeDataArray2 = (CompositeData[])compositeData.get(LOCKED_SYNCS)) == null) {
                throw new IllegalArgumentException("LockInfo[] is null");
            }
            if (compositeDataArray2.length > 0 && !ThreadInfoCompositeData.isTypeMatched(lockInfoCompositeType, compositeDataArray2[0].getCompositeType())) {
                throw new IllegalArgumentException("Unexpected composite type for \"lockedSynchronizers\" attribute.");
            }
        }
    }

    static {
        Object object;
        Object object2;
        threadInfoItemNames = new String[]{THREAD_ID, THREAD_NAME, THREAD_STATE, BLOCKED_TIME, BLOCKED_COUNT, WAITED_TIME, WAITED_COUNT, LOCK_INFO, LOCK_NAME, LOCK_OWNER_ID, LOCK_OWNER_NAME, STACK_TRACE, SUSPENDED, IN_NATIVE, LOCKED_MONITORS, LOCKED_SYNCS};
        threadInfoV6Attributes = new String[]{LOCK_INFO, LOCKED_MONITORS, LOCKED_SYNCS};
        try {
            threadInfoCompositeType = (CompositeType)MappedMXBeanType.toOpenType(ThreadInfo.class);
            object2 = threadInfoCompositeType.keySet().toArray(new String[0]);
            int n = threadInfoItemNames.length - threadInfoV6Attributes.length;
            object = new String[n];
            String[] stringArray = new String[n];
            OpenType[] openTypeArray = new OpenType[n];
            int n2 = 0;
            for (String string : object2) {
                if (!ThreadInfoCompositeData.isV5Attribute(string)) continue;
                object[n2] = string;
                stringArray[n2] = threadInfoCompositeType.getDescription(string);
                openTypeArray[n2] = threadInfoCompositeType.getType(string);
                ++n2;
            }
            threadInfoV5CompositeType = new CompositeType("java.lang.management.ThreadInfo", "J2SE 5.0 java.lang.management.ThreadInfo", (String[])object, stringArray, openTypeArray);
        }
        catch (OpenDataException openDataException) {
            throw new AssertionError((Object)openDataException);
        }
        object2 = new Object();
        LockInfo lockInfo = new LockInfo(object2.getClass().getName(), System.identityHashCode(object2));
        object = LockDataConverter.toLockInfoCompositeData(lockInfo);
        lockInfoCompositeType = object.getCompositeType();
    }
}

