/*
 * Decompiled with CFR 0.152.
 */
package sun.management.jmxremote;

import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.rmi.server.RMIServerSocketFactory;
import java.util.Enumeration;

public final class LocalRMIServerSocketFactory
implements RMIServerSocketFactory {
    public ServerSocket createServerSocket(int n) throws IOException {
        return new ServerSocket(n){

            public Socket accept() throws IOException {
                Enumeration<NetworkInterface> enumeration;
                Socket socket = super.accept();
                InetAddress inetAddress = socket.getInetAddress();
                if (inetAddress == null) {
                    String string = "";
                    if (socket.isClosed()) {
                        string = " Socket is closed.";
                    } else if (!socket.isConnected()) {
                        string = " Socket is not connected";
                    }
                    try {
                        socket.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw new IOException("The server sockets created using the LocalRMIServerSocketFactory only accept connections from clients running on the host where the RMI remote objects have been exported. Couldn't determine client address." + string);
                }
                if (inetAddress.isLoopbackAddress()) {
                    return socket;
                }
                try {
                    enumeration = NetworkInterface.getNetworkInterfaces();
                }
                catch (SocketException socketException) {
                    try {
                        socket.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw new IOException("The server sockets created using the LocalRMIServerSocketFactory only accept connections from clients running on the host where the RMI remote objects have been exported.", socketException);
                }
                while (enumeration.hasMoreElements()) {
                    NetworkInterface networkInterface = enumeration.nextElement();
                    Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
                    while (enumeration2.hasMoreElements()) {
                        InetAddress inetAddress2 = enumeration2.nextElement();
                        if (!inetAddress2.equals(inetAddress)) continue;
                        return socket;
                    }
                }
                try {
                    socket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw new IOException("The server sockets created using the LocalRMIServerSocketFactory only accept connections from clients running on the host where the RMI remote objects have been exported.");
            }
        };
    }

    public boolean equals(Object object) {
        return object instanceof LocalRMIServerSocketFactory;
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }
}

