/*
 * Decompiled with CFR 0.152.
 */
package sun.tracing.dtrace;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import sun.tracing.ProbeSkeleton;
import sun.tracing.dtrace.DTraceProvider;
import sun.tracing.dtrace.JVM;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DTraceProbe
extends ProbeSkeleton {
    private Object proxy;
    private Method declared_method;
    private Method implementing_method;

    DTraceProbe(Object object, Method method) {
        super(method.getParameterTypes());
        this.proxy = object;
        this.declared_method = method;
        try {
            this.implementing_method = object.getClass().getMethod(method.getName(), method.getParameterTypes());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new RuntimeException("Internal error, wrong proxy class");
        }
    }

    @Override
    public boolean isEnabled() {
        return JVM.isEnabled(this.implementing_method);
    }

    @Override
    public void uncheckedTrigger(Object[] objectArray) {
        block4: {
            try {
                this.implementing_method.invoke(this.proxy, objectArray);
            }
            catch (IllegalAccessException illegalAccessException) {
                assert (false);
            }
            catch (InvocationTargetException invocationTargetException) {
                if ($assertionsDisabled) break block4;
                throw new AssertionError();
            }
        }
    }

    String getProbeName() {
        return DTraceProvider.getProbeName(this.declared_method);
    }

    String getFunctionName() {
        return DTraceProvider.getFunctionName(this.declared_method);
    }

    Method getMethod() {
        return this.implementing_method;
    }

    Class<?>[] getParameterTypes() {
        return this.parameters;
    }
}

