/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import java.io.IOException;
import java.math.BigInteger;
import java.security.AlgorithmParametersSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.PBEParameterSpec;
import sun.misc.HexDumpEncoder;
import sun.security.util.Debug;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;

public final class PBEParameters
extends AlgorithmParametersSpi {
    private byte[] salt = null;
    private int iCount = 0;

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        if (!(algorithmParameterSpec instanceof PBEParameterSpec)) {
            throw new InvalidParameterSpecException("Inappropriate parameter specification");
        }
        this.salt = (byte[])((PBEParameterSpec)algorithmParameterSpec).getSalt().clone();
        this.iCount = ((PBEParameterSpec)algorithmParameterSpec).getIterationCount();
    }

    protected void engineInit(byte[] byArray) throws IOException {
        try {
            DerValue derValue = new DerValue(byArray);
            if (derValue.tag != 48) {
                throw new IOException("PBE parameter parsing error: not a sequence");
            }
            derValue.data.reset();
            this.salt = derValue.data.getOctetString();
            this.iCount = derValue.data.getInteger();
            if (derValue.data.available() != 0) {
                throw new IOException("PBE parameter parsing error: extra data");
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException("iteration count too big");
        }
    }

    protected void engineInit(byte[] byArray, String string) throws IOException {
        this.engineInit(byArray);
    }

    protected AlgorithmParameterSpec engineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
        if (PBEParameterSpec.class.isAssignableFrom(clazz)) {
            return new PBEParameterSpec(this.salt, this.iCount);
        }
        throw new InvalidParameterSpecException("Inappropriate parameter specification");
    }

    protected byte[] engineGetEncoded() throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.putOctetString(this.salt);
        derOutputStream2.putInteger(this.iCount);
        derOutputStream.write((byte)48, derOutputStream2);
        return derOutputStream.toByteArray();
    }

    protected byte[] engineGetEncoded(String string) throws IOException {
        return this.engineGetEncoded();
    }

    protected String engineToString() {
        String string = System.getProperty("line.separator");
        String string2 = string + "    salt:" + string + "[";
        HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
        string2 = string2 + hexDumpEncoder.encodeBuffer(this.salt);
        string2 = string2 + "]";
        return string2 + string + "    iterationCount:" + string + Debug.toHexString(BigInteger.valueOf(this.iCount)) + string;
    }
}

