/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.guice.bean.locators;

import com.google.inject.Injector;
import com.google.inject.Key;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.guice.bean.locators.QualifiedBean;
import org.sonatype.guice.bean.locators.QualifiedBeans;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class NotifyingBeans<Q extends Annotation, T>
extends QualifiedBeans<Q, T> {
    private final Runnable notify;

    NotifyingBeans(Key<T> key, Runnable notify) {
        super(key);
        this.notify = notify;
    }

    @Override
    public synchronized List<QualifiedBean<Q, T>> add(Injector injector) {
        return this.sendUpdate(super.add(injector));
    }

    @Override
    public synchronized List<QualifiedBean<Q, T>> remove(Injector injector) {
        return this.sendUpdate(super.remove(injector));
    }

    @Override
    public synchronized List<QualifiedBean<Q, T>> clear() {
        return this.sendUpdate(super.clear());
    }

    private final List<QualifiedBean<Q, T>> sendUpdate(List<QualifiedBean<Q, T>> beans) {
        if (!beans.isEmpty()) {
            try {
                this.notify.run();
            }
            catch (Throwable e) {
                NotifyingBeans.warn("Problem notifying: " + this.notify.getClass(), e);
            }
        }
        return beans;
    }

    private static void warn(String message, Throwable cause) {
        try {
            LoggerFactory.getLogger(NotifyingBeans.class).warn(message, cause);
        }
        catch (Throwable ignore) {
            Logger.getLogger(NotifyingBeans.class.getName()).log(Level.WARNING, message, cause);
        }
    }
}

