# $NetBSD: cond-func-defined.mk,v 1.4 2020/09/27 21:35:16 rillig Exp $
#
# Tests for the defined() function in .if conditions.

DEF=		defined
${:UA B}=	variable name with spaces

.if !defined(DEF)
.error
.endif

# Horizontal whitespace (space tab) after the opening parenthesis is ignored.
.if !defined( 	DEF)
.error
.endif

# Horizontal whitespace (space tab) before the closing parenthesis is ignored.
.if !defined(DEF 	)
.error
.endif

# The argument of a function must not directly contain whitespace.
.if !defined(A B)
.error
.endif

# If necessary, the whitespace can be generated by a variable expression.
.if !defined(${:UA B})
.error
.endif

all:
	@:;
