/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.util;

import com.sun.xml.internal.ws.handler.HandlerChainsModel;
import com.sun.xml.internal.ws.streaming.XMLStreamReaderFactory;
import com.sun.xml.internal.ws.streaming.XMLStreamReaderUtil;
import com.sun.xml.internal.ws.util.HandlerAnnotationInfo;
import com.sun.xml.internal.ws.util.UtilException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.logging.Logger;
import javax.jws.HandlerChain;
import javax.jws.WebService;
import javax.jws.soap.SOAPMessageHandlers;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import javax.xml.ws.Provider;
import javax.xml.ws.Service;

public class HandlerAnnotationProcessor {
    private static final Logger logger = Logger.getLogger("javax.enterprise.resource.webservices.jaxws.util");

    public static HandlerAnnotationInfo buildHandlerInfo(Class clazz, QName qName, QName qName2, String string) {
        HandlerChain handlerChain = clazz.getAnnotation(HandlerChain.class);
        if (handlerChain == null) {
            if ((clazz = HandlerAnnotationProcessor.getSEI(clazz)) != null) {
                handlerChain = clazz.getAnnotation(HandlerChain.class);
            }
            if (handlerChain == null) {
                return null;
            }
        }
        if (clazz.getAnnotation(SOAPMessageHandlers.class) != null) {
            throw new UtilException("util.handler.cannot.combine.soapmessagehandlers", new Object[0]);
        }
        InputStream inputStream = HandlerAnnotationProcessor.getFileAsStream(clazz, handlerChain);
        XMLStreamReader xMLStreamReader = XMLStreamReaderFactory.createXMLStreamReader(inputStream, true);
        XMLStreamReaderUtil.nextElementContent(xMLStreamReader);
        return HandlerChainsModel.parseHandlerFile(xMLStreamReader, clazz.getClassLoader(), qName, qName2, string);
    }

    public static HandlerChainsModel buildHandlerChainsModel(Class clazz) {
        if (clazz == null) {
            return null;
        }
        HandlerChain handlerChain = clazz.getAnnotation(HandlerChain.class);
        if (handlerChain == null) {
            return null;
        }
        InputStream inputStream = HandlerAnnotationProcessor.getFileAsStream(clazz, handlerChain);
        XMLStreamReader xMLStreamReader = XMLStreamReaderFactory.createXMLStreamReader(inputStream, true);
        XMLStreamReaderUtil.nextElementContent(xMLStreamReader);
        return HandlerChainsModel.parseHandlerConfigFile(clazz, xMLStreamReader);
    }

    static Class getClass(String string) {
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new UtilException("util.handler.class.not.found", string);
        }
    }

    static Class getSEI(Class clazz) {
        if (Provider.class.isAssignableFrom(clazz)) {
            return null;
        }
        if (Service.class.isAssignableFrom(clazz)) {
            return null;
        }
        if (!clazz.isAnnotationPresent(WebService.class)) {
            throw new UtilException("util.handler.no.webservice.annotation", clazz.getCanonicalName());
        }
        WebService webService = clazz.getAnnotation(WebService.class);
        String string = webService.endpointInterface();
        if (string.length() > 0) {
            clazz = HandlerAnnotationProcessor.getClass(webService.endpointInterface());
            if (!clazz.isAnnotationPresent(WebService.class)) {
                throw new UtilException("util.handler.endpoint.interface.no.webservice", webService.endpointInterface());
            }
            return clazz;
        }
        return null;
    }

    static InputStream getFileAsStream(Class clazz, HandlerChain handlerChain) {
        URL uRL = clazz.getResource(handlerChain.file());
        if (uRL == null) {
            uRL = Thread.currentThread().getContextClassLoader().getResource(handlerChain.file());
        }
        if (uRL == null) {
            String string = clazz.getPackage().getName();
            string = string.replace('.', '/');
            string = string + "/" + handlerChain.file();
            uRL = Thread.currentThread().getContextClassLoader().getResource(string);
        }
        if (uRL == null) {
            throw new UtilException("util.failed.to.find.handlerchain.file", clazz.getName(), handlerChain.file());
        }
        try {
            return uRL.openStream();
        }
        catch (IOException iOException) {
            throw new UtilException("util.failed.to.parse.handlerchain.file", clazz.getName(), handlerChain.file());
        }
    }
}

