/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.image;

import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import sun.awt.image.GifImageDecoder;
import sun.awt.image.ImageConsumerQueue;
import sun.awt.image.ImageDecoder;
import sun.awt.image.ImageFetchable;
import sun.awt.image.ImageFetcher;
import sun.awt.image.ImageFormatException;
import sun.awt.image.ImageRepresentation;
import sun.awt.image.JPEGImageDecoder;
import sun.awt.image.PNGImageDecoder;
import sun.awt.image.XbmImageDecoder;

public abstract class InputStreamImageSource
implements ImageProducer,
ImageFetchable {
    ImageConsumerQueue consumers;
    ImageDecoder decoder;
    ImageDecoder decoders;
    boolean awaitingFetch = false;

    abstract boolean checkSecurity(Object var1, boolean var2);

    int countConsumers(ImageConsumerQueue imageConsumerQueue) {
        int n = 0;
        while (imageConsumerQueue != null) {
            ++n;
            imageConsumerQueue = imageConsumerQueue.next;
        }
        return n;
    }

    synchronized int countConsumers() {
        ImageDecoder imageDecoder = this.decoders;
        int n = this.countConsumers(this.consumers);
        while (imageDecoder != null) {
            n += this.countConsumers(imageDecoder.queue);
            imageDecoder = imageDecoder.next;
        }
        return n;
    }

    public void addConsumer(ImageConsumer imageConsumer) {
        this.addConsumer(imageConsumer, false);
    }

    synchronized void printQueue(ImageConsumerQueue imageConsumerQueue, String string) {
        while (imageConsumerQueue != null) {
            System.out.println(string + imageConsumerQueue);
            imageConsumerQueue = imageConsumerQueue.next;
        }
    }

    synchronized void printQueues(String string) {
        System.out.println(string + "[ -----------");
        this.printQueue(this.consumers, "  ");
        ImageDecoder imageDecoder = this.decoders;
        while (imageDecoder != null) {
            System.out.println("    " + imageDecoder);
            this.printQueue(imageDecoder.queue, "      ");
            imageDecoder = imageDecoder.next;
        }
        System.out.println("----------- ]" + string);
    }

    synchronized void addConsumer(ImageConsumer imageConsumer, boolean bl) {
        this.checkSecurity(null, false);
        Object object = this.decoders;
        while (object != null) {
            if (((ImageDecoder)object).isConsumer(imageConsumer)) {
                return;
            }
            object = ((ImageDecoder)object).next;
        }
        object = this.consumers;
        while (object != null && ((ImageConsumerQueue)object).consumer != imageConsumer) {
            object = ((ImageConsumerQueue)object).next;
        }
        if (object == null) {
            object = new ImageConsumerQueue(this, imageConsumer);
            ((ImageConsumerQueue)object).next = this.consumers;
            this.consumers = object;
        } else {
            if (!((ImageConsumerQueue)object).secure) {
                Object object2 = null;
                SecurityManager securityManager = System.getSecurityManager();
                if (securityManager != null) {
                    object2 = securityManager.getSecurityContext();
                }
                if (((ImageConsumerQueue)object).securityContext == null) {
                    ((ImageConsumerQueue)object).securityContext = object2;
                } else if (!((ImageConsumerQueue)object).securityContext.equals(object2)) {
                    this.errorConsumer((ImageConsumerQueue)object, false);
                    throw new SecurityException("Applets are trading image data!");
                }
            }
            ((ImageConsumerQueue)object).interested = true;
        }
        if (bl && this.decoder == null) {
            this.startProduction();
        }
    }

    public synchronized boolean isConsumer(ImageConsumer imageConsumer) {
        ImageDecoder imageDecoder = this.decoders;
        while (imageDecoder != null) {
            if (imageDecoder.isConsumer(imageConsumer)) {
                return true;
            }
            imageDecoder = imageDecoder.next;
        }
        return ImageConsumerQueue.isConsumer(this.consumers, imageConsumer);
    }

    private void errorAllConsumers(ImageConsumerQueue imageConsumerQueue, boolean bl) {
        while (imageConsumerQueue != null) {
            if (imageConsumerQueue.interested) {
                this.errorConsumer(imageConsumerQueue, bl);
            }
            imageConsumerQueue = imageConsumerQueue.next;
        }
    }

    private void errorConsumer(ImageConsumerQueue imageConsumerQueue, boolean bl) {
        imageConsumerQueue.consumer.imageComplete(1);
        if (bl && imageConsumerQueue.consumer instanceof ImageRepresentation) {
            ((ImageRepresentation)imageConsumerQueue.consumer).image.flush();
        }
        this.removeConsumer(imageConsumerQueue.consumer);
    }

    public synchronized void removeConsumer(ImageConsumer imageConsumer) {
        ImageDecoder imageDecoder = this.decoders;
        while (imageDecoder != null) {
            imageDecoder.removeConsumer(imageConsumer);
            imageDecoder = imageDecoder.next;
        }
        this.consumers = ImageConsumerQueue.removeConsumer(this.consumers, imageConsumer, false);
    }

    public void startProduction(ImageConsumer imageConsumer) {
        this.addConsumer(imageConsumer, true);
    }

    private synchronized void startProduction() {
        if (!this.awaitingFetch) {
            ImageFetcher.add(this);
            this.awaitingFetch = true;
        }
    }

    private synchronized void stopProduction() {
        if (this.awaitingFetch) {
            ImageFetcher.remove(this);
            this.awaitingFetch = false;
        }
    }

    public void requestTopDownLeftRightResend(ImageConsumer imageConsumer) {
    }

    protected abstract ImageDecoder getDecoder();

    protected ImageDecoder decoderForType(InputStream inputStream, String string) {
        return null;
    }

    protected ImageDecoder getDecoder(InputStream inputStream) {
        if (!inputStream.markSupported()) {
            inputStream = new BufferedInputStream(inputStream);
        }
        try {
            inputStream.mark(8);
            int n = inputStream.read();
            int n2 = inputStream.read();
            int n3 = inputStream.read();
            int n4 = inputStream.read();
            int n5 = inputStream.read();
            int n6 = inputStream.read();
            int n7 = inputStream.read();
            int n8 = inputStream.read();
            inputStream.reset();
            inputStream.mark(-1);
            if (n == 71 && n2 == 73 && n3 == 70 && n4 == 56) {
                return new GifImageDecoder(this, inputStream);
            }
            if (n == 255 && n2 == 216 && n3 == 255) {
                return new JPEGImageDecoder(this, inputStream);
            }
            if (n == 35 && n2 == 100 && n3 == 101 && n4 == 102) {
                return new XbmImageDecoder(this, inputStream);
            }
            if (n == 137 && n2 == 80 && n3 == 78 && n4 == 71 && n5 == 13 && n6 == 10 && n7 == 26 && n8 == 10) {
                return new PNGImageDecoder(this, inputStream);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFetch() {
        block19: {
            Object object = this;
            synchronized (object) {
                if (this.consumers == null) {
                    this.awaitingFetch = false;
                    return;
                }
            }
            object = this.getDecoder();
            if (object == null) {
                this.badDecoder();
            } else {
                this.setDecoder((ImageDecoder)object);
                try {
                    try {
                        ((ImageDecoder)object).produceImage();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                        Object var4_6 = null;
                        this.removeDecoder((ImageDecoder)object);
                        if (Thread.currentThread().isInterrupted() || !Thread.currentThread().isAlive()) {
                            this.errorAllConsumers(((ImageDecoder)object).queue, true);
                        } else {
                            this.errorAllConsumers(((ImageDecoder)object).queue, false);
                        }
                        break block19;
                    }
                    catch (ImageFormatException imageFormatException) {
                        imageFormatException.printStackTrace();
                        Object var4_7 = null;
                        this.removeDecoder((ImageDecoder)object);
                        if (Thread.currentThread().isInterrupted() || !Thread.currentThread().isAlive()) {
                            this.errorAllConsumers(((ImageDecoder)object).queue, true);
                        } else {
                            this.errorAllConsumers(((ImageDecoder)object).queue, false);
                        }
                    }
                    Object var4_5 = null;
                    this.removeDecoder((ImageDecoder)object);
                    if (Thread.currentThread().isInterrupted() || !Thread.currentThread().isAlive()) {
                        this.errorAllConsumers(((ImageDecoder)object).queue, true);
                    } else {
                        this.errorAllConsumers(((ImageDecoder)object).queue, false);
                    }
                }
                catch (Throwable throwable) {
                    Object var4_8 = null;
                    this.removeDecoder((ImageDecoder)object);
                    if (Thread.currentThread().isInterrupted() || !Thread.currentThread().isAlive()) {
                        this.errorAllConsumers(((ImageDecoder)object).queue, true);
                    } else {
                        this.errorAllConsumers(((ImageDecoder)object).queue, false);
                    }
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void badDecoder() {
        ImageConsumerQueue imageConsumerQueue;
        InputStreamImageSource inputStreamImageSource = this;
        synchronized (inputStreamImageSource) {
            imageConsumerQueue = this.consumers;
            this.consumers = null;
            this.awaitingFetch = false;
        }
        this.errorAllConsumers(imageConsumerQueue, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDecoder(ImageDecoder imageDecoder) {
        ImageConsumerQueue imageConsumerQueue;
        InputStreamImageSource inputStreamImageSource = this;
        synchronized (inputStreamImageSource) {
            imageDecoder.next = this.decoders;
            this.decoders = imageDecoder;
            this.decoder = imageDecoder;
            imageDecoder.queue = imageConsumerQueue = this.consumers;
            this.consumers = null;
            this.awaitingFetch = false;
        }
        while (imageConsumerQueue != null) {
            if (imageConsumerQueue.interested && !this.checkSecurity(imageConsumerQueue.securityContext, true)) {
                this.errorConsumer(imageConsumerQueue, false);
            }
            imageConsumerQueue = imageConsumerQueue.next;
        }
    }

    private synchronized void removeDecoder(ImageDecoder imageDecoder) {
        this.doneDecoding(imageDecoder);
        ImageDecoder imageDecoder2 = null;
        ImageDecoder imageDecoder3 = this.decoders;
        while (imageDecoder3 != null) {
            if (imageDecoder3 == imageDecoder) {
                if (imageDecoder2 == null) {
                    this.decoders = imageDecoder3.next;
                    break;
                }
                imageDecoder2.next = imageDecoder3.next;
                break;
            }
            imageDecoder2 = imageDecoder3;
            imageDecoder3 = imageDecoder3.next;
        }
    }

    synchronized void doneDecoding(ImageDecoder imageDecoder) {
        if (this.decoder == imageDecoder) {
            this.decoder = null;
            if (this.consumers != null) {
                this.startProduction();
            }
        }
    }

    void latchConsumers(ImageDecoder imageDecoder) {
        this.doneDecoding(imageDecoder);
    }

    synchronized void flush() {
        this.decoder = null;
    }
}

