/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.shell;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.stream.Collectors;
import org.apache.accumulo.core.util.Pair;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.hadoop.io.Text;

public class ShellUtil {
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="app is run in same security context as user providing the filename")
    public static List<Text> scanFile(String filename, boolean decode) throws IOException {
        ArrayList<Text> result = new ArrayList<Text>();
        try (Scanner file = new Scanner(new File(filename), StandardCharsets.UTF_8);){
            while (file.hasNextLine()) {
                String line = file.nextLine();
                if (line.isEmpty()) continue;
                result.add(decode ? new Text(Base64.getDecoder().decode(line)) : new Text(line));
            }
        }
        return result;
    }

    public static Map<String, String> parseMapOpt(CommandLine cl, Option opt) {
        if (cl.hasOption(opt.getLongOpt())) {
            return Arrays.stream(cl.getOptionValue(opt.getLongOpt()).split(",")).map(kv -> {
                String[] sa = kv.split("=");
                return new Pair((Object)sa[0], (Object)sa[1]);
            }).collect(Collectors.toUnmodifiableMap(Pair::getFirst, Pair::getSecond));
        }
        return Collections.emptyMap();
    }
}

