/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.shell.commands;

import java.io.IOException;
import org.apache.accumulo.core.trace.TraceUtil;
import org.apache.accumulo.core.util.BadArgumentException;
import org.apache.accumulo.shell.Shell;
import org.apache.commons.cli.CommandLine;

public class TraceCommand
extends Shell.Command {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int execute(String fullCommand, CommandLine cl, Shell shellState) throws IOException {
        if (cl.getArgs().length == 1) {
            if (cl.getArgs()[0].equalsIgnoreCase("on")) {
                TraceUtil.setProcessTracing((boolean)true);
                return 0;
            } else {
                if (!cl.getArgs()[0].equalsIgnoreCase("off")) throw new BadArgumentException("Argument must be 'on' or 'off'", fullCommand, fullCommand.indexOf(cl.getArgs()[0]));
                TraceUtil.setProcessTracing((boolean)false);
            }
            return 0;
        } else if (cl.getArgs().length == 0) {
            shellState.getWriter().println(TraceUtil.getProcessTracing() ? "on" : "off");
            return 0;
        } else {
            shellState.printException(new IllegalArgumentException("Expected 0 or 1 argument. There were " + cl.getArgs().length + "."));
            this.printHelp(shellState);
            return 1;
        }
    }

    @Override
    public String description() {
        return "turns tracing on or off";
    }

    @Override
    public String usage() {
        return this.getName() + " [ on | off ]";
    }

    @Override
    public int numArgs() {
        return -1;
    }
}

