/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.clientImpl;

import java.io.DataInput;
import java.io.DataOutput;
import java.util.Map;
import org.apache.accumulo.core.client.admin.CompactionConfig;
import org.apache.accumulo.core.client.admin.CompactionStrategyConfig;
import org.apache.accumulo.core.clientImpl.UserCompactionUtils;

public class CompactionStrategyConfigUtil {
    public static final CompactionStrategyConfig DEFAULT_STRATEGY = new CompactionStrategyConfig(""){

        @Override
        public CompactionStrategyConfig setOptions(Map<String, String> opts) {
            throw new UnsupportedOperationException();
        }
    };
    private static final int MAGIC = -866230236;

    public static void encode(DataOutput dout, CompactionConfig cc) {
        CompactionStrategyConfig cs = cc.getCompactionStrategy();
        UserCompactionUtils.encode(dout, -866230236, 1, cs.getClassName(), cs.getOptions());
    }

    public static void decode(CompactionConfig cc, DataInput din) {
        UserCompactionUtils.PluginConfigData pcd = UserCompactionUtils.decode(din, -866230236, 1);
        CompactionStrategyConfig csc = new CompactionStrategyConfig(pcd.className).setOptions(pcd.opts);
        if (!CompactionStrategyConfigUtil.isDefault(csc)) {
            cc.setCompactionStrategy(csc);
        }
    }

    public static boolean isDefault(CompactionStrategyConfig compactionStrategy) {
        return compactionStrategy.equals(DEFAULT_STRATEGY);
    }

    public static boolean isDefault(CompactionConfig compactionConfig) {
        return CompactionStrategyConfigUtil.isDefault(compactionConfig.getCompactionStrategy());
    }
}

