/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.conf;

import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.TreeMap;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.conf.PropertyType;

public class ConfigurationDocGen {
    private final PrintStream doc;
    private final TreeMap<String, Property> sortedProps = new TreeMap();

    void generate() {
        this.pageHeader();
        this.beginTable("Property");
        for (Property prop : this.sortedProps.values()) {
            if (prop.getType() == PropertyType.PREFIX) {
                this.prefixSection(prop);
                continue;
            }
            this.property(prop);
        }
        this.beginSection("Property Types");
        this.beginTable("Type");
        this.propertyTypeDescriptions();
        this.doc.close();
    }

    void beginSection(String section) {
        this.doc.println("\n### " + section + "\n");
    }

    void beginTable(String name) {
        this.doc.println("| " + name + " | Description |");
        this.doc.println("|--------------|-------------|");
    }

    void pageHeader() {
        this.doc.println("---");
        this.doc.println("title: Server Properties (2.x)");
        this.doc.println("category: configuration");
        this.doc.println("order: 5");
        this.doc.println("---\n");
        this.doc.println("<!-- WARNING: Do not edit this file. It is a generated file that is copied from Accumulo build (from core/target/generated-docs) -->\n");
        this.doc.println("Below are properties set in `accumulo.properties` or the Accumulo shell that configure Accumulo servers (i.e. tablet server, manager, etc). Properties labeled 'Experimental' should not be considered stable and have a higher risk of changing in the future.\n");
    }

    void prefixSection(Property prefix) {
        boolean depr = prefix.isDeprecated();
        String key = this.strike("<a name=\"" + prefix.getKey().replace(".", "_") + "prefix\" class=\"prop\"></a> **" + prefix.getKey() + "***", depr);
        Object description = prefix.isExperimental() ? "**Experimental**<br>" : "";
        description = (String)description + "**Available since:** " + prefix.availableSince() + "<br>";
        if (depr) {
            description = (String)description + "*Deprecated since:* " + prefix.deprecatedSince() + "<br>";
            if (prefix.isReplaced()) {
                description = (String)description + "*Replaced by:* <a href=\"#" + prefix.replacedBy().getKey().replace(".", "_") + "prefix\">" + String.valueOf((Object)prefix.replacedBy()) + "</a><br>";
            }
        }
        description = (String)description + this.strike(this.sanitize(prefix.getDescription()), depr);
        this.doc.println("| " + key + " | " + (String)description + " |");
    }

    void property(Property prop) {
        boolean depr = prop.isDeprecated();
        String key = this.strike("<a name=\"" + prop.getKey().replace(".", "_") + "\" class=\"prop\"></a> " + prop.getKey(), depr);
        Object description = prop.isExperimental() ? "**Experimental**<br>" : "";
        description = (String)description + "**Available since:** ";
        description = prop.getKey().startsWith("manager.") && (prop.availableSince().startsWith("1.") || prop.availableSince().startsWith("2.0")) ? (String)description + "2.1.0 (since " + prop.availableSince() + " as *master." + prop.getKey().substring(8) + "*)<br>" : (String)description + prop.availableSince() + "<br>";
        if (depr) {
            description = (String)description + "*Deprecated since:* " + prop.deprecatedSince() + "<br>";
            if (prop.isReplaced()) {
                description = (String)description + "*Replaced by:* <a href=\"#" + prop.replacedBy().getKey().replace(".", "_") + "\">" + String.valueOf((Object)prop.replacedBy()) + "</a><br>";
            }
        }
        description = (String)description + this.strike(this.sanitize(prop.getDescription()), depr) + "<br>" + this.strike("**type:** " + prop.getType().name(), depr) + ", " + this.strike("**zk mutable:** " + this.isZooKeeperMutable(prop), depr) + ", ";
        String defaultValue = this.sanitize(prop.getDefaultValue()).trim();
        description = defaultValue.isEmpty() ? (String)description + this.strike("**default value:** empty", depr) : (defaultValue.contains("\n") ? (String)description + this.strike("**default value:** ", depr) + "\n```\n" + defaultValue + "\n```\n" : (prop.getType() == PropertyType.CLASSNAME && defaultValue.startsWith("org.apache.accumulo") ? (String)description + this.strike("**default value:** {% jlink -f " + defaultValue + " %}", depr) : (String)description + this.strike("**default value:** `" + defaultValue + "`", depr)));
        this.doc.println("| " + key + " | " + (String)description + " |");
    }

    private String strike(String s, boolean isDeprecated) {
        return (isDeprecated ? "~~" : "") + s + (isDeprecated ? "~~" : "");
    }

    void propertyTypeDescriptions() {
        for (PropertyType type : PropertyType.values()) {
            if (type == PropertyType.PREFIX) continue;
            this.doc.println("| " + this.sanitize(type.toString()) + " | " + this.sanitize(type.getFormatDescription()) + " |");
        }
    }

    String sanitize(String str) {
        return str.replace("\n", "<br>");
    }

    private ConfigurationDocGen(PrintStream doc) {
        this.doc = doc;
        for (Property prop : Property.values()) {
            this.sortedProps.put(prop.getKey(), prop);
        }
    }

    private String isZooKeeperMutable(Property prop) {
        if (!Property.isValidZooPropertyKey(prop.getKey())) {
            return "no";
        }
        if (Property.isFixedZooPropertyKey(prop)) {
            return "yes but requires restart of the " + prop.getKey().split("[.]")[0];
        }
        return "yes";
    }

    public static void main(String[] args) throws IOException {
        if (args.length == 2 && args[0].equals("--generate-markdown")) {
            try (PrintStream printStream = new PrintStream(args[1], StandardCharsets.UTF_8);){
                new ConfigurationDocGen(printStream).generate();
            }
        } else {
            throw new IllegalArgumentException("Usage: " + ConfigurationDocGen.class.getName() + " --generate-markdown <filename>");
        }
    }
}

