/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.sample.impl;

import java.io.IOException;
import org.apache.accumulo.core.classloader.ClassLoaderUtil;
import org.apache.accumulo.core.client.sample.Sampler;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.sample.impl.SamplerConfigurationImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamplerFactory {
    private static final Logger log = LoggerFactory.getLogger(SamplerFactory.class);

    public static Sampler newSampler(SamplerConfigurationImpl config, AccumuloConfiguration acuconf, boolean useAccumuloStart) {
        String context = ClassLoaderUtil.tableContext(acuconf);
        try {
            Class<Sampler> clazz = !useAccumuloStart ? SamplerFactory.class.getClassLoader().loadClass(config.getClassName()).asSubclass(Sampler.class) : ClassLoaderUtil.loadClass(context, config.getClassName(), Sampler.class);
            Sampler sampler = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            sampler.validateOptions(config.getOptions());
            sampler.init(config.toSamplerConfiguration());
            return sampler;
        }
        catch (ReflectiveOperationException | RuntimeException e) {
            log.error("Cannot initialize sampler {}: {}", new Object[]{config.getClassName(), e.getMessage(), e});
            return null;
        }
    }

    public static Sampler newSampler(SamplerConfigurationImpl config, AccumuloConfiguration acuconf) throws IOException {
        return SamplerFactory.newSampler(config, acuconf, true);
    }
}

