/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.spi.compaction;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import org.apache.accumulo.core.spi.compaction.CompactionDispatch;
import org.apache.accumulo.core.spi.compaction.CompactionDispatcher;
import org.apache.accumulo.core.spi.compaction.CompactionKind;

public class SimpleCompactionDispatcher
implements CompactionDispatcher {
    private Map<CompactionKind, CompactionDispatch> services;
    private Map<String, CompactionDispatch> userServices;

    @Override
    public void init(CompactionDispatcher.InitParameters params) {
        this.services = new EnumMap<CompactionKind, CompactionDispatch>(CompactionKind.class);
        CompactionDispatch defaultService = CompactionDispatch.builder().toService("default").build();
        if (params.getOptions().containsKey("service")) {
            defaultService = CompactionDispatch.builder().toService(params.getOptions().get("service")).build();
        }
        for (CompactionKind ctype : CompactionKind.values()) {
            String service = params.getOptions().get("service." + ctype.name().toLowerCase());
            if (service == null) {
                this.services.put(ctype, defaultService);
                continue;
            }
            this.services.put(ctype, CompactionDispatch.builder().toService(service).build());
        }
        if (params.getOptions().isEmpty()) {
            this.userServices = Map.of();
        } else {
            HashMap tmpUS = new HashMap();
            params.getOptions().forEach((k, v) -> {
                if (k.startsWith("service.user.")) {
                    String type = k.substring("service.user.".length());
                    tmpUS.put(type, CompactionDispatch.builder().toService((String)v).build());
                }
            });
            this.userServices = Map.copyOf(tmpUS);
        }
    }

    @Override
    public CompactionDispatch dispatch(CompactionDispatcher.DispatchParameters params) {
        CompactionDispatch userDispatch;
        String hintType;
        if (params.getCompactionKind() == CompactionKind.USER && (hintType = params.getExecutionHints().get("compaction_type")) != null && (userDispatch = this.userServices.get(hintType)) != null) {
            return userDispatch;
        }
        return this.services.get((Object)params.getCompactionKind());
    }
}

