/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util;

import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.core.util.threads.Threads;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Halt {
    private static final Logger log = LoggerFactory.getLogger(Halt.class);

    public static void halt(int status, String msg) {
        Halt.halt(status, msg, null, null);
    }

    public static void halt(int status, String msg, Throwable exception) {
        Halt.halt(status, msg, exception, null);
    }

    public static void halt(int status, String msg, Runnable runnable) {
        Halt.halt(status, msg, null, runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void halt(int status, String msg, Throwable exception, Runnable runnable) {
        try {
            Threads.createNonCriticalThread("Halt Thread", () -> {
                UtilWaitThread.sleepUninterruptibly(100L, TimeUnit.MILLISECONDS);
                Runtime.getRuntime().halt(status);
            }).start();
            String errorMessage = "FATAL " + msg;
            System.err.println(errorMessage);
            if (exception != null) {
                exception.printStackTrace();
            }
            System.err.flush();
            if (exception != null) {
                log.error("{}", (Object)errorMessage, (Object)exception);
            } else {
                log.error("{}", (Object)errorMessage);
            }
            if (runnable != null) {
                runnable.run();
            }
            Runtime.getRuntime().halt(status);
        }
        finally {
            Runtime.getRuntime().halt(-1);
        }
    }
}

