/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util;

import java.util.EnumMap;

public class StopWatch<K extends Enum<K>> {
    EnumMap<K, Long> startTime;
    EnumMap<K, Long> totalTime;

    public StopWatch(Class<K> k) {
        this.startTime = new EnumMap(k);
        this.totalTime = new EnumMap(k);
    }

    public synchronized void start(K timer) {
        if (this.startTime.containsKey(timer)) {
            throw new IllegalStateException(String.valueOf(timer) + " already started");
        }
        this.startTime.put(timer, System.currentTimeMillis());
    }

    public synchronized void stop(K timer) {
        Long st = this.startTime.get(timer);
        if (st == null) {
            throw new IllegalStateException(String.valueOf(timer) + " not started");
        }
        Long existingTime = this.totalTime.get(timer);
        if (existingTime == null) {
            existingTime = 0L;
        }
        this.totalTime.put(timer, existingTime + (System.currentTimeMillis() - st));
        this.startTime.remove(timer);
    }

    public synchronized long get(K timer) {
        Long existingTime = this.totalTime.get(timer);
        if (existingTime == null) {
            existingTime = 0L;
        }
        return existingTime;
    }

    public synchronized double getSecs(K timer) {
        Long existingTime = this.totalTime.get(timer);
        if (existingTime == null) {
            existingTime = 0L;
        }
        return (double)existingTime.longValue() / 1000.0;
    }
}

