/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.gc;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Scope;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.IntStream;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.fate.zookeeper.ServiceLock;
import org.apache.accumulo.core.fate.zookeeper.ServiceLockSupport;
import org.apache.accumulo.core.gc.thrift.GCMonitorService;
import org.apache.accumulo.core.gc.thrift.GCStatus;
import org.apache.accumulo.core.gc.thrift.GcCycleStats;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.metadata.RootTable;
import org.apache.accumulo.core.metadata.schema.Ample;
import org.apache.accumulo.core.metrics.MetricsInfo;
import org.apache.accumulo.core.metrics.MetricsProducer;
import org.apache.accumulo.core.process.thrift.ServerProcessService;
import org.apache.accumulo.core.rpc.SslConnectionParams;
import org.apache.accumulo.core.securityImpl.thrift.TCredentials;
import org.apache.accumulo.core.trace.TraceUtil;
import org.apache.accumulo.core.trace.thrift.TInfo;
import org.apache.accumulo.core.util.HostAndPort;
import org.apache.accumulo.core.util.ServerServices;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.core.util.threads.ThreadPools;
import org.apache.accumulo.gc.GCRun;
import org.apache.accumulo.gc.GarbageCollectWriteAheadLogs;
import org.apache.accumulo.gc.GarbageCollectionAlgorithm;
import org.apache.accumulo.gc.GarbageCollectionEnvironment;
import org.apache.accumulo.gc.metrics.GcCycleMetrics;
import org.apache.accumulo.gc.metrics.GcMetrics;
import org.apache.accumulo.gc.replication.CloseWriteAheadLogReferences;
import org.apache.accumulo.server.AbstractServer;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.ServerOpts;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.accumulo.server.manager.LiveTServerSet;
import org.apache.accumulo.server.rpc.SaslServerConnectionParams;
import org.apache.accumulo.server.rpc.ServerAddress;
import org.apache.accumulo.server.rpc.TServerUtils;
import org.apache.accumulo.server.rpc.ThriftProcessorTypes;
import org.apache.accumulo.server.rpc.ThriftServerType;
import org.apache.hadoop.fs.Path;
import org.apache.thrift.TMultiplexedProcessor;
import org.apache.thrift.TProcessor;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleGarbageCollector
extends AbstractServer
implements GCMonitorService.Iface,
ServerProcessService.Iface {
    private static final Logger log = LoggerFactory.getLogger(SimpleGarbageCollector.class);
    private final GCStatus status = new GCStatus(new GcCycleStats(), new GcCycleStats(), new GcCycleStats(), new GcCycleStats());
    private final GcCycleMetrics gcCycleMetrics = new GcCycleMetrics();
    private ServiceLock gcLock;

    SimpleGarbageCollector(ServerOpts opts, String[] args) {
        super("gc", opts, args);
        AccumuloConfiguration conf = this.getConfiguration();
        long gcDelay = conf.getTimeInMillis(Property.GC_CYCLE_DELAY);
        String useFullCompaction = conf.get(Property.GC_USE_FULL_COMPACTION);
        log.info("start delay: {} milliseconds", (Object)this.getStartDelay());
        log.info("time delay: {} milliseconds", (Object)gcDelay);
        log.info("safemode: {}", (Object)this.inSafeMode());
        log.info("candidate batch size: {} bytes", (Object)this.getCandidateBatchSize());
        log.info("delete threads: {}", (Object)this.getNumDeleteThreads());
        log.info("gc post metadata action: {}", (Object)useFullCompaction);
    }

    public static void main(String[] args) throws Exception {
        try (SimpleGarbageCollector gc = new SimpleGarbageCollector(new ServerOpts(), args);){
            gc.runServer();
        }
    }

    long getStartDelay() {
        return this.getConfiguration().getTimeInMillis(Property.GC_CYCLE_START);
    }

    boolean isUsingTrash() {
        Property p = Property.GC_TRASH_IGNORE;
        return !this.getConfiguration().getBoolean(p);
    }

    int getNumDeleteThreads() {
        return this.getConfiguration().getCount(Property.GC_DELETE_THREADS);
    }

    long getCandidateBatchSize() {
        return this.getConfiguration().getAsBytes(Property.GC_CANDIDATE_BATCH_SIZE);
    }

    boolean inSafeMode() {
        return this.getConfiguration().getBoolean(Property.GC_SAFEMODE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"DM_EXIT"}, justification="main class can call System.exit")
    public void run() {
        try {
            this.waitForUpgrade();
        }
        catch (InterruptedException e) {
            LOG.error("Interrupted while waiting for upgrade to complete, exiting...");
            System.exit(1);
        }
        VolumeManager fs = this.getContext().getVolumeManager();
        log.info("Trying to acquire ZooKeeper lock for garbage collector");
        HostAndPort address = this.startStatsService();
        this.updateAdvertiseAddress(address);
        try {
            this.getZooLock(this.getAdvertiseAddress());
        }
        catch (Exception ex) {
            log.error("{}", (Object)ex.getMessage(), (Object)ex);
            System.exit(1);
        }
        MetricsInfo metricsInfo = this.getContext().getMetricsInfo();
        metricsInfo.addMetricsProducers(new MetricsProducer[]{new GcMetrics(this)});
        metricsInfo.init(MetricsInfo.serviceTags((String)this.getContext().getInstanceName(), (String)this.getApplicationName(), (HostAndPort)address, (String)""));
        try {
            long delay = this.getStartDelay();
            log.debug("Sleeping for {} milliseconds before beginning garbage collection cycles", (Object)delay);
            Thread.sleep(delay);
        }
        catch (InterruptedException e) {
            log.warn("{}", (Object)e.getMessage(), (Object)e);
            return;
        }
        LiveTServerSet liveTServerSet = new LiveTServerSet(this.getContext(), (current, deleted, added) -> {
            log.debug("Number of current servers {}, tservers added {}, removed {}", new Object[]{current == null ? -1 : current.size(), added, deleted});
            if (log.isTraceEnabled()) {
                log.trace("Current servers: {}\nAdded: {}\n Removed: {}", new Object[]{current, added, deleted});
            }
        });
        while (!this.isShutdownRequested()) {
            if (Thread.currentThread().isInterrupted()) {
                LOG.info("Server process thread has been interrupted, shutting down");
                break;
            }
            try {
                Span outerSpan = TraceUtil.startSpan(((Object)((Object)this)).getClass(), (String)"gc");
                try (Scope outerScope = outerSpan.makeCurrent();){
                    Span innerSpan = TraceUtil.startSpan(((Object)((Object)this)).getClass(), (String)"loop");
                    try (Scope innerScope = innerSpan.makeCurrent();){
                        long tStart = System.nanoTime();
                        try {
                            System.gc();
                            this.status.current.started = System.currentTimeMillis();
                            GCRun rootGC = new GCRun(Ample.DataLevel.ROOT, this.getContext());
                            Object mdGC = new GCRun(Ample.DataLevel.METADATA, this.getContext());
                            GCRun userGC = new GCRun(Ample.DataLevel.USER, this.getContext());
                            log.info("Starting Root table Garbage Collection.");
                            this.status.current.bulks += new GarbageCollectionAlgorithm().collect(rootGC);
                            this.incrementStatsForRun(rootGC);
                            this.logStats();
                            log.info("Starting Metadata table Garbage Collection.");
                            this.status.current.bulks += new GarbageCollectionAlgorithm().collect((GarbageCollectionEnvironment)mdGC);
                            this.incrementStatsForRun((GCRun)mdGC);
                            this.logStats();
                            log.info("Starting User table Garbage Collection.");
                            this.status.current.bulks += new GarbageCollectionAlgorithm().collect(userGC);
                            this.incrementStatsForRun(userGC);
                            this.logStats();
                        }
                        catch (Exception e) {
                            TraceUtil.setException((Span)innerSpan, (Throwable)e, (boolean)false);
                            log.error("{}", (Object)e.getMessage(), (Object)e);
                        }
                        finally {
                            this.status.current.finished = System.currentTimeMillis();
                            this.status.last = this.status.current;
                            this.gcCycleMetrics.setLastCollect(this.status.current);
                            this.status.current = new GcCycleStats();
                        }
                        long tStop = System.nanoTime();
                        log.info(String.format("Collect cycle took %.2f seconds", (double)TimeUnit.NANOSECONDS.toMillis(tStop - tStart) / 1000.0));
                        Span replSpan = TraceUtil.startSpan(((Object)((Object)this)).getClass(), (String)"replicationClose");
                        try (Scope replScope = replSpan.makeCurrent();){
                            CloseWriteAheadLogReferences closeWals = new CloseWriteAheadLogReferences(this.getContext());
                            closeWals.run();
                        }
                        catch (Exception e) {
                            TraceUtil.setException((Span)replSpan, (Throwable)e, (boolean)false);
                            log.error("Error trying to close write-ahead logs for replication table", (Throwable)e);
                        }
                        finally {
                            replSpan.end();
                        }
                        Span walSpan = TraceUtil.startSpan(((Object)((Object)this)).getClass(), (String)"walogs");
                        try (Scope walScope = walSpan.makeCurrent();){
                            GarbageCollectWriteAheadLogs walogCollector = new GarbageCollectWriteAheadLogs(this.getContext(), fs, liveTServerSet, this.isUsingTrash());
                            log.info("Beginning garbage collection of write-ahead logs");
                            walogCollector.collect(this.status);
                            this.gcCycleMetrics.setLastWalCollect(this.status.lastLog);
                        }
                        catch (Exception e) {
                            TraceUtil.setException((Span)walSpan, (Throwable)e, (boolean)false);
                            log.error("{}", (Object)e.getMessage(), (Object)e);
                        }
                        finally {
                            walSpan.end();
                        }
                    }
                    catch (Exception e) {
                        TraceUtil.setException((Span)innerSpan, (Throwable)e, (boolean)true);
                        throw e;
                    }
                    finally {
                        innerSpan.end();
                    }
                    try {
                        ServerContext accumuloClient = this.getContext();
                        long actionStart = System.nanoTime();
                        String action = this.getConfiguration().get(Property.GC_USE_FULL_COMPACTION);
                        log.debug("gc post action {} started", (Object)action);
                        switch (action) {
                            case "compact": {
                                accumuloClient.tableOperations().compact(MetadataTable.NAME, null, null, true, true);
                                accumuloClient.tableOperations().compact(RootTable.NAME, null, null, true, true);
                                break;
                            }
                            case "flush": {
                                accumuloClient.tableOperations().flush(MetadataTable.NAME, null, null, true);
                                accumuloClient.tableOperations().flush(RootTable.NAME, null, null, true);
                                break;
                            }
                            default: {
                                log.trace("'none - no action' or invalid value provided: {}", (Object)action);
                            }
                        }
                        long actionComplete = System.nanoTime();
                        this.gcCycleMetrics.setPostOpDurationNanos(actionComplete - actionStart);
                        log.info("gc post action {} completed in {} seconds", (Object)action, (Object)String.format("%.2f", (double)TimeUnit.NANOSECONDS.toMillis(actionComplete - actionStart) / 1000.0));
                    }
                    catch (Exception e) {
                        TraceUtil.setException((Span)outerSpan, (Throwable)e, (boolean)false);
                        log.warn("{}", (Object)e.getMessage(), (Object)e);
                    }
                }
                catch (Exception e) {
                    TraceUtil.setException((Span)outerSpan, (Throwable)e, (boolean)true);
                    throw e;
                }
                finally {
                    outerSpan.end();
                }
                try {
                    this.gcCycleMetrics.incrementRunCycleCount();
                    long gcDelay = this.getConfiguration().getTimeInMillis(Property.GC_CYCLE_DELAY);
                    log.debug("Sleeping for {} milliseconds", (Object)gcDelay);
                    Thread.sleep(gcDelay);
                }
                catch (InterruptedException e) {
                    log.warn("{}", (Object)e.getMessage(), (Object)e);
                    throw e;
                }
            }
            catch (InterruptedException e) {
                log.info("Interrupt Exception received, shutting down");
                this.gracefulShutdown(this.getContext().rpcCreds());
            }
        }
        super.close();
        this.getShutdownComplete().set(true);
        log.info("stop requested. exiting ... ");
        try {
            this.gcLock.unlock();
        }
        catch (Exception e) {
            log.warn("Failed to release GarbageCollector lock", (Throwable)e);
        }
    }

    private void incrementStatsForRun(GCRun gcRun) {
        this.status.current.candidates += gcRun.getCandidatesStat();
        this.status.current.inUse += gcRun.getInUseStat();
        this.status.current.deleted += gcRun.getDeletedStat();
        this.status.current.errors += gcRun.getErrorsStat();
    }

    private void logStats() {
        log.info("Number of data file candidates for deletion: {}", (Object)this.status.current.candidates);
        log.info("Number of data file candidates still in use: {}", (Object)this.status.current.inUse);
        log.info("Number of successfully deleted data files: {}", (Object)this.status.current.deleted);
        log.info("Number of data files delete failures: {}", (Object)this.status.current.errors);
        log.info("Number of bulk imports in progress: {}", (Object)this.status.current.bulks);
    }

    boolean moveToTrash(Path path) throws IOException {
        VolumeManager fs = this.getContext().getVolumeManager();
        if (!this.isUsingTrash()) {
            return false;
        }
        try {
            return fs.moveToTrash(path);
        }
        catch (FileNotFoundException ex) {
            return false;
        }
    }

    private void getZooLock(HostAndPort addr) throws KeeperException, InterruptedException {
        ServiceLock.ServiceLockPath path = ServiceLock.path((String)(this.getContext().getZooKeeperRoot() + "/gc/lock"));
        UUID zooLockUUID = UUID.randomUUID();
        this.gcLock = new ServiceLock(this.getContext().getZooReaderWriter().getZooKeeper(), path, zooLockUUID);
        ServiceLockSupport.HAServiceLockWatcher gcLockWatcher = new ServiceLockSupport.HAServiceLockWatcher("gc", () -> this.getShutdownComplete().get());
        while (true) {
            this.gcLock.lock((ServiceLock.AccumuloLockWatcher)gcLockWatcher, new ServerServices(addr.toString(), ServerServices.Service.GC_CLIENT).toString().getBytes(StandardCharsets.UTF_8));
            gcLockWatcher.waitForChange();
            if (gcLockWatcher.isLockAcquired()) break;
            if (!gcLockWatcher.isFailedToAcquireLock()) {
                throw new IllegalStateException("gc lock in unknown state");
            }
            this.gcLock.tryToCancelAsyncLockOrUnlock();
            log.debug("Failed to get GC ZooKeeper lock, will retry");
            UtilWaitThread.sleepUninterruptibly((long)1000L, (TimeUnit)TimeUnit.MILLISECONDS);
        }
        log.info("Got GC lock.");
    }

    private HostAndPort startStatsService() {
        TMultiplexedProcessor processor = ThriftProcessorTypes.getGcTProcessor((ServerProcessService.Iface)this, (GCMonitorService.Iface)this, (ServerContext)this.getContext());
        IntStream port = this.getConfiguration().getPortStream(Property.GC_PORT);
        String hostname = HostAndPort.fromString((String)this.getBindAddress()).getHost();
        HostAndPort[] addresses = TServerUtils.getHostAndPorts((String)hostname, (IntStream)port);
        Property maxMessageSizeProperty = this.getConfiguration().resolve(Property.RPC_MAX_MESSAGE_SIZE, new Property[]{Property.GENERAL_MAX_MESSAGE_SIZE});
        long maxMessageSize = this.getConfiguration().getAsBytes(maxMessageSizeProperty);
        ServerAddress server = TServerUtils.startTServer((AccumuloConfiguration)this.getConfiguration(), (ThriftServerType)this.getContext().getThriftServerType(), (TProcessor)processor, (String)((Object)((Object)this)).getClass().getSimpleName(), (String)"GC Monitor Service", (int)2, (long)ThreadPools.DEFAULT_TIMEOUT_MILLISECS, (long)1000L, (long)maxMessageSize, (SslConnectionParams)this.getContext().getServerSslParams(), (SaslServerConnectionParams)this.getContext().getSaslParams(), (long)0L, (int)this.getConfiguration().getCount(Property.RPC_BACKLOG), (MetricsInfo)this.getContext().getMetricsInfo(), (boolean)false, (HostAndPort[])addresses);
        log.debug("Starting garbage collector listening on " + String.valueOf(server.address));
        return server.address;
    }

    static boolean isDir(String delete) {
        if (delete == null) {
            return false;
        }
        int slashCount = 0;
        for (int i = 0; i < delete.length(); ++i) {
            if (delete.charAt(i) != '/') continue;
            ++slashCount;
        }
        return slashCount == 1;
    }

    public GCStatus getStatus(TInfo info, TCredentials credentials) {
        return this.status;
    }

    public GcCycleMetrics getGcCycleMetrics() {
        return this.gcCycleMetrics;
    }

    public ServiceLock getLock() {
        return this.gcLock;
    }
}

