/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.miniclusterImpl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Suppliers;
import com.google.common.collect.Maps;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.accumulo.cluster.AccumuloCluster;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.ClientConfiguration;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.ClientProperty;
import org.apache.accumulo.core.conf.ConfigurationCopy;
import org.apache.accumulo.core.conf.DefaultConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.conf.SiteConfiguration;
import org.apache.accumulo.core.data.InstanceId;
import org.apache.accumulo.core.fate.zookeeper.ZooReader;
import org.apache.accumulo.core.fate.zookeeper.ZooReaderWriter;
import org.apache.accumulo.core.fate.zookeeper.ZooUtil;
import org.apache.accumulo.core.manager.thrift.ManagerGoalState;
import org.apache.accumulo.core.manager.thrift.ManagerMonitorInfo;
import org.apache.accumulo.core.rpc.clients.ThriftClientTypes;
import org.apache.accumulo.core.trace.TraceUtil;
import org.apache.accumulo.core.util.Pair;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.manager.state.SetGoalState;
import org.apache.accumulo.minicluster.ServerType;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloClusterControl;
import org.apache.accumulo.miniclusterImpl.MiniAccumuloConfigImpl;
import org.apache.accumulo.miniclusterImpl.ProcessNotFoundException;
import org.apache.accumulo.miniclusterImpl.ProcessReference;
import org.apache.accumulo.miniclusterImpl.ZooKeeperBindException;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.ServerDirs;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.accumulo.server.init.Initialize;
import org.apache.accumulo.server.util.AccumuloStatus;
import org.apache.accumulo.server.util.PortUtils;
import org.apache.accumulo.server.util.ZooZap;
import org.apache.accumulo.start.Main;
import org.apache.accumulo.start.classloader.vfs.MiniDFSUtil;
import org.apache.accumulo.start.spi.KeywordExecutable;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZKUtil;
import org.apache.zookeeper.ZooKeeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MiniAccumuloClusterImpl
implements AccumuloCluster {
    private static final Logger log = LoggerFactory.getLogger(MiniAccumuloClusterImpl.class);
    private final Set<Pair<ServerType, Integer>> debugPorts = new HashSet<Pair<ServerType, Integer>>();
    private final File zooCfgFile;
    private final String dfsUri;
    private final MiniAccumuloConfigImpl config;
    private final Supplier<Properties> clientProperties;
    private final SiteConfiguration siteConfig;
    private final Supplier<ServerContext> context;
    private final AtomicReference<MiniDFSCluster> miniDFS = new AtomicReference();
    private final List<Process> cleanup = new ArrayList<Process>();
    private final MiniAccumuloClusterControl clusterControl;
    private boolean initialized = false;
    private ExecutorService executor;

    public MiniAccumuloClusterImpl(File dir, String rootPassword) throws IOException {
        this(new MiniAccumuloConfigImpl(dir, rootPassword));
    }

    public MiniAccumuloClusterImpl(MiniAccumuloConfigImpl config) throws IOException {
        this.config = config.initialize();
        this.clientProperties = Suppliers.memoize(() -> (Properties)Accumulo.newClientProperties().from(config.getClientPropsFile().toPath()).build());
        if (Boolean.valueOf(config.getSiteConfig().get(Property.TSERV_NATIVEMAP_ENABLED.getKey())).booleanValue() && config.getNativeLibPaths().length == 0 && !config.getSystemProperties().containsKey("accumulo.native.lib.path")) {
            throw new IllegalStateException("MAC configured to use native maps, but native library path was not provided.");
        }
        MiniAccumuloClusterImpl.mkdirs(config.getConfDir());
        MiniAccumuloClusterImpl.mkdirs(config.getLogDir());
        MiniAccumuloClusterImpl.mkdirs(config.getLibDir());
        MiniAccumuloClusterImpl.mkdirs(config.getLibExtDir());
        if (!config.useExistingInstance()) {
            if (!config.useExistingZooKeepers()) {
                MiniAccumuloClusterImpl.mkdirs(config.getZooKeeperDir());
            }
            MiniAccumuloClusterImpl.mkdirs(config.getAccumuloDir());
        }
        if (config.getUseMiniDFS()) {
            File nn = new File(config.getAccumuloDir(), "nn");
            MiniAccumuloClusterImpl.mkdirs(nn);
            File dn = new File(config.getAccumuloDir(), "dn");
            MiniAccumuloClusterImpl.mkdirs(dn);
            File dfs = new File(config.getAccumuloDir(), "dfs");
            MiniAccumuloClusterImpl.mkdirs(dfs);
            Configuration conf = new Configuration();
            conf.set("dfs.namenode.name.dir", nn.getAbsolutePath());
            conf.set("dfs.datanode.data.dir", dn.getAbsolutePath());
            conf.set("dfs.replication", "1");
            conf.set("dfs.namenode.replication.min", "1");
            conf.set("dfs.support.append", "true");
            conf.set("dfs.datanode.synconclose", "true");
            conf.set("dfs.datanode.data.dir.perm", MiniDFSUtil.computeDatanodeDirectoryPermission());
            config.getHadoopConfOverrides().forEach((k, v) -> conf.set(k, v));
            String oldTestBuildData = System.setProperty("test.build.data", dfs.getAbsolutePath());
            this.miniDFS.set(new MiniDFSCluster.Builder(conf).numDataNodes(config.getNumDataNodes()).build());
            if (oldTestBuildData == null) {
                System.clearProperty("test.build.data");
            } else {
                System.setProperty("test.build.data", oldTestBuildData);
            }
            this.miniDFS.get().waitClusterUp();
            InetSocketAddress dfsAddress = this.miniDFS.get().getNameNode().getNameNodeAddress();
            this.dfsUri = "hdfs://" + dfsAddress.getHostName() + ":" + dfsAddress.getPort();
            File coreFile = new File(config.getConfDir(), "core-site.xml");
            this.writeConfig(coreFile, Collections.singletonMap("fs.default.name", this.dfsUri).entrySet());
            File hdfsFile = new File(config.getConfDir(), "hdfs-site.xml");
            this.writeConfig(hdfsFile, (Iterable<Map.Entry<String, String>>)conf);
            Map<String, String> siteConfig = config.getSiteConfig();
            siteConfig.put(Property.INSTANCE_VOLUMES.getKey(), this.dfsUri + "/accumulo");
            config.setSiteConfig(siteConfig);
        } else {
            this.dfsUri = config.useExistingInstance() ? config.getHadoopConfiguration().get("fs.defaultFS") : "file:///";
        }
        config.preStartConfigUpdate();
        File clientConfFile = config.getClientConfFile();
        this.writeConfigProperties(clientConfFile, Maps.filterEntries(config.getSiteConfig(), v -> ClientConfiguration.ClientProperty.getPropertyByKey((String)((String)v.getKey())) != null));
        Map<String, String> clientProps = config.getClientProps();
        clientProps.put(ClientProperty.INSTANCE_ZOOKEEPERS.getKey(), config.getZooKeepers());
        clientProps.put(ClientProperty.INSTANCE_NAME.getKey(), config.getInstanceName());
        if (!clientProps.containsKey(ClientProperty.AUTH_TYPE.getKey())) {
            clientProps.put(ClientProperty.AUTH_TYPE.getKey(), "password");
            clientProps.put(ClientProperty.AUTH_PRINCIPAL.getKey(), config.getRootUserName());
            clientProps.put(ClientProperty.AUTH_TOKEN.getKey(), config.getRootPassword());
        }
        File clientPropsFile = config.getClientPropsFile();
        this.writeConfigProperties(clientPropsFile, clientProps);
        File siteFile = new File(config.getConfDir(), "accumulo.properties");
        this.writeConfigProperties(siteFile, config.getSiteConfig());
        this.siteConfig = SiteConfiguration.fromFile((File)siteFile).build();
        this.context = Suppliers.memoize(() -> new ServerContext(this.siteConfig));
        if (!config.useExistingInstance() && !config.useExistingZooKeepers()) {
            this.zooCfgFile = new File(config.getConfDir(), "zoo.cfg");
            FileWriter fileWriter = new FileWriter(this.zooCfgFile, StandardCharsets.UTF_8);
            Properties zooCfg = new Properties();
            zooCfg.setProperty("tickTime", "2000");
            zooCfg.setProperty("initLimit", "10");
            zooCfg.setProperty("syncLimit", "5");
            zooCfg.setProperty("clientPortAddress", "127.0.0.1");
            zooCfg.setProperty("clientPort", "" + config.getZooKeeperPort());
            zooCfg.setProperty("maxClientCnxns", "1000");
            zooCfg.setProperty("dataDir", config.getZooKeeperDir().getAbsolutePath());
            zooCfg.setProperty("4lw.commands.whitelist", "ruok,wchs");
            zooCfg.setProperty("admin.enableServer", "false");
            zooCfg.store(fileWriter, null);
            fileWriter.close();
        } else {
            this.zooCfgFile = null;
        }
        this.clusterControl = new MiniAccumuloClusterControl(this);
    }

    File getZooCfgFile() {
        return this.zooCfgFile;
    }

    public ProcessInfo exec(Class<?> clazz, String ... args) throws IOException {
        return this.exec(clazz, (List<String>)null, args);
    }

    public ProcessInfo exec(Class<?> clazz, List<String> jvmArgs, String ... args) throws IOException {
        ArrayList<String> jvmArgs2 = new ArrayList<String>(1 + (jvmArgs == null ? 0 : jvmArgs.size()));
        jvmArgs2.add("-Xmx" + this.config.getDefaultMemory());
        if (jvmArgs != null) {
            jvmArgs2.addAll(jvmArgs);
        }
        return this._exec(clazz, jvmArgs2, args);
    }

    private String getClasspath() {
        StringBuilder classpathBuilder = new StringBuilder();
        classpathBuilder.append(this.config.getConfDir().getAbsolutePath());
        if (this.config.getHadoopConfDir() != null) {
            classpathBuilder.append(File.pathSeparator).append(this.config.getHadoopConfDir().getAbsolutePath());
        }
        if (this.config.getClasspathItems() == null) {
            String javaClassPath = System.getProperty("java.class.path");
            if (javaClassPath == null) {
                throw new IllegalStateException("java.class.path is not set");
            }
            classpathBuilder.append(File.pathSeparator).append(javaClassPath);
        } else {
            for (String s : this.config.getClasspathItems()) {
                classpathBuilder.append(File.pathSeparator).append(s);
            }
        }
        return classpathBuilder.toString();
    }

    @SuppressFBWarnings(value={"COMMAND_INJECTION", "PATH_TRAVERSAL_IN"}, justification="mini runs in the same security context as user providing the args")
    private ProcessInfo _exec(Class<?> clazz, List<String> extraJvmOpts, String ... args) throws IOException {
        String javaHome = System.getProperty("java.home");
        String javaBin = javaHome + File.separator + "bin" + File.separator + "java";
        Stream<String> basicArgs = Stream.of(javaBin, "-Dproc=" + clazz.getSimpleName());
        Stream jvmArgs = extraJvmOpts.stream();
        Stream<String> propsArgs = this.config.getSystemProperties().entrySet().stream().map(e -> String.format("-D%s=%s", e.getKey(), e.getValue()));
        Stream<String> hardcodedArgs = Stream.of("-Dapple.awt.UIElement=true", "-Djava.net.preferIPv4Stack=true", "-XX:+PerfDisableSharedMem", "-XX:+AlwaysPreTouch", Main.class.getName(), clazz.getName());
        List<String> argList = Stream.of(basicArgs, jvmArgs, propsArgs, hardcodedArgs, Stream.of(args)).flatMap(Function.identity()).collect(Collectors.toList());
        ProcessBuilder builder = new ProcessBuilder(argList);
        String classpath = this.getClasspath();
        builder.environment().put("CLASSPATH", classpath);
        builder.environment().put("ACCUMULO_HOME", this.config.getDir().getAbsolutePath());
        builder.environment().put("ACCUMULO_LOG_DIR", this.config.getLogDir().getAbsolutePath());
        builder.environment().put("ACCUMULO_CLIENT_CONF_PATH", this.config.getClientConfFile().getAbsolutePath());
        String ldLibraryPath = Joiner.on((String)File.pathSeparator).join((Object[])this.config.getNativeLibPaths());
        builder.environment().put("LD_LIBRARY_PATH", ldLibraryPath);
        builder.environment().put("DYLD_LIBRARY_PATH", ldLibraryPath);
        String env = System.getenv("HADOOP_HOME");
        if (env != null) {
            builder.environment().put("HADOOP_HOME", env);
        }
        if ((env = System.getenv("ZOOKEEPER_HOME")) != null) {
            builder.environment().put("ZOOKEEPER_HOME", env);
        }
        builder.environment().put("ACCUMULO_CONF_DIR", this.config.getConfDir().getAbsolutePath());
        if (this.config.getHadoopConfDir() != null) {
            builder.environment().put("HADOOP_CONF_DIR", this.config.getHadoopConfDir().getAbsolutePath());
        }
        log.debug("Starting MiniAccumuloCluster process with class: " + clazz.getSimpleName() + "\n, args: " + String.valueOf(argList) + "\n, environment: " + String.valueOf(builder.environment()));
        int hashcode = builder.hashCode();
        File stdOut = new File(this.config.getLogDir(), clazz.getSimpleName() + "_" + hashcode + ".out");
        File stdErr = new File(this.config.getLogDir(), clazz.getSimpleName() + "_" + hashcode + ".err");
        Process process = builder.redirectError(stdErr).redirectOutput(stdOut).start();
        this.cleanup.add(process);
        return new ProcessInfo(process, stdOut);
    }

    public ProcessInfo _exec(KeywordExecutable server, ServerType serverType, Map<String, String> configOverrides, String ... args) throws IOException {
        String[] modifiedArgs = args == null || args.length == 0 ? new String[]{server.keyword()} : (String[])Stream.concat(Stream.of(server.keyword()), Stream.of(args)).toArray(String[]::new);
        return this._exec(Main.class, serverType, configOverrides, modifiedArgs);
    }

    public ProcessInfo _exec(Class<?> clazz, ServerType serverType, Map<String, String> configOverrides, String ... args) throws IOException {
        ArrayList<String> jvmOpts = new ArrayList<String>();
        if (serverType == ServerType.ZOOKEEPER) {
            jvmOpts.add("-Dzookeeper.jmx.log4j.disable=true");
        }
        jvmOpts.add("-Xmx" + this.config.getMemory(serverType));
        if (configOverrides != null && !configOverrides.isEmpty()) {
            File siteFile = Files.createTempFile(this.config.getConfDir().toPath(), "accumulo", ".properties", new FileAttribute[0]).toFile();
            HashMap<String, String> confMap = new HashMap<String, String>(this.config.getSiteConfig());
            confMap.putAll(configOverrides);
            this.writeConfigProperties(siteFile, confMap);
            jvmOpts.add("-Daccumulo.properties=" + siteFile.getName());
        }
        if (this.config.isJDWPEnabled()) {
            int port = PortUtils.getRandomFreePort();
            jvmOpts.addAll(this.buildRemoteDebugParams(port));
            this.debugPorts.add((Pair<ServerType, Integer>)new Pair((Object)serverType, (Object)port));
        }
        return this._exec(clazz, jvmOpts, args);
    }

    private static void mkdirs(File dir) {
        if (!dir.mkdirs()) {
            log.warn("Unable to create {}", (Object)dir);
        }
    }

    private void writeConfig(File file, Iterable<Map.Entry<String, String>> settings) throws IOException {
        FileWriter fileWriter = new FileWriter(file, StandardCharsets.UTF_8);
        fileWriter.append("<configuration>\n");
        for (Map.Entry<String, String> entry : settings) {
            String value = entry.getValue().replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;");
            fileWriter.append("<property><name>" + entry.getKey() + "</name><value>" + value + "</value></property>\n");
        }
        fileWriter.append("</configuration>\n");
        fileWriter.close();
    }

    private void writeConfigProperties(File file, Map<String, String> settings) throws IOException {
        FileWriter fileWriter = new FileWriter(file, StandardCharsets.UTF_8);
        for (Map.Entry<String, String> entry : settings.entrySet()) {
            fileWriter.append(entry.getKey() + "=" + entry.getValue() + "\n");
        }
        fileWriter.close();
    }

    @Override
    @SuppressFBWarnings(value={"UNENCRYPTED_SOCKET"}, justification="insecure socket used for reservation")
    public synchronized void start() throws IOException, InterruptedException {
        if (this.config.getUseMiniDFS() && this.miniDFS.get() == null) {
            throw new IllegalStateException("Cannot restart mini when using miniDFS");
        }
        MiniAccumuloClusterControl control = this.getClusterControl();
        if (this.config.useExistingInstance()) {
            Path instanceIdPath;
            AccumuloConfiguration acuConf = this.config.getAccumuloConfiguration();
            Configuration hadoopConf = this.config.getHadoopConfiguration();
            ServerDirs serverDirs = new ServerDirs(acuConf, hadoopConf);
            try (VolumeManager fs = this.getServerContext().getVolumeManager();){
                instanceIdPath = serverDirs.getInstanceIdLocation(fs.getFirst());
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            InstanceId instanceIdFromFile = VolumeManager.getInstanceIDFromHdfs((Path)instanceIdPath, (Configuration)hadoopConf);
            ZooReaderWriter zrw = this.getServerContext().getZooReaderWriter();
            String rootPath = ZooUtil.getRoot((InstanceId)instanceIdFromFile);
            String instanceName = null;
            try {
                for (String name : zrw.getChildren("/accumulo/instances")) {
                    String instanceNamePath = "/accumulo/instances/" + name;
                    byte[] bytes = zrw.getData(instanceNamePath);
                    InstanceId iid = InstanceId.of((String)new String(bytes, StandardCharsets.UTF_8));
                    if (!iid.equals((Object)instanceIdFromFile)) continue;
                    instanceName = name;
                }
            }
            catch (KeeperException e) {
                throw new IllegalStateException("Unable to read instance name from zookeeper.", e);
            }
            if (instanceName == null) {
                throw new IllegalStateException("Unable to read instance name from zookeeper.");
            }
            this.config.setInstanceName(instanceName);
            if (!AccumuloStatus.isAccumuloOffline((ZooReader)zrw, (String)rootPath)) {
                throw new IllegalStateException("The Accumulo instance being used is already running. Aborting.");
            }
        } else {
            if (!this.initialized) {
                Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                    try {
                        this.stop();
                    }
                    catch (IOException e) {
                        log.error("IOException while attempting to stop the MiniAccumuloCluster.", (Throwable)e);
                    }
                    catch (InterruptedException e) {
                        log.error("The stopping of MiniAccumuloCluster was interrupted.", (Throwable)e);
                    }
                }));
            }
            if (!this.config.useExistingZooKeepers()) {
                log.warn("Starting ZooKeeper");
                control.start(ServerType.ZOOKEEPER);
            }
            if (!this.initialized) {
                if (!this.config.useExistingZooKeepers()) {
                    long startTime = System.currentTimeMillis();
                    block17: while (true) {
                        try {
                            while (true) {
                                Socket s = new Socket("127.0.0.1", this.config.getZooKeeperPort());
                                try {
                                    s.setReuseAddress(true);
                                    s.getOutputStream().write("ruok\n".getBytes(StandardCharsets.UTF_8));
                                    s.getOutputStream().flush();
                                    byte[] buffer = new byte[100];
                                    int n = s.getInputStream().read(buffer);
                                    if (n < 4 || !new String(buffer, 0, 4, StandardCharsets.UTF_8).equals("imok")) continue;
                                    break block17;
                                }
                                finally {
                                    s.close();
                                    continue;
                                }
                                break;
                            }
                        }
                        catch (IOException | RuntimeException e) {
                            if (System.currentTimeMillis() - startTime >= this.config.getZooKeeperStartupTime()) {
                                throw new ZooKeeperBindException("Zookeeper did not start within " + this.config.getZooKeeperStartupTime() / 1000L + " seconds. Check the logs in " + String.valueOf(this.config.getLogDir()) + " for errors.  Last exception: " + String.valueOf(e));
                            }
                            UtilWaitThread.sleepUninterruptibly((long)250L, (TimeUnit)TimeUnit.MILLISECONDS);
                            continue;
                        }
                        break;
                    }
                }
                LinkedList<String> args = new LinkedList<String>();
                args.add("--instance-name");
                args.add(this.config.getInstanceName());
                args.add("--user");
                args.add(this.config.getRootUserName());
                args.add("--clear-instance-name");
                String saslEnabled = this.config.getSiteConfig().get(Property.INSTANCE_RPC_SASL_ENABLED.getKey());
                if (saslEnabled == null || !Boolean.parseBoolean(saslEnabled)) {
                    args.add("--password");
                    args.add(this.config.getRootPassword());
                }
                log.warn("Initializing ZooKeeper");
                Process initProcess = this.exec(Initialize.class, args.toArray(new String[0])).getProcess();
                int ret = initProcess.waitFor();
                if (ret != 0) {
                    throw new IllegalStateException("Initialize process returned " + ret + ". Check the logs in " + String.valueOf(this.config.getLogDir()) + " for errors.");
                }
                this.initialized = true;
            } else {
                log.warn("Not initializing ZooKeeper, already initialized");
            }
        }
        log.info("Starting MAC against instance {} and zookeeper(s) {}.", (Object)this.config.getInstanceName(), (Object)this.config.getZooKeepers());
        control.start(ServerType.TABLET_SERVER);
        int ret = 0;
        for (int i = 0; i < 5 && (ret = this.exec(Main.class, SetGoalState.class.getName(), ManagerGoalState.NORMAL.toString()).getProcess().waitFor()) != 0; ++i) {
            UtilWaitThread.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
        }
        if (ret != 0) {
            throw new IllegalStateException("Could not set manager goal state, process returned " + ret + ". Check the logs in " + String.valueOf(this.config.getLogDir()) + " for errors.");
        }
        control.start(ServerType.MANAGER);
        control.start(ServerType.GARBAGE_COLLECTOR);
        if (this.executor == null) {
            this.executor = Executors.newSingleThreadExecutor();
        }
        this.verifyUp();
    }

    private static void waitForProcessStart(Process p, String name) throws InterruptedException {
        long start = System.nanoTime();
        while (p.info().startInstant().isEmpty()) {
            if (TimeUnit.NANOSECONDS.toSeconds(System.nanoTime() - start) > 10L) {
                throw new IllegalStateException("Error starting " + name + " - instance not started within 10 seconds");
            }
            Thread.sleep(50L);
        }
    }

    private void verifyUp() throws InterruptedException, IOException {
        int numTries = 10;
        Objects.requireNonNull(this.getClusterControl().managerProcess, "Error starting Manager - no process");
        MiniAccumuloClusterImpl.waitForProcessStart(this.getClusterControl().managerProcess, "Manager");
        Objects.requireNonNull(this.getClusterControl().gcProcess, "Error starting GC - no process");
        MiniAccumuloClusterImpl.waitForProcessStart(this.getClusterControl().gcProcess, "GC");
        int tsExpectedCount = 0;
        for (Process tsp : this.getClusterControl().tabletServerProcesses) {
            Objects.requireNonNull(tsp, "Error starting TabletServer " + ++tsExpectedCount + " - no process");
            MiniAccumuloClusterImpl.waitForProcessStart(tsp, "TabletServer" + tsExpectedCount);
        }
        try (ZooKeeper zk = new ZooKeeper(this.getZooKeepers(), 60000, event -> log.warn("{}", (Object)event));){
            int i;
            String secret = this.getSiteConfiguration().get(Property.INSTANCE_SECRET);
            while (zk.getState() != ZooKeeper.States.CONNECTED) {
                log.info("Waiting for ZK client to connect, state: {} - will retry", (Object)zk.getState());
                Thread.sleep(1000L);
            }
            String instanceId = null;
            for (i = 0; i < numTries; ++i) {
                if (zk.getState() == ZooKeeper.States.CONNECTED) {
                    ZooUtil.digestAuth((ZooKeeper)zk, (String)secret);
                    try {
                        AtomicInteger rc2 = new AtomicInteger();
                        CountDownLatch waiter = new CountDownLatch(1);
                        zk.sync("/", (code, arg1, arg2) -> {
                            rc2.set(code);
                            waiter.countDown();
                        }, null);
                        waiter.await();
                        KeeperException.Code code2 = KeeperException.Code.get((int)rc2.get());
                        if (code2 != KeeperException.Code.OK) {
                            throw KeeperException.create((KeeperException.Code)code2);
                        }
                        String instanceNamePath = "/accumulo/instances/" + this.config.getInstanceName();
                        byte[] bytes = zk.getData(instanceNamePath, null, null);
                        instanceId = new String(bytes, StandardCharsets.UTF_8);
                        break;
                    }
                    catch (KeeperException e) {
                        log.warn("Error trying to read instance id from zookeeper: " + e.getMessage());
                        log.debug("Unable to read instance id from zookeeper.", (Throwable)e);
                    }
                } else {
                    log.warn("ZK client not connected, state: {}", (Object)zk.getState());
                }
                Thread.sleep(1000L);
            }
            if (instanceId == null) {
                for (i = 0; i < numTries; ++i) {
                    if (zk.getState() == ZooKeeper.States.CONNECTED) {
                        ZooUtil.digestAuth((ZooKeeper)zk, (String)secret);
                        try {
                            log.warn("******* COULD NOT FIND INSTANCE ID - DUMPING ZK ************");
                            log.warn("Connected to ZooKeeper: {}", (Object)this.getZooKeepers());
                            log.warn("Looking for instanceId at {}", (Object)("/accumulo/instances/" + this.config.getInstanceName()));
                            ZKUtil.visitSubTreeDFS((ZooKeeper)zk, (String)"/accumulo", (boolean)false, (rc, path, ctx, name) -> log.warn("{}", (Object)path));
                            log.warn("******* END ZK DUMP ************");
                        }
                        catch (InterruptedException | KeeperException e) {
                            log.error("Error dumping zk", e);
                        }
                    }
                    Thread.sleep(1000L);
                }
                throw new IllegalStateException("Unable to find instance id from zookeeper.");
            }
            String rootPath = "/accumulo/" + instanceId;
            int tsActualCount = 0;
            try {
                while (tsActualCount < tsExpectedCount) {
                    tsActualCount = 0;
                    for (String child : zk.getChildren(rootPath + "/tservers", null)) {
                        if (zk.getChildren(rootPath + "/tservers/" + child, null).isEmpty()) {
                            log.info("TServer " + tsActualCount + " not yet present in ZooKeeper");
                            continue;
                        }
                        log.info("TServer " + ++tsActualCount + " present in ZooKeeper");
                    }
                    Thread.sleep(500L);
                }
            }
            catch (KeeperException e) {
                throw new IllegalStateException("Unable to read TServer information from zookeeper.", e);
            }
            try {
                while (zk.getChildren(rootPath + "/managers/lock", null).isEmpty()) {
                    log.info("Manager not yet present in ZooKeeper");
                    Thread.sleep(500L);
                }
            }
            catch (KeeperException e) {
                throw new IllegalStateException("Unable to read Manager information from zookeeper.", e);
            }
            try {
                while (zk.getChildren(rootPath + "/gc/lock", null).isEmpty()) {
                    log.info("GC not yet present in ZooKeeper");
                    Thread.sleep(500L);
                }
            }
            catch (KeeperException e) {
                throw new IllegalStateException("Unable to read GC information from zookeeper.", e);
            }
        }
    }

    private List<String> buildRemoteDebugParams(int port) {
        return Collections.singletonList(String.format("-agentlib:jdwp=transport=dt_socket,server=y,suspend=n,address=%d", port));
    }

    public Set<Pair<ServerType, Integer>> getDebugPorts() {
        return this.debugPorts;
    }

    List<ProcessReference> references(Process ... procs) {
        return Stream.of(procs).map(ProcessReference::new).collect(Collectors.toList());
    }

    public Map<ServerType, Collection<ProcessReference>> getProcesses() {
        HashMap<ServerType, Collection<ProcessReference>> result = new HashMap<ServerType, Collection<ProcessReference>>();
        MiniAccumuloClusterControl control = this.getClusterControl();
        result.put(ServerType.MANAGER, this.references(control.managerProcess));
        result.put(ServerType.TABLET_SERVER, this.references(control.tabletServerProcesses.toArray(new Process[0])));
        if (control.zooKeeperProcess != null) {
            result.put(ServerType.ZOOKEEPER, this.references(control.zooKeeperProcess));
        }
        if (control.gcProcess != null) {
            result.put(ServerType.GARBAGE_COLLECTOR, this.references(control.gcProcess));
        }
        return result;
    }

    public void killProcess(ServerType type, ProcessReference proc) throws ProcessNotFoundException, InterruptedException {
        this.getClusterControl().killProcess(type, proc);
    }

    @Override
    public String getInstanceName() {
        return this.config.getInstanceName();
    }

    @Override
    public String getZooKeepers() {
        return this.config.getZooKeepers();
    }

    @Override
    public ServerContext getServerContext() {
        return this.context.get();
    }

    @Override
    public synchronized void stop() throws IOException, InterruptedException {
        boolean startCalled;
        block11: {
            if (this.executor == null) {
                return;
            }
            MiniAccumuloClusterControl control = this.getClusterControl();
            control.stop(ServerType.GARBAGE_COLLECTOR, null);
            control.stop(ServerType.MANAGER, null);
            control.stop(ServerType.COMPACTION_COORDINATOR);
            control.stop(ServerType.TABLET_SERVER, null);
            control.stop(ServerType.COMPACTOR, null);
            control.stop(ServerType.SCAN_SERVER, null);
            try {
                new ZooZap().zap(this.getServerContext().getSiteConfiguration(), new String[]{"-manager", "-compaction-coordinators", "-tservers", "-compactors", "-sservers", "--gc"});
            }
            catch (RuntimeException e) {
                log.error("Error zapping zookeeper locks", (Throwable)e);
            }
            control.stop(ServerType.ZOOKEEPER, null);
            startCalled = true;
            try {
                this.getServerContext();
            }
            catch (RuntimeException e) {
                if (!e.getMessage().startsWith("Accumulo not initialized")) break block11;
                startCalled = false;
            }
        }
        if (startCalled) {
            ServerContext ctx = this.getServerContext();
            String zRoot = this.getServerContext().getZooKeeperRoot();
            Predicate<String> pred = path -> false;
            for (String lockPath : Set.of("/managers/lock", "/gc/lock", "/compactors", "/sservers", "/tservers")) {
                pred = pred.or(path -> path.startsWith(zRoot + lockPath));
            }
            ctx.getZooCache().clear(pred);
        }
        if (this.executor != null) {
            List<Runnable> tasksRemaining = this.executor.shutdownNow();
            if (!tasksRemaining.isEmpty()) {
                log.warn("Unexpectedly had {} task(s) remaining in threadpool for execution when being stopped", (Object)tasksRemaining.size());
            }
            this.executor = null;
        }
        MiniDFSCluster miniDFSActual = this.miniDFS.get();
        if (this.config.getUseMiniDFS() && miniDFSActual != null) {
            miniDFSActual.shutdown();
        }
        for (Process p : this.cleanup) {
            p.destroy();
            p.waitFor();
        }
        this.miniDFS.set(null);
    }

    public MiniAccumuloConfigImpl getConfig() {
        return this.config;
    }

    @Override
    public AccumuloClient createAccumuloClient(String user, AuthenticationToken token) {
        return (AccumuloClient)Accumulo.newClient().from(this.clientProperties.get()).as((CharSequence)user, token).build();
    }

    @Override
    public ClientConfiguration getClientConfig() {
        return ClientConfiguration.fromMap(this.config.getSiteConfig()).withInstance(this.getInstanceName()).withZkHosts(this.getZooKeepers());
    }

    @Override
    public Properties getClientProperties() {
        Properties copy = new Properties();
        copy.putAll((Map<?, ?>)this.clientProperties.get());
        return copy;
    }

    @Override
    public FileSystem getFileSystem() {
        try {
            return FileSystem.get((URI)new URI(this.dfsUri), (Configuration)new Configuration());
        }
        catch (IOException | URISyntaxException e) {
            throw new IllegalStateException(e);
        }
    }

    @VisibleForTesting
    protected void setShutdownExecutor(ExecutorService svc) {
        this.executor = svc;
    }

    @VisibleForTesting
    protected ExecutorService getShutdownExecutor() {
        return this.executor;
    }

    public int stopProcessWithTimeout(Process proc, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        FutureTask<Integer> future = new FutureTask<Integer>(() -> {
            proc.destroy();
            return proc.waitFor();
        });
        this.executor.execute(future);
        return future.get(timeout, unit);
    }

    public ManagerMonitorInfo getManagerMonitorInfo() throws AccumuloException, AccumuloSecurityException {
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(this.clientProperties.get()).build();){
            ClientContext context = (ClientContext)c;
            ManagerMonitorInfo managerMonitorInfo = (ManagerMonitorInfo)ThriftClientTypes.MANAGER.execute(context, client -> client.getManagerStats(TraceUtil.traceInfo(), context.rpcCreds()));
            return managerMonitorInfo;
        }
    }

    public MiniDFSCluster getMiniDfs() {
        return this.miniDFS.get();
    }

    @Override
    public MiniAccumuloClusterControl getClusterControl() {
        return this.clusterControl;
    }

    @Override
    public Path getTemporaryPath() {
        String p;
        if (this.config.getUseMiniDFS()) {
            p = "/tmp/";
        } else {
            File tmp = new File(this.config.getDir(), "tmp");
            MiniAccumuloClusterImpl.mkdirs(tmp);
            p = tmp.toString();
        }
        return this.getFileSystem().makeQualified(new Path(p));
    }

    @Override
    public AccumuloConfiguration getSiteConfiguration() {
        return new ConfigurationCopy(Stream.concat(DefaultConfiguration.getInstance().stream(), this.config.getSiteConfig().entrySet().stream()));
    }

    @Override
    public String getAccumuloPropertiesPath() {
        return new File(this.config.getConfDir(), "accumulo.properties").toString();
    }

    @Override
    public String getClientPropsPath() {
        return this.config.getClientPropsFile().getAbsolutePath();
    }

    public static class ProcessInfo {
        private final Process process;
        private final File stdOut;

        public ProcessInfo(Process process, File stdOut) {
            this.process = process;
            this.stdOut = stdOut;
        }

        public Process getProcess() {
            return this.process;
        }

        public String readStdOut() {
            String string;
            FileInputStream in = new FileInputStream(this.stdOut);
            try {
                string = IOUtils.toString((InputStream)in, (Charset)StandardCharsets.UTF_8);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            ((InputStream)in).close();
            return string;
        }
    }
}

