/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.monitor.rest.problems;

import jakarta.inject.Inject;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.monitor.Monitor;
import org.apache.accumulo.monitor.rest.problems.ProblemDetail;
import org.apache.accumulo.monitor.rest.problems.ProblemDetailInformation;
import org.apache.accumulo.monitor.rest.problems.ProblemSummary;
import org.apache.accumulo.monitor.rest.problems.ProblemSummaryInformation;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.problems.ProblemReport;
import org.apache.accumulo.server.problems.ProblemReports;
import org.apache.accumulo.server.problems.ProblemType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/problems")
@Produces(value={"application/json", "application/xml"})
public class ProblemsResource {
    @Inject
    private Monitor monitor;

    @GET
    @Path(value="summary")
    public ProblemSummary getSummary() {
        ProblemSummary problems = new ProblemSummary();
        if (this.monitor.getProblemException() == null) {
            for (Map.Entry<TableId, Map<ProblemType, Integer>> entry : this.monitor.getProblemSummary().entrySet()) {
                Integer readCount = null;
                Integer writeCount = null;
                Integer loadCount = null;
                for (ProblemType pt : ProblemType.values()) {
                    Integer pcount = entry.getValue().get(pt);
                    if (pt.equals((Object)ProblemType.FILE_READ)) {
                        readCount = pcount;
                        continue;
                    }
                    if (pt.equals((Object)ProblemType.FILE_WRITE)) {
                        writeCount = pcount;
                        continue;
                    }
                    if (!pt.equals((Object)ProblemType.TABLET_LOAD)) continue;
                    loadCount = pcount;
                }
                String tableName = this.monitor.getContext().getPrintableTableInfoFromId(entry.getKey());
                problems.addProblemSummary(new ProblemSummaryInformation(tableName, entry.getKey(), readCount, writeCount, loadCount));
            }
        }
        return problems;
    }

    @POST
    @Consumes(value={"text/plain"})
    @Path(value="summary")
    public void clearTableProblems(@QueryParam(value="s") @NotNull @Pattern(regexp="[!+]?\\w+") @NotNull @Pattern(regexp="[!+]?\\w+") String tableID) {
        Logger log = LoggerFactory.getLogger(Monitor.class);
        try {
            ProblemReports.getInstance((ServerContext)this.monitor.getContext()).deleteProblemReports(TableId.of((String)tableID));
        }
        catch (Exception e) {
            log.error("Failed to delete problem reports for table " + (tableID.isEmpty() ? "" : this.sanitize(tableID)), (Throwable)e);
        }
    }

    @GET
    @Path(value="details")
    public ProblemDetail getDetails() {
        ProblemDetail problems = new ProblemDetail();
        if (this.monitor.getProblemException() == null) {
            for (Map.Entry<TableId, Map<ProblemType, Integer>> entry : this.monitor.getProblemSummary().entrySet()) {
                Iterator iter;
                ArrayList<ProblemReport> problemReports = new ArrayList<ProblemReport>();
                Iterator iterator = iter = entry.getKey() == null ? ProblemReports.getInstance((ServerContext)this.monitor.getContext()).iterator() : ProblemReports.getInstance((ServerContext)this.monitor.getContext()).iterator(entry.getKey());
                while (iter.hasNext()) {
                    problemReports.add((ProblemReport)iter.next());
                }
                for (ProblemReport pr : problemReports) {
                    String tableName = this.monitor.getContext().getPrintableTableInfoFromId(pr.getTableId());
                    problems.addProblemDetail(new ProblemDetailInformation(tableName, entry.getKey(), pr.getProblemType().name(), pr.getServer(), pr.getTime(), pr.getResource(), pr.getException()));
                }
            }
        }
        return problems;
    }

    @POST
    @Consumes(value={"text/plain"})
    @Path(value="details")
    public void clearDetailsProblems(@QueryParam(value="table") @NotNull @Pattern(regexp="[!+]?\\w+") @NotNull @Pattern(regexp="[!+]?\\w+") String tableID, @QueryParam(value="resource") @NotNull @Pattern(regexp="(?:)(.*)") @NotNull @Pattern(regexp="(?:)(.*)") String resource, @QueryParam(value="ptype") @NotNull @Pattern(regexp="FILE_READ|FILE_WRITE|TABLET_LOAD") @NotNull @Pattern(regexp="FILE_READ|FILE_WRITE|TABLET_LOAD") String ptype) {
        Logger log = LoggerFactory.getLogger(Monitor.class);
        try {
            ProblemReports.getInstance((ServerContext)this.monitor.getContext()).deleteProblemReport(TableId.of((String)tableID), ProblemType.valueOf((String)ptype), resource);
        }
        catch (Exception e) {
            log.error("Failed to delete problem reports for table " + (tableID.isBlank() ? "" : this.sanitize(tableID)), (Throwable)e);
        }
    }

    private String sanitize(String msg) {
        return msg.replaceAll("[\r\n]", "");
    }

    @GET
    @Path(value="exception")
    public Exception getException() {
        return this.monitor.getProblemException();
    }
}

