/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.compaction;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.iterators.WrappingIterator;

public class CountingIterator
extends WrappingIterator {
    private long count;
    private final ArrayList<CountingIterator> deepCopies;
    private final AtomicLong entriesRead;

    public CountingIterator deepCopy(IteratorEnvironment env) {
        return new CountingIterator(this, env);
    }

    private CountingIterator(CountingIterator other, IteratorEnvironment env) {
        this.setSource(other.getSource().deepCopy(env));
        this.count = 0L;
        this.deepCopies = other.deepCopies;
        this.entriesRead = other.entriesRead;
        this.deepCopies.add(this);
    }

    public CountingIterator(SortedKeyValueIterator<Key, Value> source, AtomicLong entriesRead) {
        this.deepCopies = new ArrayList();
        this.setSource(source);
        this.count = 0L;
        this.entriesRead = entriesRead;
    }

    public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) {
        throw new UnsupportedOperationException();
    }

    public void next() throws IOException {
        super.next();
        ++this.count;
        if (this.count % 1024L == 0L) {
            this.entriesRead.addAndGet(1024L);
        }
    }

    public long getCount() {
        long sum = 0L;
        for (CountingIterator dc : this.deepCopies) {
            sum += dc.count;
        }
        return this.count + sum;
    }
}

