/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.accumulo.core.rpc;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;

import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransportException;

public class TBufferedSocket extends TIOStreamTransport {

  String client;

  public TBufferedSocket(TSocket sock, int bufferSize) throws IOException, TTransportException {
    super(new BufferedInputStream(sock.getSocket().getInputStream(), bufferSize),
        new BufferedOutputStream(sock.getSocket().getOutputStream(), bufferSize));
    client = sock.getSocket().getInetAddress().getHostAddress() + ":" + sock.getSocket().getPort();
  }

  public String getClientString() {
    return client;
  }

}
