/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.service.stream.limiter;

import org.apache.bookkeeper.stats.Counter;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.distributedlog.common.rate.MovingAverageRate;
import org.apache.distributedlog.exceptions.OverCapacityException;
import org.apache.distributedlog.exceptions.TooManyStreamsException;
import org.apache.distributedlog.limiter.RequestLimiter;
import org.apache.distributedlog.service.stream.StreamManager;
import org.apache.distributedlog.service.stream.StreamOp;

public class StreamAcquireLimiter
implements RequestLimiter<StreamOp> {
    private final StreamManager streamManager;
    private final MovingAverageRate serviceRps;
    private final double serviceRpsLimit;
    private final Counter overlimitCounter;

    public StreamAcquireLimiter(StreamManager streamManager, MovingAverageRate serviceRps, double serviceRpsLimit, StatsLogger statsLogger) {
        this.streamManager = streamManager;
        this.serviceRps = serviceRps;
        this.serviceRpsLimit = serviceRpsLimit;
        this.overlimitCounter = statsLogger.getCounter("overlimit");
    }

    public void apply(StreamOp op) throws OverCapacityException {
        String streamName = op.streamName();
        if (this.serviceRpsLimit > -1.0 && this.serviceRps.get() > this.serviceRpsLimit && !this.streamManager.isAcquired(streamName)) {
            this.overlimitCounter.inc();
            throw new TooManyStreamsException("Request rate is too high to accept new stream " + streamName + ".");
        }
    }
}

