/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.internal.jshell.tool;

import java.io.IOException;
import java.io.InputStream;
import java.util.function.Consumer;

public final class StopDetectingInputStream
extends InputStream {
    public static final int INITIAL_SIZE = 128;
    private final Runnable stop;
    private final Consumer<Exception> errorHandler;
    private boolean initialized;
    private int[] buffer = new int[128];
    private int start;
    private int end;
    private State state = State.WAIT;

    public StopDetectingInputStream(Runnable stop, Consumer<Exception> errorHandler) {
        this.stop = stop;
        this.errorHandler = errorHandler;
    }

    public synchronized InputStream setInputStream(final InputStream input) {
        if (this.initialized) {
            throw new IllegalStateException("Already initialized.");
        }
        this.initialized = true;
        Thread reader = new Thread(){

            @Override
            public void run() {
                try {
                    while (true) {
                        StopDetectingInputStream.this.waitInputNeeded();
                        int read = input.read();
                        if (read == -1) {
                            break;
                        }
                        if (read == 3 && StopDetectingInputStream.this.state == State.BUFFER) {
                            StopDetectingInputStream.this.stop.run();
                            continue;
                        }
                        StopDetectingInputStream.this.write(read);
                    }
                }
                catch (IOException ex) {
                    StopDetectingInputStream.this.errorHandler.accept(ex);
                }
                finally {
                    StopDetectingInputStream.this.state = State.CLOSED;
                }
            }
        };
        reader.setDaemon(true);
        reader.start();
        return this;
    }

    @Override
    public synchronized int read() {
        while (this.start == this.end) {
            if (this.state == State.CLOSED) {
                return -1;
            }
            if (this.state == State.WAIT) {
                this.state = State.READ;
            }
            this.notifyAll();
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        try {
            int n = this.buffer[this.start];
            return n;
        }
        finally {
            this.start = (this.start + 1) % this.buffer.length;
        }
    }

    public synchronized void write(int b) {
        int newEnd;
        if (this.state != State.BUFFER) {
            this.state = State.WAIT;
        }
        if ((newEnd = (this.end + 1) % this.buffer.length) == this.start) {
            int[] newBuffer = new int[this.buffer.length * 2];
            int rightPart = (this.end > this.start ? this.end : this.buffer.length) - this.start;
            int leftPart = this.end > this.start ? 0 : this.start - 1;
            System.arraycopy(this.buffer, this.start, newBuffer, 0, rightPart);
            System.arraycopy(this.buffer, 0, newBuffer, rightPart, leftPart);
            this.buffer = newBuffer;
            this.start = 0;
            this.end = rightPart + leftPart;
            newEnd = this.end + 1;
        }
        this.buffer[this.end] = b;
        this.end = newEnd;
        this.notifyAll();
    }

    public synchronized void setState(State state) {
        this.state = state;
        this.notifyAll();
    }

    private synchronized void waitInputNeeded() {
        while (this.state == State.WAIT) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public static enum State {
        WAIT,
        READ,
        BUFFER,
        CLOSED;

    }
}

