/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.args.parsers;

import com.google.common.base.Preconditions;
import com.twitter.common.args.ParserOracle;
import com.twitter.common.args.parsers.TypeParameterizedParser;
import com.twitter.common.quantity.Amount;
import com.twitter.common.quantity.Time;
import com.twitter.common.quantity.Unit;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;

public class DurationParser
extends TypeParameterizedParser<Amount<?, ?>> {
    private static final String SUFFIXES = "dhms";
    private static final Time[] TIME_UNITS = new Time[]{Time.DAYS, Time.HOURS, Time.MINUTES, Time.SECONDS};

    public DurationParser() {
        super(2);
    }

    @Override
    Amount<?, ?> doParse(ParserOracle parserOracle, String raw, List<Type> paramParsers) throws IllegalArgumentException {
        Type secondParamClass = paramParsers.get(1);
        Preconditions.checkArgument((secondParamClass == Time.class ? 1 : 0) != 0, (Object)String.format("Expected %s for second type parameter, but got got %s", Time.class.getName(), secondParamClass));
        return DurationParser.parse(raw);
    }

    public static Amount<Long, Time> parse(String spec) {
        long time = 0L;
        ArrayList<Object> tokens = Collections.list(new StringTokenizer(spec, SUFFIXES, true));
        Preconditions.checkArgument((tokens.size() > 1 ? 1 : 0) != 0);
        for (int i = 1; i < tokens.size(); i += 2) {
            String token = (String)tokens.get(i);
            Preconditions.checkArgument((token.length() == 1 ? 1 : 0) != 0, (String)"Too long suffix '%s'", (Object[])new Object[]{token});
            int suffixIndex = SUFFIXES.indexOf(token.charAt(0));
            Preconditions.checkArgument((suffixIndex != -1 ? 1 : 0) != 0, (String)"Unrecognized suffix '%s'", (Object[])new Object[]{token});
            try {
                int value = Integer.parseInt((String)tokens.get(i - 1));
                time += (long)((Integer)Amount.of((int)value, (Unit)TIME_UNITS[suffixIndex]).as((Unit)Time.SECONDS)).intValue();
                continue;
            }
            catch (NumberFormatException e) {
                Preconditions.checkArgument((boolean)false, (String)"Invalid number %s", (Object[])new Object[]{tokens.get(i - 1)});
            }
        }
        return Amount.of((long)time, (Unit)Time.SECONDS);
    }
}

