/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.args.parsers;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.twitter.common.args.parsers.NonParameterizedTypeParser;
import com.twitter.common.quantity.Data;
import com.twitter.common.quantity.Time;
import com.twitter.common.quantity.Unit;
import java.util.EnumSet;
import java.util.Map;

public class UnitParser
extends NonParameterizedTypeParser<Unit<?>> {
    private final Map<String, Unit<?>> unitValues = Maps.uniqueIndex((Iterable)ImmutableList.builder().add((Object[])Time.values()).add((Object[])Data.values()).build(), (Function)Functions.toStringFunction());

    @Override
    public Unit<?> doParse(String raw) {
        Unit<?> unit = this.unitValues.get(raw);
        Preconditions.checkArgument((unit != null ? 1 : 0) != 0, (Object)String.format("No Units found matching %s, options: (Time): %s, (Data): %s", raw, EnumSet.allOf(Time.class), EnumSet.allOf(Data.class)));
        return unit;
    }
}

