/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.javac.util;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Locale;
import java.util.Queue;
import java.util.Set;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileObject;
import org.openjdk.tools.javac.api.DiagnosticFormatter;
import org.openjdk.tools.javac.main.Option;
import org.openjdk.tools.javac.tree.EndPosTable;
import org.openjdk.tools.javac.util.AbstractLog;
import org.openjdk.tools.javac.util.Assert;
import org.openjdk.tools.javac.util.BasicDiagnosticFormatter;
import org.openjdk.tools.javac.util.Context;
import org.openjdk.tools.javac.util.Filter;
import org.openjdk.tools.javac.util.JCDiagnostic;
import org.openjdk.tools.javac.util.JavacMessages;
import org.openjdk.tools.javac.util.ListBuffer;
import org.openjdk.tools.javac.util.Options;
import org.openjdk.tools.javac.util.Pair;
import org.openjdk.tools.javac.util.RawDiagnosticFormatter;

public class Log
extends AbstractLog {
    public static final Context.Key<Log> logKey = new Context.Key();
    public static final Context.Key<PrintWriter> outKey = new Context.Key();
    protected PrintWriter errWriter;
    protected PrintWriter warnWriter;
    protected PrintWriter noticeWriter;
    protected int MaxErrors;
    protected int MaxWarnings;
    public boolean promptOnError;
    public boolean emitWarnings;
    public boolean suppressNotes;
    public boolean dumpOnError;
    protected DiagnosticListener<? super JavaFileObject> diagListener;
    private DiagnosticFormatter<JCDiagnostic> diagFormatter;
    public Set<String> expectDiagKeys;
    public boolean compressedOutput;
    private JavacMessages messages;
    private DiagnosticHandler diagnosticHandler;
    public int nerrors = 0;
    public int nwarnings = 0;
    protected Set<Pair<JavaFileObject, Integer>> recorded = new HashSet<Pair<JavaFileObject, Integer>>();
    private static boolean useRawMessages = false;

    protected Log(Context context, PrintWriter errWriter, PrintWriter warnWriter, PrintWriter noticeWriter) {
        super(JCDiagnostic.Factory.instance(context));
        DiagnosticListener dl;
        context.put(logKey, this);
        this.errWriter = errWriter;
        this.warnWriter = warnWriter;
        this.noticeWriter = noticeWriter;
        this.diagListener = dl = context.get(DiagnosticListener.class);
        this.diagnosticHandler = new DefaultDiagnosticHandler();
        this.messages = JavacMessages.instance(context);
        this.messages.add("org.openjdk.tools.javac.resources.javac");
        final Options options = Options.instance(context);
        this.initOptions(options);
        options.addListener(new Runnable(){

            @Override
            public void run() {
                Log.this.initOptions(options);
            }
        });
    }

    private void initOptions(Options options) {
        this.dumpOnError = options.isSet(Option.DOE);
        this.promptOnError = options.isSet(Option.PROMPT);
        this.emitWarnings = options.isUnset(Option.XLINT_CUSTOM, "none");
        this.suppressNotes = options.isSet("suppressNotes");
        this.MaxErrors = this.getIntOption(options, Option.XMAXERRS, this.getDefaultMaxErrors());
        this.MaxWarnings = this.getIntOption(options, Option.XMAXWARNS, this.getDefaultMaxWarnings());
        boolean rawDiagnostics = options.isSet("rawDiagnostics");
        this.diagFormatter = rawDiagnostics ? new RawDiagnosticFormatter(options) : new BasicDiagnosticFormatter(options, this.messages);
        String ek = options.get("expectKeys");
        if (ek != null) {
            this.expectDiagKeys = new HashSet<String>(Arrays.asList(ek.split(", *")));
        }
    }

    private int getIntOption(Options options, Option option, int defaultValue) {
        String s = options.get(option);
        try {
            if (s != null) {
                int n = Integer.parseInt(s);
                return n <= 0 ? Integer.MAX_VALUE : n;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return defaultValue;
    }

    protected int getDefaultMaxErrors() {
        return 100;
    }

    protected int getDefaultMaxWarnings() {
        return 100;
    }

    static PrintWriter defaultWriter(Context context) {
        PrintWriter result = context.get(outKey);
        if (result == null) {
            result = new PrintWriter(System.err);
            context.put(outKey, result);
        }
        return result;
    }

    protected Log(Context context) {
        this(context, Log.defaultWriter(context));
    }

    protected Log(Context context, PrintWriter defaultWriter) {
        this(context, defaultWriter, defaultWriter, defaultWriter);
    }

    public static Log instance(Context context) {
        Log instance = context.get(logKey);
        if (instance == null) {
            instance = new Log(context);
        }
        return instance;
    }

    public static void preRegister(Context context, PrintWriter w) {
        context.put(Log.class, c -> new Log(c, w));
    }

    public boolean hasDiagnosticListener() {
        return this.diagListener != null;
    }

    public void setEndPosTable(JavaFileObject name, EndPosTable endPosTable) {
        Assert.checkNonNull(name);
        this.getSource(name).setEndPosTable(endPosTable);
    }

    public JavaFileObject currentSourceFile() {
        return this.source == null ? null : this.source.getFile();
    }

    public DiagnosticFormatter<JCDiagnostic> getDiagnosticFormatter() {
        return this.diagFormatter;
    }

    public void setDiagnosticFormatter(DiagnosticFormatter<JCDiagnostic> diagFormatter) {
        this.diagFormatter = diagFormatter;
    }

    public PrintWriter getWriter(WriterKind kind) {
        switch (kind) {
            case NOTICE: {
                return this.noticeWriter;
            }
            case WARNING: {
                return this.warnWriter;
            }
            case ERROR: {
                return this.errWriter;
            }
        }
        throw new IllegalArgumentException();
    }

    public void setWriter(WriterKind kind, PrintWriter pw) {
        Assert.checkNonNull(pw);
        switch (kind) {
            case NOTICE: {
                this.noticeWriter = pw;
                break;
            }
            case WARNING: {
                this.warnWriter = pw;
                break;
            }
            case ERROR: {
                this.errWriter = pw;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public void setWriters(PrintWriter pw) {
        this.warnWriter = this.errWriter = Assert.checkNonNull(pw);
        this.noticeWriter = this.errWriter;
    }

    public void popDiagnosticHandler(DiagnosticHandler h) {
        Assert.check(this.diagnosticHandler == h);
        this.diagnosticHandler = h.prev;
    }

    public void flush() {
        this.errWriter.flush();
        this.warnWriter.flush();
        this.noticeWriter.flush();
    }

    public void flush(WriterKind kind) {
        this.getWriter(kind).flush();
    }

    protected boolean shouldReport(JavaFileObject file, int pos) {
        boolean shouldReport;
        if (file == null) {
            return true;
        }
        Pair<JavaFileObject, Integer> coords = new Pair<JavaFileObject, Integer>(file, pos);
        boolean bl = shouldReport = !this.recorded.contains(coords);
        if (shouldReport) {
            this.recorded.add(coords);
        }
        return shouldReport;
    }

    public void prompt() {
        if (this.promptOnError) {
            System.err.println(this.localize("resume.abort", new Object[0]));
            try {
                while (true) {
                    switch (System.in.read()) {
                        case 65: 
                        case 97: {
                            System.exit(-1);
                            return;
                        }
                        case 82: 
                        case 114: {
                            return;
                        }
                        case 88: 
                        case 120: {
                            throw new AssertionError((Object)"user abort");
                        }
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void printErrLine(int pos, PrintWriter writer) {
        String line;
        String string = line = this.source == null ? null : this.source.getLine(pos);
        if (line == null) {
            return;
        }
        int col = this.source.getColumnNumber(pos, false);
        Log.printRawLines(writer, line);
        for (int i = 0; i < col - 1; ++i) {
            writer.print(line.charAt(i) == '\t' ? "\t" : " ");
        }
        writer.println("^");
        writer.flush();
    }

    public void printNewline() {
        this.noticeWriter.println();
    }

    public void printNewline(WriterKind wk) {
        this.getWriter(wk).println();
    }

    public void printLines(String key, Object ... args) {
        Log.printRawLines(this.noticeWriter, this.localize(key, args));
    }

    public void printLines(PrefixKind pk, String key, Object ... args) {
        Log.printRawLines(this.noticeWriter, this.localize(pk, key, args));
    }

    public void printLines(WriterKind wk, String key, Object ... args) {
        Log.printRawLines(this.getWriter(wk), this.localize(key, args));
    }

    public void printLines(WriterKind wk, PrefixKind pk, String key, Object ... args) {
        Log.printRawLines(this.getWriter(wk), this.localize(pk, key, args));
    }

    public void printRawLines(String msg) {
        Log.printRawLines(this.noticeWriter, msg);
    }

    public void printRawLines(WriterKind kind, String msg) {
        Log.printRawLines(this.getWriter(kind), msg);
    }

    public static void printRawLines(PrintWriter writer, String msg) {
        int nl;
        while ((nl = msg.indexOf(10)) != -1) {
            writer.println(msg.substring(0, nl));
            msg = msg.substring(nl + 1);
        }
        if (msg.length() != 0) {
            writer.println(msg);
        }
    }

    public void printVerbose(String key, Object ... args) {
        Log.printRawLines(this.noticeWriter, this.localize("verbose." + key, args));
    }

    @Override
    protected void directError(String key, Object ... args) {
        Log.printRawLines(this.errWriter, this.localize(key, args));
        this.errWriter.flush();
    }

    public void strictWarning(JCDiagnostic.DiagnosticPosition pos, String key, Object ... args) {
        this.writeDiagnostic(this.diags.warning(null, this.source, pos, key, args));
        ++this.nwarnings;
    }

    @Override
    public void report(JCDiagnostic diagnostic) {
        this.diagnosticHandler.report(diagnostic);
    }

    protected void writeDiagnostic(JCDiagnostic diag) {
        if (this.diagListener != null) {
            this.diagListener.report(diag);
            return;
        }
        PrintWriter writer = this.getWriterForDiagnosticType(diag.getType());
        Log.printRawLines(writer, this.diagFormatter.format(diag, this.messages.getCurrentLocale()));
        if (this.promptOnError) {
            switch (diag.getType()) {
                case WARNING: 
                case ERROR: {
                    this.prompt();
                }
            }
        }
        if (this.dumpOnError) {
            new RuntimeException().printStackTrace(writer);
        }
        writer.flush();
    }

    @Deprecated
    protected PrintWriter getWriterForDiagnosticType(JCDiagnostic.DiagnosticType dt) {
        switch (dt) {
            case FRAGMENT: {
                throw new IllegalArgumentException();
            }
            case NOTE: {
                return this.noticeWriter;
            }
            case WARNING: {
                return this.warnWriter;
            }
            case ERROR: {
                return this.errWriter;
            }
        }
        throw new Error();
    }

    public static String getLocalizedString(String key, Object ... args) {
        return JavacMessages.getDefaultLocalizedString(PrefixKind.COMPILER_MISC.key(key), args);
    }

    public String localize(String key, Object ... args) {
        return this.localize(PrefixKind.COMPILER_MISC, key, args);
    }

    public String localize(PrefixKind pk, String key, Object ... args) {
        if (useRawMessages) {
            return pk.key(key);
        }
        return this.messages.getLocalizedString(pk.key(key), args);
    }

    private void printRawError(int pos, String msg) {
        if (this.source == null || pos == -1) {
            Log.printRawLines(this.errWriter, "error: " + msg);
        } else {
            int line = this.source.getLineNumber(pos);
            JavaFileObject file = this.source.getFile();
            if (file != null) {
                Log.printRawLines(this.errWriter, file.getName() + ":" + line + ": " + msg);
            }
            this.printErrLine(pos, this.errWriter);
        }
        this.errWriter.flush();
    }

    public void rawError(int pos, String msg) {
        if (this.nerrors < this.MaxErrors && this.shouldReport(this.currentSourceFile(), pos)) {
            this.printRawError(pos, msg);
            this.prompt();
            ++this.nerrors;
        }
        this.errWriter.flush();
    }

    public void rawWarning(int pos, String msg) {
        if (this.nwarnings < this.MaxWarnings && this.emitWarnings) {
            this.printRawError(pos, "warning: " + msg);
        }
        this.prompt();
        ++this.nwarnings;
        this.errWriter.flush();
    }

    public static String format(String fmt, Object ... args) {
        return String.format((Locale)null, fmt, args);
    }

    private class DefaultDiagnosticHandler
    extends DiagnosticHandler {
        private DefaultDiagnosticHandler() {
        }

        @Override
        public void report(JCDiagnostic diagnostic) {
            if (Log.this.expectDiagKeys != null) {
                Log.this.expectDiagKeys.remove(diagnostic.getCode());
            }
            switch (diagnostic.getType()) {
                case FRAGMENT: {
                    throw new IllegalArgumentException();
                }
                case NOTE: {
                    if (!Log.this.emitWarnings && !diagnostic.isMandatory() || Log.this.suppressNotes) break;
                    Log.this.writeDiagnostic(diagnostic);
                    break;
                }
                case WARNING: {
                    if (!Log.this.emitWarnings && !diagnostic.isMandatory() || Log.this.nwarnings >= Log.this.MaxWarnings) break;
                    Log.this.writeDiagnostic(diagnostic);
                    ++Log.this.nwarnings;
                    break;
                }
                case ERROR: {
                    if (Log.this.nerrors >= Log.this.MaxErrors || !diagnostic.isFlagSet(JCDiagnostic.DiagnosticFlag.MULTIPLE) && !Log.this.shouldReport(diagnostic.getSource(), diagnostic.getIntPosition())) break;
                    Log.this.writeDiagnostic(diagnostic);
                    ++Log.this.nerrors;
                }
            }
            if (diagnostic.isFlagSet(JCDiagnostic.DiagnosticFlag.COMPRESSED)) {
                Log.this.compressedOutput = true;
            }
        }
    }

    public static enum WriterKind {
        NOTICE,
        WARNING,
        ERROR;

    }

    public static class DeferredDiagnosticHandler
    extends DiagnosticHandler {
        private Queue<JCDiagnostic> deferred = new ListBuffer<JCDiagnostic>();
        private final Filter<JCDiagnostic> filter;

        public DeferredDiagnosticHandler(Log log) {
            this(log, null);
        }

        public DeferredDiagnosticHandler(Log log, Filter<JCDiagnostic> filter) {
            this.filter = filter;
            this.install(log);
        }

        @Override
        public void report(JCDiagnostic diag) {
            if (!diag.isFlagSet(JCDiagnostic.DiagnosticFlag.NON_DEFERRABLE) && (this.filter == null || this.filter.accepts(diag))) {
                this.deferred.add(diag);
            } else {
                this.prev.report(diag);
            }
        }

        public Queue<JCDiagnostic> getDiagnostics() {
            return this.deferred;
        }

        public void reportDeferredDiagnostics() {
            this.reportDeferredDiagnostics(EnumSet.allOf(Diagnostic.Kind.class));
        }

        public void reportDeferredDiagnostics(Set<Diagnostic.Kind> kinds) {
            JCDiagnostic d;
            while ((d = this.deferred.poll()) != null) {
                if (!kinds.contains((Object)d.getKind())) continue;
                this.prev.report(d);
            }
            this.deferred = null;
        }
    }

    public static class DiscardDiagnosticHandler
    extends DiagnosticHandler {
        public DiscardDiagnosticHandler(Log log) {
            this.install(log);
        }

        @Override
        public void report(JCDiagnostic diag) {
        }
    }

    public static abstract class DiagnosticHandler {
        protected DiagnosticHandler prev;

        protected void install(Log log) {
            this.prev = log.diagnosticHandler;
            log.diagnosticHandler = this;
        }

        public abstract void report(JCDiagnostic var1);
    }

    public static enum PrefixKind {
        JAVAC("javac."),
        COMPILER_MISC("compiler.misc.");

        final String value;

        private PrefixKind(String v) {
            this.value = v;
        }

        public String key(String k) {
            return this.value + k;
        }
    }
}

