/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.javadoc.internal.doclets.formats.html;

import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.TypeMirror;
import org.openjdk.source.doctree.DocTree;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.AbstractExecutableMemberWriter;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.AnnotationTypeWriterImpl;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.ClassWriterImpl;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.ConfigurationImpl;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.LinkInfoImpl;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.SubWriterHolderWriter;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.markup.HtmlAttr;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.markup.HtmlConstants;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.markup.HtmlStyle;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.markup.HtmlTag;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.markup.HtmlTree;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.markup.StringContent;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.Content;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.taglets.DeprecatedTaglet;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.util.MethodTypes;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.util.Utils;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.util.VisibleMemberMap;

public abstract class AbstractMemberWriter {
    protected final ConfigurationImpl configuration;
    protected final Utils utils;
    protected final SubWriterHolderWriter writer;
    protected final TypeElement typeElement;
    protected Map<String, Integer> typeMap = new LinkedHashMap<String, Integer>();
    protected Set<MethodTypes> methodTypes = EnumSet.noneOf(MethodTypes.class);
    private int methodTypesOr = 0;
    public final boolean nodepr;
    protected boolean printedSummaryHeader = false;

    public AbstractMemberWriter(SubWriterHolderWriter writer, TypeElement typeElement) {
        this.configuration = writer.configuration;
        this.writer = writer;
        this.nodepr = this.configuration.nodeprecated;
        this.typeElement = typeElement;
        this.utils = writer.configuration.utils;
    }

    public AbstractMemberWriter(SubWriterHolderWriter writer) {
        this(writer, null);
    }

    public abstract void addSummaryLabel(Content var1);

    public abstract String getTableSummary();

    public abstract Content getCaption();

    public abstract List<String> getSummaryTableHeader(Element var1);

    public abstract void addInheritedSummaryLabel(TypeElement var1, Content var2);

    public abstract void addSummaryAnchor(TypeElement var1, Content var2);

    public abstract void addInheritedSummaryAnchor(TypeElement var1, Content var2);

    protected abstract void addSummaryType(Element var1, Content var2);

    protected void addSummaryLink(TypeElement typeElement, Element member, Content tdSummary) {
        this.addSummaryLink(LinkInfoImpl.Kind.MEMBER, typeElement, member, tdSummary);
    }

    protected abstract void addSummaryLink(LinkInfoImpl.Kind var1, TypeElement var2, Element var3, Content var4);

    protected abstract void addInheritedSummaryLink(TypeElement var1, Element var2, Content var3);

    protected abstract Content getDeprecatedLink(Element var1);

    protected abstract Content getNavSummaryLink(TypeElement var1, boolean var2);

    protected abstract void addNavDetailLink(boolean var1, Content var2);

    protected void addName(String name, Content htmltree) {
        htmltree.addContent(name);
    }

    protected void addModifiers(Element member, Content htmltree) {
        TreeSet<Modifier> set = new TreeSet<Modifier>(member.getModifiers());
        set.remove((Object)Modifier.NATIVE);
        set.remove((Object)Modifier.SYNCHRONIZED);
        set.remove((Object)Modifier.STRICTFP);
        if ((this.utils.isField(member) || this.utils.isMethod(member)) && (this.writer instanceof ClassWriterImpl && this.utils.isInterface(((ClassWriterImpl)this.writer).getTypeElement()) || this.writer instanceof AnnotationTypeWriterImpl)) {
            if (this.utils.isMethod(member) && (this.utils.isInterface(member.getEnclosingElement()) || this.utils.isAnnotationType(member.getEnclosingElement()))) {
                set.remove((Object)Modifier.ABSTRACT);
                set.remove((Object)Modifier.PUBLIC);
            }
            if (!this.utils.isMethod(member)) {
                set.remove((Object)Modifier.PUBLIC);
            }
        }
        if (!set.isEmpty()) {
            String mods = set.stream().map(m -> m.toString()).collect(Collectors.joining(" "));
            htmltree.addContent(mods);
            htmltree.addContent(this.writer.getSpace());
        }
    }

    protected CharSequence makeSpace(int len) {
        if (len <= 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            sb.append(' ');
        }
        return sb;
    }

    protected void addModifierAndType(Element member, TypeMirror type, Content tdSummaryType) {
        HtmlTree code = new HtmlTree(HtmlTag.CODE);
        this.addModifier(member, code);
        if (type == null) {
            code.addContent(this.utils.isClass(member) ? "class" : "interface");
            code.addContent(this.writer.getSpace());
        } else {
            List<? extends TypeParameterElement> list;
            List<? extends TypeParameterElement> list2 = list = this.utils.isExecutableElement(member) ? ((ExecutableElement)member).getTypeParameters() : null;
            if (list != null && !list.isEmpty()) {
                Content typeParameters = ((AbstractExecutableMemberWriter)this).getTypeParameters((ExecutableElement)member);
                code.addContent(typeParameters);
                if (typeParameters.charCount() > 10) {
                    code.addContent(new HtmlTree(HtmlTag.BR));
                } else {
                    code.addContent(this.writer.getSpace());
                }
                code.addContent(this.writer.getLink(new LinkInfoImpl(this.configuration, LinkInfoImpl.Kind.SUMMARY_RETURN_TYPE, type)));
            } else {
                code.addContent(this.writer.getLink(new LinkInfoImpl(this.configuration, LinkInfoImpl.Kind.SUMMARY_RETURN_TYPE, type)));
            }
        }
        tdSummaryType.addContent(code);
    }

    private void addModifier(Element member, Content code) {
        if (this.utils.isProtected(member)) {
            code.addContent("protected ");
        } else if (this.utils.isPrivate(member)) {
            code.addContent("private ");
        } else if (!this.utils.isPublic(member)) {
            code.addContent(this.configuration.getText("doclet.Package_private"));
            code.addContent(" ");
        }
        boolean isAnnotatedTypeElement = this.utils.isAnnotationType(member.getEnclosingElement());
        if (!isAnnotatedTypeElement && this.utils.isMethod(member)) {
            if (!this.utils.isInterface(member.getEnclosingElement()) && this.utils.isAbstract(member)) {
                code.addContent("abstract ");
            }
            if (this.utils.isDefault(member)) {
                code.addContent("default ");
            }
        }
        if (this.utils.isStatic(member)) {
            code.addContent("static ");
        }
    }

    protected void addDeprecatedInfo(Element member, Content contentTree) {
        Content output = new DeprecatedTaglet().getTagletOutput(member, this.writer.getTagletWriterInstance(false));
        if (!output.isEmpty()) {
            Content deprecatedContent = output;
            HtmlTree div = HtmlTree.DIV(HtmlStyle.block, deprecatedContent);
            contentTree.addContent(div);
        }
    }

    protected void addComment(Element member, Content htmltree) {
        if (!this.utils.getBody(member).isEmpty()) {
            this.writer.addInlineComment(member, htmltree);
        }
    }

    protected String name(Element member) {
        return this.utils.getSimpleName(member);
    }

    protected Content getHead(Element member) {
        StringContent memberContent = new StringContent(this.name(member));
        HtmlTree heading = HtmlTree.HEADING(HtmlConstants.MEMBER_HEADING, memberContent);
        return heading;
    }

    protected boolean isInherited(Element ped) {
        return !this.utils.isPrivate(ped) && (!this.utils.isPackagePrivate(ped) || ped.getEnclosingElement().equals(ped.getEnclosingElement()));
    }

    protected void addDeprecatedAPI(Collection<Element> deprmembers, String headingKey, String tableSummary, List<String> tableHeader, Content contentTree) {
        if (deprmembers.size() > 0) {
            Content caption = this.writer.getTableCaption(this.configuration.getResource(headingKey));
            HtmlTree table = this.configuration.isOutputHtml5() ? HtmlTree.TABLE(HtmlStyle.deprecatedSummary, caption) : HtmlTree.TABLE(HtmlStyle.deprecatedSummary, tableSummary, caption);
            ((Content)table).addContent(this.writer.getSummaryTableHeader(tableHeader, "col"));
            HtmlTree tbody = new HtmlTree(HtmlTag.TBODY);
            boolean altColor = true;
            for (Element member : deprmembers) {
                HtmlTree td = HtmlTree.TD(HtmlStyle.colOne, this.getDeprecatedLink(member));
                List<? extends DocTree> deprTrees = this.utils.getBlockTags(member, DocTree.Kind.DEPRECATED);
                if (!deprTrees.isEmpty()) {
                    this.writer.addInlineDeprecatedComment(member, deprTrees.get(0), td);
                }
                HtmlTree tr = HtmlTree.TR(td);
                tr.addStyle(altColor ? HtmlStyle.altColor : HtmlStyle.rowColor);
                altColor = !altColor;
                ((Content)tbody).addContent(tr);
            }
            ((Content)table).addContent(tbody);
            HtmlTree li = HtmlTree.LI(HtmlStyle.blockList, table);
            HtmlTree ul = HtmlTree.UL(HtmlStyle.blockList, li);
            contentTree.addContent(ul);
        }
    }

    protected void addUseInfo(List<? extends Element> mems, Content heading, String tableSummary, Content contentTree) {
        if (mems == null || mems.isEmpty()) {
            return;
        }
        List<? extends Element> members = mems;
        boolean printedUseTableHeader = false;
        if (members.size() > 0) {
            Content caption = this.writer.getTableCaption(heading);
            HtmlTree table = this.configuration.isOutputHtml5() ? HtmlTree.TABLE(HtmlStyle.useSummary, caption) : HtmlTree.TABLE(HtmlStyle.useSummary, tableSummary, caption);
            HtmlTree tbody = new HtmlTree(HtmlTag.TBODY);
            boolean altColor = true;
            for (Element element : members) {
                TypeElement te = this.utils.getEnclosingTypeElement(element);
                if (!printedUseTableHeader) {
                    ((Content)table).addContent(this.writer.getSummaryTableHeader(this.getSummaryTableHeader(element), "col"));
                    printedUseTableHeader = true;
                }
                HtmlTree tr = new HtmlTree(HtmlTag.TR);
                tr.addStyle(altColor ? HtmlStyle.altColor : HtmlStyle.rowColor);
                altColor = !altColor;
                HtmlTree tdFirst = new HtmlTree(HtmlTag.TD);
                tdFirst.addStyle(HtmlStyle.colFirst);
                this.writer.addSummaryType(this, element, tdFirst);
                tr.addContent(tdFirst);
                HtmlTree tdLast = new HtmlTree(HtmlTag.TD);
                tdLast.addStyle(HtmlStyle.colLast);
                if (!(te == null || this.utils.isConstructor(element) || this.utils.isClass(element) || this.utils.isInterface(element) || this.utils.isAnnotationType(element))) {
                    HtmlTree name = new HtmlTree(HtmlTag.SPAN);
                    name.addStyle(HtmlStyle.typeNameLabel);
                    name.addContent(this.name(te) + ".");
                    tdLast.addContent(name);
                }
                this.addSummaryLink(this.utils.isClass(element) || this.utils.isInterface(element) ? LinkInfoImpl.Kind.CLASS_USE : LinkInfoImpl.Kind.MEMBER, te, element, tdLast);
                this.writer.addSummaryLinkComment(this, element, tdLast);
                tr.addContent(tdLast);
                ((Content)tbody).addContent(tr);
            }
            ((Content)table).addContent(tbody);
            contentTree.addContent(table);
        }
    }

    protected void addNavDetailLink(SortedSet<Element> members, Content liNav) {
        this.addNavDetailLink(!members.isEmpty(), liNav);
    }

    protected void addNavSummaryLink(SortedSet<? extends Element> members, VisibleMemberMap visibleMemberMap, Content liNav) {
        if (!members.isEmpty()) {
            liNav.addContent(this.getNavSummaryLink(null, true));
            return;
        }
        TypeElement superClass = this.utils.getSuperClass(this.typeElement);
        while (superClass != null) {
            if (visibleMemberMap.hasMembersFor(superClass)) {
                liNav.addContent(this.getNavSummaryLink(superClass, true));
                return;
            }
            superClass = this.utils.getSuperClass(superClass);
        }
        liNav.addContent(this.getNavSummaryLink(null, false));
    }

    protected void serialWarning(Element e, String key, String a1, String a2) {
        if (this.configuration.serialwarn) {
            this.configuration.getDocletSpecificMsg().warning(e, key, a1, a2);
        }
    }

    public void addMemberSummary(TypeElement tElement, Element member, List<? extends DocTree> firstSentenceTags, List<Content> tableContents, int counter) {
        HtmlTree tdSummaryType = new HtmlTree(HtmlTag.TD);
        tdSummaryType.addStyle(HtmlStyle.colFirst);
        this.writer.addSummaryType(this, member, tdSummaryType);
        HtmlTree tdSummary = new HtmlTree(HtmlTag.TD);
        this.setSummaryColumnStyle(tdSummary);
        this.addSummaryLink(tElement, member, tdSummary);
        this.writer.addSummaryLinkComment(this, member, firstSentenceTags, tdSummary);
        HtmlTree tr = HtmlTree.TR(tdSummaryType);
        tr.addContent(tdSummary);
        if (this.utils.isMethod(member) && !this.utils.isAnnotationType(member)) {
            int methodType;
            int n = methodType = this.utils.isStatic(member) ? MethodTypes.STATIC.value() : MethodTypes.INSTANCE.value();
            if (this.utils.isInterface(member.getEnclosingElement())) {
                methodType = this.utils.isAbstract(member) ? methodType | MethodTypes.ABSTRACT.value() : methodType | MethodTypes.DEFAULT.value();
            } else {
                int n2 = methodType = this.utils.isAbstract(member) ? methodType | MethodTypes.ABSTRACT.value() : methodType | MethodTypes.CONCRETE.value();
            }
            if (this.utils.isDeprecated(member) || this.utils.isDeprecated(this.typeElement)) {
                methodType |= MethodTypes.DEPRECATED.value();
            }
            this.methodTypesOr |= methodType;
            String tableId = "i" + counter;
            this.typeMap.put(tableId, methodType);
            tr.addAttr(HtmlAttr.ID, tableId);
        }
        if (counter % 2 == 0) {
            tr.addStyle(HtmlStyle.altColor);
        } else {
            tr.addStyle(HtmlStyle.rowColor);
        }
        tableContents.add(tr);
    }

    public boolean showTabs() {
        boolean showTabs;
        for (MethodTypes type : EnumSet.allOf(MethodTypes.class)) {
            int value = type.value();
            if ((value & this.methodTypesOr) != value) continue;
            this.methodTypes.add(type);
        }
        boolean bl = showTabs = this.methodTypes.size() > 1;
        if (showTabs) {
            this.methodTypes.add(MethodTypes.ALL);
        }
        return showTabs;
    }

    public void setSummaryColumnStyle(HtmlTree tdTree) {
        tdTree.addStyle(HtmlStyle.colLast);
    }

    public void addInheritedMemberSummary(TypeElement tElement, Element nestedClass, boolean isFirst, boolean isLast, Content linksTree) {
        this.writer.addInheritedMemberSummary(this, tElement, nestedClass, isFirst, linksTree);
    }

    public Content getInheritedSummaryHeader(TypeElement tElement) {
        Content inheritedTree = this.writer.getMemberTreeHeader();
        this.writer.addInheritedSummaryHeader(this, tElement, inheritedTree);
        return inheritedTree;
    }

    public Content getInheritedSummaryLinksTree() {
        return new HtmlTree(HtmlTag.CODE);
    }

    public Content getSummaryTableTree(TypeElement tElement, List<Content> tableContents) {
        return this.writer.getSummaryTableTree(this, tElement, tableContents, this.showTabs());
    }

    public Content getMemberTree(Content memberTree) {
        return this.writer.getMemberTree(memberTree);
    }

    public Content getMemberTree(Content memberTree, boolean isLastContent) {
        if (isLastContent) {
            return HtmlTree.UL(HtmlStyle.blockListLast, memberTree);
        }
        return HtmlTree.UL(HtmlStyle.blockList, memberTree);
    }
}

