/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.javadoc.internal.doclets.formats.html;

import java.io.IOException;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.AnnotationTypeFieldWriterImpl;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.AnnotationTypeOptionalMemberWriterImpl;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.AnnotationTypeRequiredMemberWriterImpl;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.AnnotationTypeWriterImpl;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.ClassWriterImpl;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.ConfigurationImpl;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.ConstantsSummaryWriterImpl;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.ConstructorWriterImpl;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.EnumConstantWriterImpl;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.FieldWriterImpl;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.MethodWriterImpl;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.NestedClassWriterImpl;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.PackageWriterImpl;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.PropertyWriterImpl;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.SerializedFormWriterImpl;
import org.openjdk.tools.javadoc.internal.doclets.formats.html.SubWriterHolderWriter;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.AnnotationTypeFieldWriter;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.AnnotationTypeOptionalMemberWriter;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.AnnotationTypeRequiredMemberWriter;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.AnnotationTypeWriter;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.ClassWriter;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.ConstantsSummaryWriter;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.MemberSummaryWriter;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.PackageSummaryWriter;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.SerializedFormWriter;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.WriterFactory;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.util.ClassTree;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.util.VisibleMemberMap;

public class WriterFactoryImpl
implements WriterFactory {
    private final ConfigurationImpl configuration;

    public WriterFactoryImpl(ConfigurationImpl configuration) {
        this.configuration = configuration;
    }

    @Override
    public ConstantsSummaryWriter getConstantsSummaryWriter() throws Exception {
        return new ConstantsSummaryWriterImpl(this.configuration);
    }

    @Override
    public PackageSummaryWriter getPackageSummaryWriter(PackageElement packageElement, PackageElement prevPkg, PackageElement nextPkg) throws Exception {
        return new PackageWriterImpl(this.configuration, packageElement, prevPkg, nextPkg);
    }

    @Override
    public ClassWriter getClassWriter(TypeElement typeElement, TypeElement prevClass, TypeElement nextClass, ClassTree classTree) throws IOException {
        return new ClassWriterImpl(this.configuration, typeElement, prevClass, nextClass, classTree);
    }

    @Override
    public AnnotationTypeWriter getAnnotationTypeWriter(TypeElement annotationType, TypeMirror prevType, TypeMirror nextType) throws Exception {
        return new AnnotationTypeWriterImpl(this.configuration, annotationType, prevType, nextType);
    }

    @Override
    public AnnotationTypeFieldWriter getAnnotationTypeFieldWriter(AnnotationTypeWriter annotationTypeWriter) throws Exception {
        TypeElement te = annotationTypeWriter.getAnnotationTypeElement();
        return new AnnotationTypeFieldWriterImpl((SubWriterHolderWriter)((Object)annotationTypeWriter), te);
    }

    @Override
    public AnnotationTypeOptionalMemberWriter getAnnotationTypeOptionalMemberWriter(AnnotationTypeWriter annotationTypeWriter) throws Exception {
        TypeElement te = annotationTypeWriter.getAnnotationTypeElement();
        return new AnnotationTypeOptionalMemberWriterImpl((SubWriterHolderWriter)((Object)annotationTypeWriter), te);
    }

    @Override
    public AnnotationTypeRequiredMemberWriter getAnnotationTypeRequiredMemberWriter(AnnotationTypeWriter annotationTypeWriter) throws Exception {
        TypeElement te = annotationTypeWriter.getAnnotationTypeElement();
        return new AnnotationTypeRequiredMemberWriterImpl((SubWriterHolderWriter)((Object)annotationTypeWriter), te);
    }

    @Override
    public EnumConstantWriterImpl getEnumConstantWriter(ClassWriter classWriter) throws Exception {
        return new EnumConstantWriterImpl((SubWriterHolderWriter)((Object)classWriter), classWriter.getTypeElement());
    }

    @Override
    public FieldWriterImpl getFieldWriter(ClassWriter classWriter) throws Exception {
        return new FieldWriterImpl((SubWriterHolderWriter)((Object)classWriter), classWriter.getTypeElement());
    }

    @Override
    public PropertyWriterImpl getPropertyWriter(ClassWriter classWriter) throws Exception {
        return new PropertyWriterImpl((SubWriterHolderWriter)((Object)classWriter), classWriter.getTypeElement());
    }

    @Override
    public MethodWriterImpl getMethodWriter(ClassWriter classWriter) throws Exception {
        return new MethodWriterImpl((SubWriterHolderWriter)((Object)classWriter), classWriter.getTypeElement());
    }

    @Override
    public ConstructorWriterImpl getConstructorWriter(ClassWriter classWriter) throws Exception {
        return new ConstructorWriterImpl((SubWriterHolderWriter)((Object)classWriter), classWriter.getTypeElement());
    }

    @Override
    public MemberSummaryWriter getMemberSummaryWriter(ClassWriter classWriter, VisibleMemberMap.Kind memberType) throws Exception {
        switch (memberType) {
            case CONSTRUCTORS: {
                return this.getConstructorWriter(classWriter);
            }
            case ENUM_CONSTANTS: {
                return this.getEnumConstantWriter(classWriter);
            }
            case FIELDS: {
                return this.getFieldWriter(classWriter);
            }
            case PROPERTIES: {
                return this.getPropertyWriter(classWriter);
            }
            case INNER_CLASSES: {
                return new NestedClassWriterImpl((SubWriterHolderWriter)((Object)classWriter), classWriter.getTypeElement());
            }
            case METHODS: {
                return this.getMethodWriter(classWriter);
            }
        }
        return null;
    }

    @Override
    public MemberSummaryWriter getMemberSummaryWriter(AnnotationTypeWriter annotationTypeWriter, VisibleMemberMap.Kind memberType) throws Exception {
        switch (memberType) {
            case ANNOTATION_TYPE_FIELDS: {
                return (AnnotationTypeFieldWriterImpl)this.getAnnotationTypeFieldWriter(annotationTypeWriter);
            }
            case ANNOTATION_TYPE_MEMBER_OPTIONAL: {
                return (AnnotationTypeOptionalMemberWriterImpl)this.getAnnotationTypeOptionalMemberWriter(annotationTypeWriter);
            }
            case ANNOTATION_TYPE_MEMBER_REQUIRED: {
                return (AnnotationTypeRequiredMemberWriterImpl)this.getAnnotationTypeRequiredMemberWriter(annotationTypeWriter);
            }
        }
        return null;
    }

    @Override
    public SerializedFormWriter getSerializedFormWriter() throws Exception {
        return new SerializedFormWriterImpl(this.configuration);
    }
}

